﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/os/os_SystemEventTypes.h>

namespace nn { namespace xcd { namespace detail{

class IBluetoothDriver
{
public:
    virtual ~IBluetoothDriver() NN_NOEXCEPT { /* 何もしない */ };

    //!< Bluetooth をアクティベートする
    virtual bool Activate() NN_NOEXCEPT = 0;

    //!< Bluetooth を非アクティベートする
    virtual void Deactivate() NN_NOEXCEPT = 0;

    //!< ペアリングを開始する
    virtual void StartButtonPairing(nn::os::SystemEventType* pSystemEvent) NN_NOEXCEPT = 0;

    //!< ペアリングを終了する
    virtual void CancelButtonPairing() NN_NOEXCEPT = 0;

    //!< ペアリング情報を削除する
    virtual void ClearPairingDatabase() NN_NOEXCEPT = 0;

    //!< 前回のペアリングの結果を返す
    virtual bool IsLastPairingSuccessful() NN_NOEXCEPT = 0;
};

}}} // namespace nn::xcd::detail
