﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Result.h>
#include <nn/applet/applet.h>
#include <nn/xcd/xcd_Input.h>
#include <nerd/nerd_DScaleProcessor.h>

namespace nn { namespace xcd { namespace detail {

class DScaleProcessor
{
    NN_DISALLOW_COPY(DScaleProcessor);
    NN_DISALLOW_MOVE(DScaleProcessor);

public:

    DScaleProcessor() NN_NOEXCEPT;

    ~DScaleProcessor() NN_NOEXCEPT;

    void SetAppletResourceUserId(const ::nn::applet::AppletResourceUserId& id) NN_NOEXCEPT;

    ::nn::applet::AppletResourceUserId GetAppletResourceUserId() NN_NOEXCEPT;

    bool IsWorkBufferAllocated() const NN_NOEXCEPT;

    void Reset() NN_NOEXCEPT;

    void InsertOneState(nn::xcd::SixAxisSensorRawParsing const (&state)[3], nn::xcd::SixAxisSensorState(&outputState)[3], uint32_t& outputStateCount, uint32_t iMode);

private:


private:

    nerd::DScaleProcessor m_DScaleProcessor;

    ::nn::applet::AppletResourceUserId m_AppletResourceUserId;
    bool m_IsWorkBufferAllocated;
};

}}} // namespace nn::hid::detail

