﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Macro.h>
#include <nn/bluetooth/bluetooth_AddressTypes.h>
#include "../xcd_IBleCommandListener.h"
#include "xcd_IBleNhogClient.h"
#include "xcd_IBleNbatClient.h"

namespace nn { namespace xcd { namespace detail {

//!< BleInputReport を解析する関数
typedef void(*BleInputReportParserFunc)(void*, const uint8_t*, size_t);

//!< BleCommandResponse を解析する関数
typedef void(*BleCommandResponseParserFunc)(void*, const uint8_t*, size_t);

//!< 汎用的なHidデバイスを扱うクラス
class BleHidAccessor
{
public:
    BleHidAccessor() NN_NOEXCEPT { /* 何もしない */ };
    virtual ~BleHidAccessor() NN_NOEXCEPT { /* 何もしない */ };

    //!< InputReport のサンプリングを開始
    virtual void StartInputReport(BleInputReportParserFunc func, void* pArg) NN_NOEXCEPT = 0;

    //!< InputReport のサンプリングを停止
    virtual void StopInputReport() NN_NOEXCEPT = 0;

    //!< CommandResponse を有効化
    virtual void ActivateCommandResponse(BleCommandResponseParserFunc func, void* pArg) NN_NOEXCEPT = 0;

    //!< CommandResponse を無効化
    virtual void DeactivateCommandResponse() NN_NOEXCEPT = 0;

    //!< デバイスを切断する
    virtual void DetachDevice() NN_NOEXCEPT = 0;

    //!< コマンドリスナーを設定する
    virtual void SetListener(IBleCommandListener* pListener) NN_NOEXCEPT
    {
        NN_UNUSED(pListener);
    };

    //!< MTU を変更する
    virtual void ConfigureBleMtu(uint16_t mtu) NN_NOEXCEPT
    {
        NN_UNUSED(mtu);
        // 何もしない
    };

    //!< デバイスアドレスを取得する
    virtual void GetDeviceAddress(::nn::bluetooth::Address* pAddress) NN_NOEXCEPT
    {
        NN_UNUSED(pAddress);
        // デフォルト環境では取得できない
        return;
    };

    //!< Nintendo Hid over Gatt サービスのクライアントを取得する
    virtual IBleNhogClient* GetBleNhogClient() NN_NOEXCEPT
    {
        // デフォルト環境では取得できない
        return nullptr;
    };


    //!< Nintendo Battery サービスのクライアントを取得する
    virtual IBleNbatClient* GetBleNbatClient() NN_NOEXCEPT
    {
        // デフォルト環境では取得できない
        return nullptr;
    }


};

}}} // namespace nn::xcd::detail
