﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nn { namespace xcd { namespace detail{

//!< GATT 操作の状態
enum GattOperationStatus
{
    GattOperationStatus_Empty,             //!< キューが空の状態
    GattOperationStatus_Queued,            //!< キューにセットされた状態
    GattOperationStatus_Sent,              //!< Callback を待っている状態
};

//!< GATT Attribute の操作方法を示す列挙型
enum GattOperationType
{
    GattOperationType_ReadCharacteristic = 0,
    GattOperationType_WriteCharacteristic,
    GattOperationType_ReadDescriptor,
    GattOperationType_WriteDescriptor,
};

const size_t GattOperationPayloadMaxLength = 512;

//!< 送信するデータの定義
struct GattOperationPayload
{
    size_t length;        //!< DataPtr の指すデータのサイズ
    const void*  dataptr; //!< データへのポインタ
};

}}} // namespace nn::xcd::detail
