﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/sf/sf_Types.h>
#include <nn/sf/sf_HipcClient.h>
#include "detail/wlan_IWlanManagers.sfdl.h"

namespace nn { namespace wlan {

// 実装オブジェクトに直接アクセスする場合に、オブジェクトへの参照を取得する関数
// WLANではクライアント側ではHIPC呼び出しのみで十分なため、DFC版は不要
nn::sf::SharedPointer<detail::IInfraManager>  CreateInfraManagerByHipc(nn::sf::HipcSimpleClientSessionManager* pManager) NN_NOEXCEPT;
nn::sf::SharedPointer<detail::ILocalManager>  CreateLocalManagerByHipc(nn::sf::HipcSimpleClientSessionManager* pManager) NN_NOEXCEPT;
nn::sf::SharedPointer<detail::ISocketManager> CreateSocketManagerByHipc(nn::sf::HipcSimpleClientSessionManager* pManager) NN_NOEXCEPT;
nn::sf::SharedPointer<detail::ILocalGetFrame>  CreateLocalGetFrameManagerByHipc(nn::sf::HipcSimpleClientSessionManager* pManager) NN_NOEXCEPT;
nn::sf::SharedPointer<detail::ILocalGetActionFrame>  CreateLocalGetActionFrameManagerByHipc(nn::sf::HipcSimpleClientSessionManager* pManager) NN_NOEXCEPT;
nn::sf::SharedPointer<detail::ISocketGetFrame> CreateSocketGetFrameManagerByHipc(nn::sf::HipcSimpleClientSessionManager* pManager) NN_NOEXCEPT;
nn::sf::SharedPointer<detail::IDetectManager>  CreateDetectManagerByHipc(nn::sf::HipcSimpleClientSessionManager* pManager) NN_NOEXCEPT;

}}  // nn::wlan

