﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

// このファイルは SFDL による自動生成ファイルです。
// 手動で変更しないでください。
// This file is auto-generated by the SFDL code generator.
// Do not modify manually.

#include <cstdint>
#include <nn/nn_BitTypes.h>
#include <nn/nn_Result.h>
#include <nn/sf/sf_NativeHandle.h>
#include <nn/sf/sf_Types.h>
#include <nn/wlan/wlan_Types.h>
#include <nn/sf/cmif/detail/sf_CmifAutogenInterfaceIncludes.h>
#include <nn/sf/detail/sf_AutogenInterfaceIncludes.h>
#include <nn/sf/impl/detail/sf_AutogenImplIncludes.h>

namespace nn { namespace wlan { namespace detail { // NOLINT(whitespace/braces)

class IDetectManager;

class IInfraManager;

class ILocalGetActionFrame;

class ILocalGetFrame;

class ILocalManager;

class ISocketGetFrame;

class ISocketManager;

struct SfdlBssInfo;

struct SfdlChannelList;

struct SfdlClientStatus;

struct SfdlClientStatusList;

struct SfdlConnectionStatus;

struct SfdlDisconnectClient;

struct SfdlMacAddress;

struct SfdlMasterBssParameters;

struct SfdlMulticastFilterInfo;

struct SfdlScanIeMatchInfo;

struct SfdlScanParameters;

struct SfdlSecurity;

struct SfdlSsid;

struct SfdlMacAddress
{
    std::uint8_t data[6];
};

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IDetectManager, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IDetectManager)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(OpenMode)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(OpenModeWithChannel, (::std::uint16_t channel))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CloseMode)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetMacAddress, (::nn::sf::Out<::nn::wlan::detail::SfdlMacAddress> pOutMacAddr))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::std::uint32_t> pOutState))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PutActionFrameOneShot, (::nn::wlan::detail::SfdlMacAddress macAddr, ::std::uint8_t subtype, ::nn::wlan::DetectHash hash, const ::nn::sf::InBuffer& pTxData, ::std::uint32_t dwellTime))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartPeriodicActionFrame, (::std::uint8_t subtype, ::nn::wlan::DetectHash hash, const ::nn::sf::InBuffer& pTxData, ::std::uint32_t interval))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CancelPeriodicActionFrame)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetActionFrame, (::nn::sf::Out<::nn::wlan::detail::SfdlMacAddress> pOutMacAddr, const ::nn::sf::OutBuffer& pOutRxData, ::nn::sf::Out<::std::uint32_t> pOutSize, ::std::uint32_t rxId, ::nn::sf::Out<::std::uint16_t> pOutChannel, ::nn::sf::Out<::std::int16_t> pOutRssi, ::nn::sf::Out<::std::int64_t> pOutTick))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CancelGetActionFrame, (::std::uint32_t rxId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateRxEntryForActionFrame, (::nn::sf::Out<::std::uint32_t> pOutRxId, const ::nn::sf::InArray<::std::uint16_t>& pSubtypeArray, ::std::uint32_t capacity))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteRxEntryForActionFrame, (::std::uint32_t rxId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AddSubtypeToRxEntryForActionFrame, (::std::uint32_t rxId, ::std::uint32_t type))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteSubtypeFromRxEntryForActionFrame, (::nn::sf::Out<::std::uint32_t> pOutRxId, ::std::uint32_t type))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ReserveDetectSleep)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CancelDetectSleep)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetActionFrameForSleep, (::std::uint8_t subtype, ::nn::wlan::DetectHash hash, const ::nn::sf::InBuffer& pTxData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetHashList, (const ::nn::sf::InBuffer& pHashList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetPeriodicActionFrameCycle, (const ::nn::wlan::DetectPeriodicAfCycle& pattern, ::std::uint8_t target))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(RequestSleep)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(RequestWakeUp)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PutActionFrameOneShotEx, (::nn::wlan::detail::SfdlMacAddress macAddr, ::nn::wlan::detail::SfdlMacAddress bssid, ::std::uint8_t subtype, const ::nn::wlan::DetectHeader& dhp, const ::nn::sf::InBuffer& pTxData, ::std::uint32_t dwellTime))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(StartCommunication)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(StopCommunication)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetMacAddress, (::nn::wlan::detail::SfdlMacAddress macAddr))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAllowedChannels, (const ::nn::sf::OutArray<::std::int16_t>& outArray, ::nn::sf::Out<::std::uint32_t> pOutCount))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetTotalRecvCountInSleep, (::nn::sf::Out<::std::uint64_t> pOutCount))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(ClearTotalRecvCountInSleep)
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IDetectManager)

        ::nn::Result OpenMode() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(OpenMode);
        }

        ::nn::Result OpenModeWithChannel(::std::uint16_t channel) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(OpenModeWithChannel, (channel));
        }

        ::nn::Result CloseMode() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CloseMode);
        }

        ::nn::Result GetMacAddress(::nn::sf::Out<::nn::wlan::detail::SfdlMacAddress> pOutMacAddr) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetMacAddress, (pOutMacAddr));
        }

        ::nn::Result GetState(::nn::sf::Out<::std::uint32_t> pOutState) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetState, (pOutState));
        }

        ::nn::Result PutActionFrameOneShot(::nn::wlan::detail::SfdlMacAddress macAddr, ::std::uint8_t subtype, ::nn::wlan::DetectHash hash, const ::nn::sf::InBuffer& pTxData, ::std::uint32_t dwellTime) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PutActionFrameOneShot, (macAddr, subtype, hash, pTxData, dwellTime));
        }

        ::nn::Result StartPeriodicActionFrame(::std::uint8_t subtype, ::nn::wlan::DetectHash hash, const ::nn::sf::InBuffer& pTxData, ::std::uint32_t interval) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartPeriodicActionFrame, (subtype, hash, pTxData, interval));
        }

        ::nn::Result CancelPeriodicActionFrame() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CancelPeriodicActionFrame);
        }

        ::nn::Result GetActionFrame(::nn::sf::Out<::nn::wlan::detail::SfdlMacAddress> pOutMacAddr, const ::nn::sf::OutBuffer& pOutRxData, ::nn::sf::Out<::std::uint32_t> pOutSize, ::std::uint32_t rxId, ::nn::sf::Out<::std::uint16_t> pOutChannel, ::nn::sf::Out<::std::int16_t> pOutRssi, ::nn::sf::Out<::std::int64_t> pOutTick) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetActionFrame, (pOutMacAddr, pOutRxData, pOutSize, rxId, pOutChannel, pOutRssi, pOutTick));
        }

        ::nn::Result CancelGetActionFrame(::std::uint32_t rxId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CancelGetActionFrame, (rxId));
        }

        ::nn::Result CreateRxEntryForActionFrame(::nn::sf::Out<::std::uint32_t> pOutRxId, const ::nn::sf::InArray<::std::uint16_t>& pSubtypeArray, ::std::uint32_t capacity) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateRxEntryForActionFrame, (pOutRxId, pSubtypeArray, capacity));
        }

        ::nn::Result DeleteRxEntryForActionFrame(::std::uint32_t rxId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteRxEntryForActionFrame, (rxId));
        }

        ::nn::Result AddSubtypeToRxEntryForActionFrame(::std::uint32_t rxId, ::std::uint32_t type) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AddSubtypeToRxEntryForActionFrame, (rxId, type));
        }

        ::nn::Result DeleteSubtypeFromRxEntryForActionFrame(::nn::sf::Out<::std::uint32_t> pOutRxId, ::std::uint32_t type) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteSubtypeFromRxEntryForActionFrame, (pOutRxId, type));
        }

        ::nn::Result ReserveDetectSleep() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ReserveDetectSleep);
        }

        ::nn::Result CancelDetectSleep() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CancelDetectSleep);
        }

        ::nn::Result SetActionFrameForSleep(::std::uint8_t subtype, ::nn::wlan::DetectHash hash, const ::nn::sf::InBuffer& pTxData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetActionFrameForSleep, (subtype, hash, pTxData));
        }

        ::nn::Result SetHashList(const ::nn::sf::InBuffer& pHashList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetHashList, (pHashList));
        }

        ::nn::Result SetPeriodicActionFrameCycle(const ::nn::wlan::DetectPeriodicAfCycle& pattern, ::std::uint8_t target) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetPeriodicActionFrameCycle, (pattern, target));
        }

        ::nn::Result RequestSleep() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(RequestSleep);
        }

        ::nn::Result RequestWakeUp() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(RequestWakeUp);
        }

        ::nn::Result PutActionFrameOneShotEx(::nn::wlan::detail::SfdlMacAddress macAddr, ::nn::wlan::detail::SfdlMacAddress bssid, ::std::uint8_t subtype, const ::nn::wlan::DetectHeader& dhp, const ::nn::sf::InBuffer& pTxData, ::std::uint32_t dwellTime) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PutActionFrameOneShotEx, (macAddr, bssid, subtype, dhp, pTxData, dwellTime));
        }

        ::nn::Result StartCommunication() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(StartCommunication);
        }

        ::nn::Result StopCommunication() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(StopCommunication);
        }

        ::nn::Result SetMacAddress(::nn::wlan::detail::SfdlMacAddress macAddr) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetMacAddress, (macAddr));
        }

        ::nn::Result GetAllowedChannels(const ::nn::sf::OutArray<::std::int16_t>& outArray, ::nn::sf::Out<::std::uint32_t> pOutCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAllowedChannels, (outArray, pOutCount));
        }

        ::nn::Result GetTotalRecvCountInSleep(::nn::sf::Out<::std::uint64_t> pOutCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetTotalRecvCountInSleep, (pOutCount));
        }

        ::nn::Result ClearTotalRecvCountInSleep() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(ClearTotalRecvCountInSleep);
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IDetectManager
    {
    public:
        nn::Result OpenMode() NN_NOEXCEPT;
        nn::Result OpenModeWithChannel(std::uint16_t channel) NN_NOEXCEPT;
        nn::Result CloseMode() NN_NOEXCEPT;
        nn::Result GetMacAddress(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr) NN_NOEXCEPT;
        nn::Result GetState(nn::sf::Out<std::uint32_t> pOutState) NN_NOEXCEPT;
        nn::Result PutActionFrameOneShot(nn::wlan::detail::SfdlMacAddress macAddr, std::uint8_t subtype, nn::wlan::DetectHash hash, const nn::sf::InBuffer& pTxData, std::uint32_t dwellTime) NN_NOEXCEPT;
        nn::Result StartPeriodicActionFrame(std::uint8_t subtype, nn::wlan::DetectHash hash, const nn::sf::InBuffer& pTxData, std::uint32_t interval) NN_NOEXCEPT;
        nn::Result CancelPeriodicActionFrame() NN_NOEXCEPT;
        nn::Result GetActionFrame(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr, const nn::sf::OutBuffer& pOutRxData, nn::sf::Out<std::uint32_t> pOutSize, std::uint32_t rxId, nn::sf::Out<std::uint16_t> pOutChannel, nn::sf::Out<std::int16_t> pOutRssi, nn::sf::Out<std::int64_t> pOutTick) NN_NOEXCEPT;
        nn::Result CancelGetActionFrame(std::uint32_t rxId) NN_NOEXCEPT;
        nn::Result CreateRxEntryForActionFrame(nn::sf::Out<std::uint32_t> pOutRxId, const nn::sf::InArray<std::uint16_t>& pSubtypeArray, std::uint32_t capacity) NN_NOEXCEPT;
        nn::Result DeleteRxEntryForActionFrame(std::uint32_t rxId) NN_NOEXCEPT;
        nn::Result AddSubtypeToRxEntryForActionFrame(std::uint32_t rxId, std::uint32_t type) NN_NOEXCEPT;
        nn::Result DeleteSubtypeFromRxEntryForActionFrame(nn::sf::Out<std::uint32_t> pOutRxId, std::uint32_t type) NN_NOEXCEPT;
        nn::Result ReserveDetectSleep() NN_NOEXCEPT;
        nn::Result CancelDetectSleep() NN_NOEXCEPT;
        nn::Result SetActionFrameForSleep(std::uint8_t subtype, nn::wlan::DetectHash hash, const nn::sf::InBuffer& pTxData) NN_NOEXCEPT;
        nn::Result SetHashList(const nn::sf::InBuffer& pHashList) NN_NOEXCEPT;
        nn::Result SetPeriodicActionFrameCycle(const nn::wlan::DetectPeriodicAfCycle& pattern, std::uint8_t target) NN_NOEXCEPT;
        nn::Result RequestSleep() NN_NOEXCEPT;
        nn::Result RequestWakeUp() NN_NOEXCEPT;
        nn::Result PutActionFrameOneShotEx(nn::wlan::detail::SfdlMacAddress macAddr, nn::wlan::detail::SfdlMacAddress bssid, std::uint8_t subtype, const nn::wlan::DetectHeader& dhp, const nn::sf::InBuffer& pTxData, std::uint32_t dwellTime) NN_NOEXCEPT;
        nn::Result StartCommunication() NN_NOEXCEPT;
        nn::Result StopCommunication() NN_NOEXCEPT;
        nn::Result SetMacAddress(nn::wlan::detail::SfdlMacAddress macAddr) NN_NOEXCEPT;
        nn::Result GetAllowedChannels(const nn::sf::OutArray<std::int16_t>& outArray, nn::sf::Out<std::uint32_t> pOutCount) NN_NOEXCEPT;
        nn::Result GetTotalRecvCountInSleep(nn::sf::Out<std::uint64_t> pOutCount) NN_NOEXCEPT;
        nn::Result ClearTotalRecvCountInSleep() NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result OpenMode() NN_NOEXCEPT;
    nn::Result OpenModeWithChannel(std::uint16_t channel) NN_NOEXCEPT;
    nn::Result CloseMode() NN_NOEXCEPT;
    nn::Result GetMacAddress(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr) NN_NOEXCEPT;
    nn::Result GetState(nn::sf::Out<std::uint32_t> pOutState) NN_NOEXCEPT;
    nn::Result PutActionFrameOneShot(nn::wlan::detail::SfdlMacAddress macAddr, std::uint8_t subtype, nn::wlan::DetectHash hash, const nn::sf::InBuffer& pTxData, std::uint32_t dwellTime) NN_NOEXCEPT;
    nn::Result StartPeriodicActionFrame(std::uint8_t subtype, nn::wlan::DetectHash hash, const nn::sf::InBuffer& pTxData, std::uint32_t interval) NN_NOEXCEPT;
    nn::Result CancelPeriodicActionFrame() NN_NOEXCEPT;
    nn::Result GetActionFrame(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr, const nn::sf::OutBuffer& pOutRxData, nn::sf::Out<std::uint32_t> pOutSize, std::uint32_t rxId, nn::sf::Out<std::uint16_t> pOutChannel, nn::sf::Out<std::int16_t> pOutRssi, nn::sf::Out<std::int64_t> pOutTick) NN_NOEXCEPT;
    nn::Result CancelGetActionFrame(std::uint32_t rxId) NN_NOEXCEPT;
    nn::Result CreateRxEntryForActionFrame(nn::sf::Out<std::uint32_t> pOutRxId, const nn::sf::InArray<std::uint16_t>& pSubtypeArray, std::uint32_t capacity) NN_NOEXCEPT;
    nn::Result DeleteRxEntryForActionFrame(std::uint32_t rxId) NN_NOEXCEPT;
    nn::Result AddSubtypeToRxEntryForActionFrame(std::uint32_t rxId, std::uint32_t type) NN_NOEXCEPT;
    nn::Result DeleteSubtypeFromRxEntryForActionFrame(nn::sf::Out<std::uint32_t> pOutRxId, std::uint32_t type) NN_NOEXCEPT;
    nn::Result ReserveDetectSleep() NN_NOEXCEPT;
    nn::Result CancelDetectSleep() NN_NOEXCEPT;
    nn::Result SetActionFrameForSleep(std::uint8_t subtype, nn::wlan::DetectHash hash, const nn::sf::InBuffer& pTxData) NN_NOEXCEPT;
    nn::Result SetHashList(const nn::sf::InBuffer& pHashList) NN_NOEXCEPT;
    nn::Result SetPeriodicActionFrameCycle(const nn::wlan::DetectPeriodicAfCycle& pattern, std::uint8_t target) NN_NOEXCEPT;
    nn::Result RequestSleep() NN_NOEXCEPT;
    nn::Result RequestWakeUp() NN_NOEXCEPT;
    nn::Result PutActionFrameOneShotEx(nn::wlan::detail::SfdlMacAddress macAddr, nn::wlan::detail::SfdlMacAddress bssid, std::uint8_t subtype, const nn::wlan::DetectHeader& dhp, const nn::sf::InBuffer& pTxData, std::uint32_t dwellTime) NN_NOEXCEPT;
    nn::Result StartCommunication() NN_NOEXCEPT;
    nn::Result StopCommunication() NN_NOEXCEPT;
    nn::Result SetMacAddress(nn::wlan::detail::SfdlMacAddress macAddr) NN_NOEXCEPT;
    nn::Result GetAllowedChannels(const nn::sf::OutArray<std::int16_t>& outArray, nn::sf::Out<std::uint32_t> pOutCount) NN_NOEXCEPT;
    nn::Result GetTotalRecvCountInSleep(nn::sf::Out<std::uint64_t> pOutCount) NN_NOEXCEPT;
    nn::Result ClearTotalRecvCountInSleep() NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::wlan::detail::IDetectManager))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(OpenMode)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(OpenMode);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenModeWithChannel, (::std::uint16_t channel))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(OpenModeWithChannel, (channel));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CloseMode)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CloseMode);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMacAddress, (::nn::sf::Out<::nn::wlan::detail::SfdlMacAddress> pOutMacAddr))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetMacAddress, (pOutMacAddr));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::std::uint32_t> pOutState))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetState, (pOutState));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PutActionFrameOneShot, (::nn::wlan::detail::SfdlMacAddress macAddr, ::std::uint8_t subtype, ::nn::wlan::DetectHash hash, const ::nn::sf::InBuffer& pTxData, ::std::uint32_t dwellTime))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PutActionFrameOneShot, (macAddr, subtype, hash, pTxData, dwellTime));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartPeriodicActionFrame, (::std::uint8_t subtype, ::nn::wlan::DetectHash hash, const ::nn::sf::InBuffer& pTxData, ::std::uint32_t interval))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartPeriodicActionFrame, (subtype, hash, pTxData, interval));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CancelPeriodicActionFrame)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CancelPeriodicActionFrame);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActionFrame, (::nn::sf::Out<::nn::wlan::detail::SfdlMacAddress> pOutMacAddr, const ::nn::sf::OutBuffer& pOutRxData, ::nn::sf::Out<::std::uint32_t> pOutSize, ::std::uint32_t rxId, ::nn::sf::Out<::std::uint16_t> pOutChannel, ::nn::sf::Out<::std::int16_t> pOutRssi, ::nn::sf::Out<::std::int64_t> pOutTick))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetActionFrame, (pOutMacAddr, pOutRxData, pOutSize, rxId, pOutChannel, pOutRssi, pOutTick));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelGetActionFrame, (::std::uint32_t rxId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CancelGetActionFrame, (rxId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateRxEntryForActionFrame, (::nn::sf::Out<::std::uint32_t> pOutRxId, const ::nn::sf::InArray<::std::uint16_t>& pSubtypeArray, ::std::uint32_t capacity))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateRxEntryForActionFrame, (pOutRxId, pSubtypeArray, capacity));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteRxEntryForActionFrame, (::std::uint32_t rxId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteRxEntryForActionFrame, (rxId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddSubtypeToRxEntryForActionFrame, (::std::uint32_t rxId, ::std::uint32_t type))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AddSubtypeToRxEntryForActionFrame, (rxId, type));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteSubtypeFromRxEntryForActionFrame, (::nn::sf::Out<::std::uint32_t> pOutRxId, ::std::uint32_t type))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteSubtypeFromRxEntryForActionFrame, (pOutRxId, type));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ReserveDetectSleep)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ReserveDetectSleep);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CancelDetectSleep)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CancelDetectSleep);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetActionFrameForSleep, (::std::uint8_t subtype, ::nn::wlan::DetectHash hash, const ::nn::sf::InBuffer& pTxData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetActionFrameForSleep, (subtype, hash, pTxData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetHashList, (const ::nn::sf::InBuffer& pHashList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetHashList, (pHashList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPeriodicActionFrameCycle, (const ::nn::wlan::DetectPeriodicAfCycle& pattern, ::std::uint8_t target))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetPeriodicActionFrameCycle, (pattern, target));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RequestSleep)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(RequestSleep);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RequestWakeUp)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(RequestWakeUp);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PutActionFrameOneShotEx, (::nn::wlan::detail::SfdlMacAddress macAddr, ::nn::wlan::detail::SfdlMacAddress bssid, ::std::uint8_t subtype, const ::nn::wlan::DetectHeader& dhp, const ::nn::sf::InBuffer& pTxData, ::std::uint32_t dwellTime))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PutActionFrameOneShotEx, (macAddr, bssid, subtype, dhp, pTxData, dwellTime));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StartCommunication)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(StartCommunication);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StopCommunication)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(StopCommunication);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetMacAddress, (::nn::wlan::detail::SfdlMacAddress macAddr))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetMacAddress, (macAddr));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAllowedChannels, (const ::nn::sf::OutArray<::std::int16_t>& outArray, ::nn::sf::Out<::std::uint32_t> pOutCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAllowedChannels, (outArray, pOutCount));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTotalRecvCountInSleep, (::nn::sf::Out<::std::uint64_t> pOutCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetTotalRecvCountInSleep, (pOutCount));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ClearTotalRecvCountInSleep)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(ClearTotalRecvCountInSleep);
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::wlan::detail::IDetectManager>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::wlan::detail::IDetectManager))

    // nn::Result OpenMode() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenMode)

    // nn::Result OpenModeWithChannel(std::uint16_t channel) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenModeWithChannel)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(channel, (::std::uint16_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (channel))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(channel)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenModeWithChannel)

    // nn::Result CloseMode() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CloseMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CloseMode)

    // nn::Result GetMacAddress(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetMacAddress)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutMacAddr, (::nn::wlan::detail::SfdlMacAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutMacAddr))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutMacAddr)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetMacAddress)

    // nn::Result GetState(nn::sf::Out<std::uint32_t> pOutState) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutState, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutState))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutState)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetState)

    // nn::Result PutActionFrameOneShot(nn::wlan::detail::SfdlMacAddress macAddr, std::uint8_t subtype, nn::wlan::DetectHash hash, const nn::sf::InBuffer& pTxData, std::uint32_t dwellTime) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PutActionFrameOneShot)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(hash, 0, (::nn::wlan::DetectHash), 8, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pTxData, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (hash, pTxData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(macAddr, (::nn::wlan::detail::SfdlMacAddress), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(subtype, (::std::uint8_t), 6)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(dwellTime, (::std::uint32_t), 8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (macAddr, subtype, dwellTime))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(12)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(macAddr), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(subtype), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hash), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pTxData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dwellTime)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PutActionFrameOneShot)

    // nn::Result StartPeriodicActionFrame(std::uint8_t subtype, nn::wlan::DetectHash hash, const nn::sf::InBuffer& pTxData, std::uint32_t interval) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartPeriodicActionFrame)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(hash, 0, (::nn::wlan::DetectHash), 8, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pTxData, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (hash, pTxData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(subtype, (::std::uint8_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(interval, (::std::uint32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (subtype, interval))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(subtype), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hash), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pTxData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(interval)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartPeriodicActionFrame)

    // nn::Result CancelPeriodicActionFrame() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelPeriodicActionFrame)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelPeriodicActionFrame)

    // nn::Result GetActionFrame(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr, const nn::sf::OutBuffer& pOutRxData, nn::sf::Out<std::uint32_t> pOutSize, std::uint32_t rxId, nn::sf::Out<std::uint16_t> pOutChannel, nn::sf::Out<std::int16_t> pOutRssi, nn::sf::Out<std::int64_t> pOutTick) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetActionFrame)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutRxData, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutRxData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rxId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rxId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutMacAddr, (::nn::wlan::detail::SfdlMacAddress), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutChannel, (::std::uint16_t), 6)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRssi, (::std::int16_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSize, (::std::uint32_t), 12)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutTick, (::std::int64_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(5, (pOutMacAddr, pOutChannel, pOutRssi, pOutSize, pOutTick))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutMacAddr), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRxData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rxId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutChannel), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRssi), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutTick)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetActionFrame)

    // nn::Result CancelGetActionFrame(std::uint32_t rxId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelGetActionFrame)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rxId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rxId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rxId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelGetActionFrame)

    // nn::Result CreateRxEntryForActionFrame(nn::sf::Out<std::uint32_t> pOutRxId, const nn::sf::InArray<std::uint16_t>& pSubtypeArray, std::uint32_t capacity) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateRxEntryForActionFrame)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pSubtypeArray, 0, (const ::nn::sf::InArray<::std::uint16_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pSubtypeArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(capacity, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (capacity))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRxId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutRxId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRxId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pSubtypeArray), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(capacity)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateRxEntryForActionFrame)

    // nn::Result DeleteRxEntryForActionFrame(std::uint32_t rxId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteRxEntryForActionFrame)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rxId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rxId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rxId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteRxEntryForActionFrame)

    // nn::Result AddSubtypeToRxEntryForActionFrame(std::uint32_t rxId, std::uint32_t type) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AddSubtypeToRxEntryForActionFrame)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rxId, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::std::uint32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (rxId, type))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rxId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AddSubtypeToRxEntryForActionFrame)

    // nn::Result DeleteSubtypeFromRxEntryForActionFrame(nn::sf::Out<std::uint32_t> pOutRxId, std::uint32_t type) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteSubtypeFromRxEntryForActionFrame)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (type))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRxId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutRxId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRxId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteSubtypeFromRxEntryForActionFrame)

    // nn::Result ReserveDetectSleep() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ReserveDetectSleep)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ReserveDetectSleep)

    // nn::Result CancelDetectSleep() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelDetectSleep)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelDetectSleep)

    // nn::Result SetActionFrameForSleep(std::uint8_t subtype, nn::wlan::DetectHash hash, const nn::sf::InBuffer& pTxData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetActionFrameForSleep)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(hash, 0, (::nn::wlan::DetectHash), 8, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pTxData, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (hash, pTxData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(subtype, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (subtype))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(subtype), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(hash), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pTxData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetActionFrameForSleep)

    // nn::Result SetHashList(const nn::sf::InBuffer& pHashList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetHashList)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pHashList, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pHashList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pHashList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetHashList)

    // nn::Result SetPeriodicActionFrameCycle(const nn::wlan::DetectPeriodicAfCycle& pattern, std::uint8_t target) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetPeriodicActionFrameCycle)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pattern, 0, (const ::nn::wlan::DetectPeriodicAfCycle&), 20, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pattern))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(target, (::std::uint8_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (target))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pattern), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(target)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetPeriodicActionFrameCycle)

    // nn::Result RequestSleep() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestSleep)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(19)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestSleep)

    // nn::Result RequestWakeUp() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestWakeUp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestWakeUp)

    // nn::Result PutActionFrameOneShotEx(nn::wlan::detail::SfdlMacAddress macAddr, nn::wlan::detail::SfdlMacAddress bssid, std::uint8_t subtype, const nn::wlan::DetectHeader& dhp, const nn::sf::InBuffer& pTxData, std::uint32_t dwellTime) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PutActionFrameOneShotEx)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(dhp, 0, (const ::nn::wlan::DetectHeader&), 12, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pTxData, 1, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (dhp, pTxData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(macAddr, (::nn::wlan::detail::SfdlMacAddress), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bssid, (::nn::wlan::detail::SfdlMacAddress), 6)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(subtype, (::std::uint8_t), 12)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(dwellTime, (::std::uint32_t), 16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(4, (macAddr, bssid, subtype, dwellTime))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(20)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(macAddr), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bssid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(subtype), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dhp), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pTxData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dwellTime)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PutActionFrameOneShotEx)

    // nn::Result StartCommunication() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartCommunication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartCommunication)

    // nn::Result StopCommunication() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StopCommunication)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(23)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StopCommunication)

    // nn::Result SetMacAddress(nn::wlan::detail::SfdlMacAddress macAddr) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetMacAddress)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(macAddr, (::nn::wlan::detail::SfdlMacAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (macAddr))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(macAddr)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetMacAddress)

    // nn::Result GetAllowedChannels(const nn::sf::OutArray<std::int16_t>& outArray, nn::sf::Out<std::uint32_t> pOutCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAllowedChannels)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(25)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outArray, 0, (const ::nn::sf::OutArray<::std::int16_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outArray), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAllowedChannels)

    // nn::Result GetTotalRecvCountInSleep(nn::sf::Out<std::uint64_t> pOutCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetTotalRecvCountInSleep)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(26)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::uint64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetTotalRecvCountInSleep)

    // nn::Result ClearTotalRecvCountInSleep() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearTotalRecvCountInSleep)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(27)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearTotalRecvCountInSleep)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::wlan::DetectHash), 8, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::wlan::DetectPeriodicAfCycle), 20, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::wlan::DetectHeader), 12, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::wlan::detail::IDetectManager, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::wlan::detail::IDetectManager))

    // nn::Result OpenMode() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(OpenMode)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenMode)
    }

    // nn::Result OpenModeWithChannel(std::uint16_t channel) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(OpenModeWithChannel, (::std::uint16_t channel))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenModeWithChannel)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(channel)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenModeWithChannel)
    }

    // nn::Result CloseMode() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CloseMode)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CloseMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CloseMode)
    }

    // nn::Result GetMacAddress(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMacAddress, (::nn::sf::Out<::nn::wlan::detail::SfdlMacAddress> pOutMacAddr))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetMacAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutMacAddr)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetMacAddress)
    }

    // nn::Result GetState(nn::sf::Out<std::uint32_t> pOutState) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::std::uint32_t> pOutState))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutState)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetState)
    }

    // nn::Result PutActionFrameOneShot(nn::wlan::detail::SfdlMacAddress macAddr, std::uint8_t subtype, nn::wlan::DetectHash hash, const nn::sf::InBuffer& pTxData, std::uint32_t dwellTime) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PutActionFrameOneShot, (::nn::wlan::detail::SfdlMacAddress macAddr, ::std::uint8_t subtype, ::nn::wlan::DetectHash hash, const ::nn::sf::InBuffer& pTxData, ::std::uint32_t dwellTime))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PutActionFrameOneShot)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(macAddr)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(subtype)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hash)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pTxData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dwellTime)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PutActionFrameOneShot)
    }

    // nn::Result StartPeriodicActionFrame(std::uint8_t subtype, nn::wlan::DetectHash hash, const nn::sf::InBuffer& pTxData, std::uint32_t interval) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartPeriodicActionFrame, (::std::uint8_t subtype, ::nn::wlan::DetectHash hash, const ::nn::sf::InBuffer& pTxData, ::std::uint32_t interval))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartPeriodicActionFrame)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(subtype)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hash)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pTxData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(interval)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartPeriodicActionFrame)
    }

    // nn::Result CancelPeriodicActionFrame() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CancelPeriodicActionFrame)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelPeriodicActionFrame)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelPeriodicActionFrame)
    }

    // nn::Result GetActionFrame(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr, const nn::sf::OutBuffer& pOutRxData, nn::sf::Out<std::uint32_t> pOutSize, std::uint32_t rxId, nn::sf::Out<std::uint16_t> pOutChannel, nn::sf::Out<std::int16_t> pOutRssi, nn::sf::Out<std::int64_t> pOutTick) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActionFrame, (::nn::sf::Out<::nn::wlan::detail::SfdlMacAddress> pOutMacAddr, const ::nn::sf::OutBuffer& pOutRxData, ::nn::sf::Out<::std::uint32_t> pOutSize, ::std::uint32_t rxId, ::nn::sf::Out<::std::uint16_t> pOutChannel, ::nn::sf::Out<::std::int16_t> pOutRssi, ::nn::sf::Out<::std::int64_t> pOutTick))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetActionFrame)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutMacAddr)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRxData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rxId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutChannel)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRssi)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutTick)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetActionFrame)
    }

    // nn::Result CancelGetActionFrame(std::uint32_t rxId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelGetActionFrame, (::std::uint32_t rxId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelGetActionFrame)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rxId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelGetActionFrame)
    }

    // nn::Result CreateRxEntryForActionFrame(nn::sf::Out<std::uint32_t> pOutRxId, const nn::sf::InArray<std::uint16_t>& pSubtypeArray, std::uint32_t capacity) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateRxEntryForActionFrame, (::nn::sf::Out<::std::uint32_t> pOutRxId, const ::nn::sf::InArray<::std::uint16_t>& pSubtypeArray, ::std::uint32_t capacity))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateRxEntryForActionFrame)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRxId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pSubtypeArray)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(capacity)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateRxEntryForActionFrame)
    }

    // nn::Result DeleteRxEntryForActionFrame(std::uint32_t rxId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteRxEntryForActionFrame, (::std::uint32_t rxId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteRxEntryForActionFrame)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rxId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteRxEntryForActionFrame)
    }

    // nn::Result AddSubtypeToRxEntryForActionFrame(std::uint32_t rxId, std::uint32_t type) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddSubtypeToRxEntryForActionFrame, (::std::uint32_t rxId, ::std::uint32_t type))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AddSubtypeToRxEntryForActionFrame)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rxId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AddSubtypeToRxEntryForActionFrame)
    }

    // nn::Result DeleteSubtypeFromRxEntryForActionFrame(nn::sf::Out<std::uint32_t> pOutRxId, std::uint32_t type) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteSubtypeFromRxEntryForActionFrame, (::nn::sf::Out<::std::uint32_t> pOutRxId, ::std::uint32_t type))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteSubtypeFromRxEntryForActionFrame)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRxId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteSubtypeFromRxEntryForActionFrame)
    }

    // nn::Result ReserveDetectSleep() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ReserveDetectSleep)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ReserveDetectSleep)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ReserveDetectSleep)
    }

    // nn::Result CancelDetectSleep() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CancelDetectSleep)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelDetectSleep)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelDetectSleep)
    }

    // nn::Result SetActionFrameForSleep(std::uint8_t subtype, nn::wlan::DetectHash hash, const nn::sf::InBuffer& pTxData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetActionFrameForSleep, (::std::uint8_t subtype, ::nn::wlan::DetectHash hash, const ::nn::sf::InBuffer& pTxData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetActionFrameForSleep)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(subtype)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(hash)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pTxData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetActionFrameForSleep)
    }

    // nn::Result SetHashList(const nn::sf::InBuffer& pHashList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetHashList, (const ::nn::sf::InBuffer& pHashList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetHashList)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pHashList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetHashList)
    }

    // nn::Result SetPeriodicActionFrameCycle(const nn::wlan::DetectPeriodicAfCycle& pattern, std::uint8_t target) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetPeriodicActionFrameCycle, (const ::nn::wlan::DetectPeriodicAfCycle& pattern, ::std::uint8_t target))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetPeriodicActionFrameCycle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pattern)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(target)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetPeriodicActionFrameCycle)
    }

    // nn::Result RequestSleep() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RequestSleep)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestSleep)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestSleep)
    }

    // nn::Result RequestWakeUp() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RequestWakeUp)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestWakeUp)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestWakeUp)
    }

    // nn::Result PutActionFrameOneShotEx(nn::wlan::detail::SfdlMacAddress macAddr, nn::wlan::detail::SfdlMacAddress bssid, std::uint8_t subtype, const nn::wlan::DetectHeader& dhp, const nn::sf::InBuffer& pTxData, std::uint32_t dwellTime) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PutActionFrameOneShotEx, (::nn::wlan::detail::SfdlMacAddress macAddr, ::nn::wlan::detail::SfdlMacAddress bssid, ::std::uint8_t subtype, const ::nn::wlan::DetectHeader& dhp, const ::nn::sf::InBuffer& pTxData, ::std::uint32_t dwellTime))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PutActionFrameOneShotEx)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(macAddr)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bssid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(subtype)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dhp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pTxData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dwellTime)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PutActionFrameOneShotEx)
    }

    // nn::Result StartCommunication() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StartCommunication)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartCommunication)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartCommunication)
    }

    // nn::Result StopCommunication() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StopCommunication)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StopCommunication)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StopCommunication)
    }

    // nn::Result SetMacAddress(nn::wlan::detail::SfdlMacAddress macAddr) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetMacAddress, (::nn::wlan::detail::SfdlMacAddress macAddr))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetMacAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(macAddr)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetMacAddress)
    }

    // nn::Result GetAllowedChannels(const nn::sf::OutArray<std::int16_t>& outArray, nn::sf::Out<std::uint32_t> pOutCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAllowedChannels, (const ::nn::sf::OutArray<::std::int16_t>& outArray, ::nn::sf::Out<::std::uint32_t> pOutCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAllowedChannels)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outArray)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAllowedChannels)
    }

    // nn::Result GetTotalRecvCountInSleep(nn::sf::Out<std::uint64_t> pOutCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetTotalRecvCountInSleep, (::nn::sf::Out<::std::uint64_t> pOutCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetTotalRecvCountInSleep)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetTotalRecvCountInSleep)
    }

    // nn::Result ClearTotalRecvCountInSleep() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(ClearTotalRecvCountInSleep)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearTotalRecvCountInSleep)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearTotalRecvCountInSleep)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::wlan::detail::IDetectManager>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::wlan::detail::IDetectManager))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenModeWithChannel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenModeWithChannel)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(channel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CloseMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CloseMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetMacAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetMacAddress)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutMacAddr)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PutActionFrameOneShot)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(hash)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pTxData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PutActionFrameOneShot)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(macAddr),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(subtype),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(hash),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pTxData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(dwellTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartPeriodicActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(hash)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pTxData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartPeriodicActionFrame)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(subtype),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(hash),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pTxData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(interval)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelPeriodicActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelPeriodicActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutRxData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetActionFrame)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutMacAddr),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutRxData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rxId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutChannel),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRssi),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutTick)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelGetActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelGetActionFrame)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rxId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateRxEntryForActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pSubtypeArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateRxEntryForActionFrame)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRxId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pSubtypeArray),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(capacity)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteRxEntryForActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteRxEntryForActionFrame)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rxId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AddSubtypeToRxEntryForActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AddSubtypeToRxEntryForActionFrame)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rxId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteSubtypeFromRxEntryForActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteSubtypeFromRxEntryForActionFrame)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRxId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ReserveDetectSleep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ReserveDetectSleep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelDetectSleep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelDetectSleep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetActionFrameForSleep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(hash)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pTxData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetActionFrameForSleep)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(subtype),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(hash),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pTxData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetHashList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pHashList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetHashList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pHashList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetPeriodicActionFrameCycle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pattern)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetPeriodicActionFrameCycle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pattern),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(target)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestSleep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestSleep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestWakeUp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestWakeUp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PutActionFrameOneShotEx)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(dhp)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pTxData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PutActionFrameOneShotEx)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(macAddr),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bssid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(subtype),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(dhp),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pTxData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(dwellTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartCommunication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartCommunication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StopCommunication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StopCommunication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetMacAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetMacAddress)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(macAddr)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAllowedChannels)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAllowedChannels)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outArray),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetTotalRecvCountInSleep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetTotalRecvCountInSleep)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearTotalRecvCountInSleep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearTotalRecvCountInSleep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenModeWithChannel)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CloseMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetMacAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PutActionFrameOneShot)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartPeriodicActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelPeriodicActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelGetActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateRxEntryForActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteRxEntryForActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AddSubtypeToRxEntryForActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteSubtypeFromRxEntryForActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ReserveDetectSleep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelDetectSleep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetActionFrameForSleep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetHashList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetPeriodicActionFrameCycle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestSleep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestWakeUp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PutActionFrameOneShotEx)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartCommunication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StopCommunication)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetMacAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAllowedChannels)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetTotalRecvCountInSleep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearTotalRecvCountInSleep)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::wlan::detail::IDetectManager))

namespace nn { namespace wlan { namespace detail { // NOLINT(whitespace/braces)

struct SfdlSsid
{
    nn::Bit8 data[32];
    std::uint8_t length;
};

struct SfdlConnectionStatus
{
    std::uint32_t state;
    std::uint32_t cause;
    std::int16_t channel;
    nn::wlan::detail::SfdlMacAddress bssid;
    nn::wlan::detail::SfdlSsid ssid;
    std::uint16_t aid;
    std::uint16_t statusReasonCode;
    std::uint16_t capabilityInfo;
    std::uint16_t beaconInterval;
};

struct SfdlChannelList
{
    std::int16_t channel[38];
};

struct SfdlScanParameters
{
    std::uint32_t scanType;
    nn::wlan::detail::SfdlChannelList channelList;
    std::uint8_t channelCount;
    std::int32_t channelScanTime;
    std::int32_t homeChannelTime;
    nn::wlan::detail::SfdlSsid ssidList[10];
    std::uint8_t ssidCount;
    nn::wlan::detail::SfdlMacAddress bssid;
};

struct SfdlSecurity
{
    std::uint32_t privacyMode;
    std::uint32_t groupPrivacyMode;
    std::uint32_t keyIdx;
    nn::Bit8 key[65];
};

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(IInfraManager, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(IInfraManager)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(OpenMode)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CloseMode)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetMacAddress, (::nn::sf::Out<::nn::wlan::detail::SfdlMacAddress> pOutMacAddr))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartScan, (const ::nn::wlan::detail::SfdlScanParameters& scanParam))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(StopScan)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Connect, (const ::nn::wlan::detail::SfdlSsid& ssid, ::nn::wlan::detail::SfdlMacAddress bssid, ::std::int16_t channel, const ::nn::wlan::detail::SfdlSecurity& security, bool autoKeepAlive, ::std::int32_t beaconLostTimeout))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CancelConnect)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(Disconnect)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutSystemEventReadableHandle, ::std::uint32_t type))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetConnectionStatus, (::nn::sf::Out<::nn::wlan::detail::SfdlConnectionStatus> pOutStatus))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::std::uint32_t> pOutState))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetScanResult, (const ::nn::sf::OutBuffer& pOutScanBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRssi, (::nn::sf::Out<::std::int32_t> pOutRssi))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ChangeRxAntenna, (::std::int32_t rxAntenna))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFwVersion, (const ::nn::sf::OutBuffer& pOutBuffer))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(RequestSleep)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(RequestWakeUp)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ConnectWithWps, (::std::uint32_t method, const ::nn::sf::InArray<char>& wpsPinArray, ::std::int32_t beaconLostTimeout))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetWakeupReason, (::nn::sf::Out<::std::uint32_t> pOutReason))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetTcpSessionInformation, (::nn::wlan::detail::SfdlMacAddress dstMac, ::nn::wlan::WlanIpv4Address srcIp, ::nn::wlan::WlanIpv4Address dstIp, ::std::uint16_t srcPort, ::std::uint16_t dstPort, ::std::uint32_t ackNum, ::std::uint16_t windowSize))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(RemoveTcpSessionInformation)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetWakeupReasonRaw, (::nn::sf::Out<::std::uint32_t> pOutReason))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetWakeupReasonRaw, (::std::uint32_t reason))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(EnableWowlFeatures, (::std::uint32_t features))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetWowlStats, (::nn::sf::Out<::nn::wlan::WowlWakeCount> pOutCounts, ::nn::sf::Out<::nn::wlan::WowlSleepStats> pOutStats))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(ClearWowlStats, (bool counts, bool stats))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(InitializeWlanOnSkipBoot)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(EmulateDriverInitFail)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAllowedChannels, (const ::nn::sf::OutArray<::std::int16_t>& outArray, ::nn::sf::Out<::std::uint32_t> pOutCount))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(IInfraManager)

        ::nn::Result OpenMode() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(OpenMode);
        }

        ::nn::Result CloseMode() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CloseMode);
        }

        ::nn::Result GetMacAddress(::nn::sf::Out<::nn::wlan::detail::SfdlMacAddress> pOutMacAddr) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetMacAddress, (pOutMacAddr));
        }

        ::nn::Result StartScan(const ::nn::wlan::detail::SfdlScanParameters& scanParam) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartScan, (scanParam));
        }

        ::nn::Result StopScan() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(StopScan);
        }

        ::nn::Result Connect(const ::nn::wlan::detail::SfdlSsid& ssid, ::nn::wlan::detail::SfdlMacAddress bssid, ::std::int16_t channel, const ::nn::wlan::detail::SfdlSecurity& security, bool autoKeepAlive, ::std::int32_t beaconLostTimeout) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Connect, (ssid, bssid, channel, security, autoKeepAlive, beaconLostTimeout));
        }

        ::nn::Result CancelConnect() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CancelConnect);
        }

        ::nn::Result Disconnect() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(Disconnect);
        }

        ::nn::Result GetSystemEvent(::nn::sf::Out<::nn::sf::NativeHandle> pOutSystemEventReadableHandle, ::std::uint32_t type) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSystemEvent, (pOutSystemEventReadableHandle, type));
        }

        ::nn::Result GetConnectionStatus(::nn::sf::Out<::nn::wlan::detail::SfdlConnectionStatus> pOutStatus) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetConnectionStatus, (pOutStatus));
        }

        ::nn::Result GetState(::nn::sf::Out<::std::uint32_t> pOutState) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetState, (pOutState));
        }

        ::nn::Result GetScanResult(const ::nn::sf::OutBuffer& pOutScanBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetScanResult, (pOutScanBuffer));
        }

        ::nn::Result GetRssi(::nn::sf::Out<::std::int32_t> pOutRssi) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRssi, (pOutRssi));
        }

        ::nn::Result ChangeRxAntenna(::std::int32_t rxAntenna) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ChangeRxAntenna, (rxAntenna));
        }

        ::nn::Result GetFwVersion(const ::nn::sf::OutBuffer& pOutBuffer) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFwVersion, (pOutBuffer));
        }

        ::nn::Result RequestSleep() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(RequestSleep);
        }

        ::nn::Result RequestWakeUp() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(RequestWakeUp);
        }

        ::nn::Result ConnectWithWps(::std::uint32_t method, const ::nn::sf::InArray<char>& wpsPinArray, ::std::int32_t beaconLostTimeout) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ConnectWithWps, (method, wpsPinArray, beaconLostTimeout));
        }

        ::nn::Result GetWakeupReason(::nn::sf::Out<::std::uint32_t> pOutReason) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetWakeupReason, (pOutReason));
        }

        ::nn::Result SetTcpSessionInformation(::nn::wlan::detail::SfdlMacAddress dstMac, ::nn::wlan::WlanIpv4Address srcIp, ::nn::wlan::WlanIpv4Address dstIp, ::std::uint16_t srcPort, ::std::uint16_t dstPort, ::std::uint32_t ackNum, ::std::uint16_t windowSize) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetTcpSessionInformation, (dstMac, srcIp, dstIp, srcPort, dstPort, ackNum, windowSize));
        }

        ::nn::Result RemoveTcpSessionInformation() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(RemoveTcpSessionInformation);
        }

        ::nn::Result GetWakeupReasonRaw(::nn::sf::Out<::std::uint32_t> pOutReason) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetWakeupReasonRaw, (pOutReason));
        }

        ::nn::Result SetWakeupReasonRaw(::std::uint32_t reason) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetWakeupReasonRaw, (reason));
        }

        ::nn::Result EnableWowlFeatures(::std::uint32_t features) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(EnableWowlFeatures, (features));
        }

        ::nn::Result GetWowlStats(::nn::sf::Out<::nn::wlan::WowlWakeCount> pOutCounts, ::nn::sf::Out<::nn::wlan::WowlSleepStats> pOutStats) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetWowlStats, (pOutCounts, pOutStats));
        }

        ::nn::Result ClearWowlStats(bool counts, bool stats) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(ClearWowlStats, (counts, stats));
        }

        ::nn::Result InitializeWlanOnSkipBoot() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(InitializeWlanOnSkipBoot);
        }

        ::nn::Result EmulateDriverInitFail() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(EmulateDriverInitFail);
        }

        ::nn::Result GetAllowedChannels(const ::nn::sf::OutArray<::std::int16_t>& outArray, ::nn::sf::Out<::std::uint32_t> pOutCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAllowedChannels, (outArray, pOutCount));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class IInfraManager
    {
    public:
        nn::Result OpenMode() NN_NOEXCEPT;
        nn::Result CloseMode() NN_NOEXCEPT;
        nn::Result GetMacAddress(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr) NN_NOEXCEPT;
        nn::Result StartScan(const nn::wlan::detail::SfdlScanParameters& scanParam) NN_NOEXCEPT;
        nn::Result StopScan() NN_NOEXCEPT;
        nn::Result Connect(const nn::wlan::detail::SfdlSsid& ssid, nn::wlan::detail::SfdlMacAddress bssid, std::int16_t channel, const nn::wlan::detail::SfdlSecurity& security, bool autoKeepAlive, std::int32_t beaconLostTimeout) NN_NOEXCEPT;
        nn::Result CancelConnect() NN_NOEXCEPT;
        nn::Result Disconnect() NN_NOEXCEPT;
        nn::Result GetSystemEvent(nn::sf::Out<nn::sf::NativeHandle> pOutSystemEventReadableHandle, std::uint32_t type) NN_NOEXCEPT;
        nn::Result GetConnectionStatus(nn::sf::Out<nn::wlan::detail::SfdlConnectionStatus> pOutStatus) NN_NOEXCEPT;
        nn::Result GetState(nn::sf::Out<std::uint32_t> pOutState) NN_NOEXCEPT;
        nn::Result GetScanResult(const nn::sf::OutBuffer& pOutScanBuffer) NN_NOEXCEPT;
        nn::Result GetRssi(nn::sf::Out<std::int32_t> pOutRssi) NN_NOEXCEPT;
        nn::Result ChangeRxAntenna(std::int32_t rxAntenna) NN_NOEXCEPT;
        nn::Result GetFwVersion(const nn::sf::OutBuffer& pOutBuffer) NN_NOEXCEPT;
        nn::Result RequestSleep() NN_NOEXCEPT;
        nn::Result RequestWakeUp() NN_NOEXCEPT;
        nn::Result ConnectWithWps(std::uint32_t method, const nn::sf::InArray<char>& wpsPinArray, std::int32_t beaconLostTimeout) NN_NOEXCEPT;
        nn::Result GetWakeupReason(nn::sf::Out<std::uint32_t> pOutReason) NN_NOEXCEPT;
        nn::Result SetTcpSessionInformation(nn::wlan::detail::SfdlMacAddress dstMac, nn::wlan::WlanIpv4Address srcIp, nn::wlan::WlanIpv4Address dstIp, std::uint16_t srcPort, std::uint16_t dstPort, std::uint32_t ackNum, std::uint16_t windowSize) NN_NOEXCEPT;
        nn::Result RemoveTcpSessionInformation() NN_NOEXCEPT;
        nn::Result GetWakeupReasonRaw(nn::sf::Out<std::uint32_t> pOutReason) NN_NOEXCEPT;
        nn::Result SetWakeupReasonRaw(std::uint32_t reason) NN_NOEXCEPT;
        nn::Result EnableWowlFeatures(std::uint32_t features) NN_NOEXCEPT;
        nn::Result GetWowlStats(nn::sf::Out<nn::wlan::WowlWakeCount> pOutCounts, nn::sf::Out<nn::wlan::WowlSleepStats> pOutStats) NN_NOEXCEPT;
        nn::Result ClearWowlStats(bool counts, bool stats) NN_NOEXCEPT;
        nn::Result InitializeWlanOnSkipBoot() NN_NOEXCEPT;
        nn::Result EmulateDriverInitFail() NN_NOEXCEPT;
        nn::Result GetAllowedChannels(const nn::sf::OutArray<std::int16_t>& outArray, nn::sf::Out<std::uint32_t> pOutCount) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result OpenMode() NN_NOEXCEPT;
    nn::Result CloseMode() NN_NOEXCEPT;
    nn::Result GetMacAddress(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr) NN_NOEXCEPT;
    nn::Result StartScan(const nn::wlan::detail::SfdlScanParameters& scanParam) NN_NOEXCEPT;
    nn::Result StopScan() NN_NOEXCEPT;
    nn::Result Connect(const nn::wlan::detail::SfdlSsid& ssid, nn::wlan::detail::SfdlMacAddress bssid, std::int16_t channel, const nn::wlan::detail::SfdlSecurity& security, bool autoKeepAlive, std::int32_t beaconLostTimeout) NN_NOEXCEPT;
    nn::Result CancelConnect() NN_NOEXCEPT;
    nn::Result Disconnect() NN_NOEXCEPT;
    nn::Result GetSystemEvent(nn::sf::Out<nn::sf::NativeHandle> pOutSystemEventReadableHandle, std::uint32_t type) NN_NOEXCEPT;
    nn::Result GetConnectionStatus(nn::sf::Out<nn::wlan::detail::SfdlConnectionStatus> pOutStatus) NN_NOEXCEPT;
    nn::Result GetState(nn::sf::Out<std::uint32_t> pOutState) NN_NOEXCEPT;
    nn::Result GetScanResult(const nn::sf::OutBuffer& pOutScanBuffer) NN_NOEXCEPT;
    nn::Result GetRssi(nn::sf::Out<std::int32_t> pOutRssi) NN_NOEXCEPT;
    nn::Result ChangeRxAntenna(std::int32_t rxAntenna) NN_NOEXCEPT;
    nn::Result GetFwVersion(const nn::sf::OutBuffer& pOutBuffer) NN_NOEXCEPT;
    nn::Result RequestSleep() NN_NOEXCEPT;
    nn::Result RequestWakeUp() NN_NOEXCEPT;
    nn::Result ConnectWithWps(std::uint32_t method, const nn::sf::InArray<char>& wpsPinArray, std::int32_t beaconLostTimeout) NN_NOEXCEPT;
    nn::Result GetWakeupReason(nn::sf::Out<std::uint32_t> pOutReason) NN_NOEXCEPT;
    nn::Result SetTcpSessionInformation(nn::wlan::detail::SfdlMacAddress dstMac, nn::wlan::WlanIpv4Address srcIp, nn::wlan::WlanIpv4Address dstIp, std::uint16_t srcPort, std::uint16_t dstPort, std::uint32_t ackNum, std::uint16_t windowSize) NN_NOEXCEPT;
    nn::Result RemoveTcpSessionInformation() NN_NOEXCEPT;
    nn::Result GetWakeupReasonRaw(nn::sf::Out<std::uint32_t> pOutReason) NN_NOEXCEPT;
    nn::Result SetWakeupReasonRaw(std::uint32_t reason) NN_NOEXCEPT;
    nn::Result EnableWowlFeatures(std::uint32_t features) NN_NOEXCEPT;
    nn::Result GetWowlStats(nn::sf::Out<nn::wlan::WowlWakeCount> pOutCounts, nn::sf::Out<nn::wlan::WowlSleepStats> pOutStats) NN_NOEXCEPT;
    nn::Result ClearWowlStats(bool counts, bool stats) NN_NOEXCEPT;
    nn::Result InitializeWlanOnSkipBoot() NN_NOEXCEPT;
    nn::Result EmulateDriverInitFail() NN_NOEXCEPT;
    nn::Result GetAllowedChannels(const nn::sf::OutArray<std::int16_t>& outArray, nn::sf::Out<std::uint32_t> pOutCount) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::wlan::detail::IInfraManager))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(OpenMode)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(OpenMode);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CloseMode)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CloseMode);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMacAddress, (::nn::sf::Out<::nn::wlan::detail::SfdlMacAddress> pOutMacAddr))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetMacAddress, (pOutMacAddr));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartScan, (const ::nn::wlan::detail::SfdlScanParameters& scanParam))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartScan, (scanParam));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StopScan)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(StopScan);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Connect, (const ::nn::wlan::detail::SfdlSsid& ssid, ::nn::wlan::detail::SfdlMacAddress bssid, ::std::int16_t channel, const ::nn::wlan::detail::SfdlSecurity& security, bool autoKeepAlive, ::std::int32_t beaconLostTimeout))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Connect, (ssid, bssid, channel, security, autoKeepAlive, beaconLostTimeout));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CancelConnect)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CancelConnect);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Disconnect)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(Disconnect);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutSystemEventReadableHandle, ::std::uint32_t type))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSystemEvent, (pOutSystemEventReadableHandle, type));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetConnectionStatus, (::nn::sf::Out<::nn::wlan::detail::SfdlConnectionStatus> pOutStatus))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetConnectionStatus, (pOutStatus));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::std::uint32_t> pOutState))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetState, (pOutState));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetScanResult, (const ::nn::sf::OutBuffer& pOutScanBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetScanResult, (pOutScanBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRssi, (::nn::sf::Out<::std::int32_t> pOutRssi))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRssi, (pOutRssi));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ChangeRxAntenna, (::std::int32_t rxAntenna))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ChangeRxAntenna, (rxAntenna));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFwVersion, (const ::nn::sf::OutBuffer& pOutBuffer))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFwVersion, (pOutBuffer));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RequestSleep)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(RequestSleep);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RequestWakeUp)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(RequestWakeUp);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ConnectWithWps, (::std::uint32_t method, const ::nn::sf::InArray<char>& wpsPinArray, ::std::int32_t beaconLostTimeout))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ConnectWithWps, (method, wpsPinArray, beaconLostTimeout));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetWakeupReason, (::nn::sf::Out<::std::uint32_t> pOutReason))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetWakeupReason, (pOutReason));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetTcpSessionInformation, (::nn::wlan::detail::SfdlMacAddress dstMac, ::nn::wlan::WlanIpv4Address srcIp, ::nn::wlan::WlanIpv4Address dstIp, ::std::uint16_t srcPort, ::std::uint16_t dstPort, ::std::uint32_t ackNum, ::std::uint16_t windowSize))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetTcpSessionInformation, (dstMac, srcIp, dstIp, srcPort, dstPort, ackNum, windowSize));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RemoveTcpSessionInformation)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(RemoveTcpSessionInformation);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetWakeupReasonRaw, (::nn::sf::Out<::std::uint32_t> pOutReason))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetWakeupReasonRaw, (pOutReason));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetWakeupReasonRaw, (::std::uint32_t reason))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetWakeupReasonRaw, (reason));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnableWowlFeatures, (::std::uint32_t features))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(EnableWowlFeatures, (features));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetWowlStats, (::nn::sf::Out<::nn::wlan::WowlWakeCount> pOutCounts, ::nn::sf::Out<::nn::wlan::WowlSleepStats> pOutStats))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetWowlStats, (pOutCounts, pOutStats));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ClearWowlStats, (bool counts, bool stats))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(ClearWowlStats, (counts, stats));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(InitializeWlanOnSkipBoot)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(InitializeWlanOnSkipBoot);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(EmulateDriverInitFail)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(EmulateDriverInitFail);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAllowedChannels, (const ::nn::sf::OutArray<::std::int16_t>& outArray, ::nn::sf::Out<::std::uint32_t> pOutCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAllowedChannels, (outArray, pOutCount));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::wlan::detail::IInfraManager>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::wlan::detail::IInfraManager))

    // nn::Result OpenMode() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenMode)

    // nn::Result CloseMode() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CloseMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CloseMode)

    // nn::Result GetMacAddress(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetMacAddress)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutMacAddr, (::nn::wlan::detail::SfdlMacAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutMacAddr))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutMacAddr)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetMacAddress)

    // nn::Result StartScan(const nn::wlan::detail::SfdlScanParameters& scanParam) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartScan)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(scanParam, 0, (const ::nn::wlan::detail::SfdlScanParameters&), 432, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (scanParam))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(scanParam)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartScan)

    // nn::Result StopScan() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StopScan)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StopScan)

    // nn::Result Connect(const nn::wlan::detail::SfdlSsid& ssid, nn::wlan::detail::SfdlMacAddress bssid, std::int16_t channel, const nn::wlan::detail::SfdlSecurity& security, bool autoKeepAlive, std::int32_t beaconLostTimeout) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Connect)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ssid, (::nn::wlan::detail::SfdlSsid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bssid, (::nn::wlan::detail::SfdlMacAddress), 33)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(autoKeepAlive, (bool), 39)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(channel, (::std::int16_t), 40)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(security, (::nn::wlan::detail::SfdlSecurity), 44)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(beaconLostTimeout, (::std::int32_t), 124)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(6, (ssid, bssid, autoKeepAlive, channel, security, beaconLostTimeout))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(128)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ssid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bssid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(channel), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(security), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(autoKeepAlive), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(beaconLostTimeout)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Connect)

    // nn::Result CancelConnect() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelConnect)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelConnect)

    // nn::Result Disconnect() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Disconnect)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Disconnect)

    // nn::Result GetSystemEvent(nn::sf::Out<nn::sf::NativeHandle> pOutSystemEventReadableHandle, std::uint32_t type) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSystemEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pOutSystemEventReadableHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pOutSystemEventReadableHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (type))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSystemEventReadableHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSystemEvent)

    // nn::Result GetConnectionStatus(nn::sf::Out<nn::wlan::detail::SfdlConnectionStatus> pOutStatus) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetConnectionStatus)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutStatus, (::nn::wlan::detail::SfdlConnectionStatus), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutStatus))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(60)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutStatus)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetConnectionStatus)

    // nn::Result GetState(nn::sf::Out<std::uint32_t> pOutState) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutState, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutState))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutState)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetState)

    // nn::Result GetScanResult(const nn::sf::OutBuffer& pOutScanBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetScanResult)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutScanBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutScanBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutScanBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetScanResult)

    // nn::Result GetRssi(nn::sf::Out<std::int32_t> pOutRssi) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRssi)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRssi, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutRssi))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRssi)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRssi)

    // nn::Result ChangeRxAntenna(std::int32_t rxAntenna) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ChangeRxAntenna)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rxAntenna, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rxAntenna))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rxAntenna)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ChangeRxAntenna)

    // nn::Result GetFwVersion(const nn::sf::OutBuffer& pOutBuffer) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFwVersion)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutBuffer, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutBuffer)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFwVersion)

    // nn::Result RequestSleep() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestSleep)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestSleep)

    // nn::Result RequestWakeUp() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RequestWakeUp)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RequestWakeUp)

    // nn::Result ConnectWithWps(std::uint32_t method, const nn::sf::InArray<char>& wpsPinArray, std::int32_t beaconLostTimeout) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ConnectWithWps)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(wpsPinArray, 0, (const ::nn::sf::InArray<char>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (wpsPinArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(method, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(beaconLostTimeout, (::std::int32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (method, beaconLostTimeout))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(method), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(wpsPinArray), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(beaconLostTimeout)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ConnectWithWps)

    // nn::Result GetWakeupReason(nn::sf::Out<std::uint32_t> pOutReason) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetWakeupReason)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutReason, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutReason))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutReason)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetWakeupReason)

    // nn::Result SetTcpSessionInformation(nn::wlan::detail::SfdlMacAddress dstMac, nn::wlan::WlanIpv4Address srcIp, nn::wlan::WlanIpv4Address dstIp, std::uint16_t srcPort, std::uint16_t dstPort, std::uint32_t ackNum, std::uint16_t windowSize) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetTcpSessionInformation)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(19)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(dstMac, (::nn::wlan::detail::SfdlMacAddress), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(srcPort, (::std::uint16_t), 6)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(dstPort, (::std::uint16_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(windowSize, (::std::uint16_t), 10)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(srcIp, (::nn::wlan::WlanIpv4Address), 12)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(dstIp, (::nn::wlan::WlanIpv4Address), 16)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ackNum, (::std::uint32_t), 20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(7, (dstMac, srcPort, dstPort, windowSize, srcIp, dstIp, ackNum))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(24)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dstMac), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(srcIp), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dstIp), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(srcPort), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dstPort), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ackNum), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(windowSize)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetTcpSessionInformation)

    // nn::Result RemoveTcpSessionInformation() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RemoveTcpSessionInformation)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RemoveTcpSessionInformation)

    // nn::Result GetWakeupReasonRaw(nn::sf::Out<std::uint32_t> pOutReason) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetWakeupReasonRaw)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutReason, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutReason))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutReason)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetWakeupReasonRaw)

    // nn::Result SetWakeupReasonRaw(std::uint32_t reason) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetWakeupReasonRaw)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(reason, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (reason))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(reason)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetWakeupReasonRaw)

    // nn::Result EnableWowlFeatures(std::uint32_t features) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableWowlFeatures)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(23)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(features, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (features))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(features)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableWowlFeatures)

    // nn::Result GetWowlStats(nn::sf::Out<nn::wlan::WowlWakeCount> pOutCounts, nn::sf::Out<nn::wlan::WowlSleepStats> pOutStats) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetWowlStats)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCounts, (::nn::wlan::WowlWakeCount), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutStats, (::nn::wlan::WowlSleepStats), 32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(2, (pOutCounts, pOutStats))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(88)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCounts), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutStats)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetWowlStats)

    // nn::Result ClearWowlStats(bool counts, bool stats) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(ClearWowlStats)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(25)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(counts, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(stats, (bool), 1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (counts, stats))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(counts), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(stats)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(ClearWowlStats)

    // nn::Result InitializeWlanOnSkipBoot() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(InitializeWlanOnSkipBoot)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(26)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(InitializeWlanOnSkipBoot)

    // nn::Result EmulateDriverInitFail() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EmulateDriverInitFail)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(27)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EmulateDriverInitFail)

    // nn::Result GetAllowedChannels(const nn::sf::OutArray<std::int16_t>& outArray, nn::sf::Out<std::uint32_t> pOutCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAllowedChannels)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(28)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outArray, 0, (const ::nn::sf::OutArray<::std::int16_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outArray), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAllowedChannels)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::wlan::detail::SfdlScanParameters), 432, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::wlan::detail::SfdlSsid), 33, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::wlan::detail::SfdlSecurity), 80, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::wlan::detail::SfdlConnectionStatus), 60, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::wlan::WlanIpv4Address), 4, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::wlan::WowlWakeCount), 32, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::wlan::WowlSleepStats), 56, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::wlan::detail::IInfraManager, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::wlan::detail::IInfraManager))

    // nn::Result OpenMode() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(OpenMode)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenMode)
    }

    // nn::Result CloseMode() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CloseMode)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CloseMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CloseMode)
    }

    // nn::Result GetMacAddress(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMacAddress, (::nn::sf::Out<::nn::wlan::detail::SfdlMacAddress> pOutMacAddr))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetMacAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutMacAddr)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetMacAddress)
    }

    // nn::Result StartScan(const nn::wlan::detail::SfdlScanParameters& scanParam) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartScan, (const ::nn::wlan::detail::SfdlScanParameters& scanParam))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartScan)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(scanParam)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartScan)
    }

    // nn::Result StopScan() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StopScan)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StopScan)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StopScan)
    }

    // nn::Result Connect(const nn::wlan::detail::SfdlSsid& ssid, nn::wlan::detail::SfdlMacAddress bssid, std::int16_t channel, const nn::wlan::detail::SfdlSecurity& security, bool autoKeepAlive, std::int32_t beaconLostTimeout) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Connect, (const ::nn::wlan::detail::SfdlSsid& ssid, ::nn::wlan::detail::SfdlMacAddress bssid, ::std::int16_t channel, const ::nn::wlan::detail::SfdlSecurity& security, bool autoKeepAlive, ::std::int32_t beaconLostTimeout))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Connect)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ssid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bssid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(channel)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(security)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(autoKeepAlive)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(beaconLostTimeout)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Connect)
    }

    // nn::Result CancelConnect() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CancelConnect)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelConnect)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelConnect)
    }

    // nn::Result Disconnect() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(Disconnect)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Disconnect)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Disconnect)
    }

    // nn::Result GetSystemEvent(nn::sf::Out<nn::sf::NativeHandle> pOutSystemEventReadableHandle, std::uint32_t type) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutSystemEventReadableHandle, ::std::uint32_t type))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSystemEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSystemEventReadableHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSystemEvent)
    }

    // nn::Result GetConnectionStatus(nn::sf::Out<nn::wlan::detail::SfdlConnectionStatus> pOutStatus) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetConnectionStatus, (::nn::sf::Out<::nn::wlan::detail::SfdlConnectionStatus> pOutStatus))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetConnectionStatus)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutStatus)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetConnectionStatus)
    }

    // nn::Result GetState(nn::sf::Out<std::uint32_t> pOutState) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::std::uint32_t> pOutState))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutState)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetState)
    }

    // nn::Result GetScanResult(const nn::sf::OutBuffer& pOutScanBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetScanResult, (const ::nn::sf::OutBuffer& pOutScanBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetScanResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutScanBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetScanResult)
    }

    // nn::Result GetRssi(nn::sf::Out<std::int32_t> pOutRssi) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRssi, (::nn::sf::Out<::std::int32_t> pOutRssi))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRssi)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRssi)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRssi)
    }

    // nn::Result ChangeRxAntenna(std::int32_t rxAntenna) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ChangeRxAntenna, (::std::int32_t rxAntenna))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ChangeRxAntenna)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rxAntenna)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ChangeRxAntenna)
    }

    // nn::Result GetFwVersion(const nn::sf::OutBuffer& pOutBuffer) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFwVersion, (const ::nn::sf::OutBuffer& pOutBuffer))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFwVersion)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutBuffer)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFwVersion)
    }

    // nn::Result RequestSleep() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RequestSleep)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestSleep)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestSleep)
    }

    // nn::Result RequestWakeUp() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RequestWakeUp)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RequestWakeUp)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RequestWakeUp)
    }

    // nn::Result ConnectWithWps(std::uint32_t method, const nn::sf::InArray<char>& wpsPinArray, std::int32_t beaconLostTimeout) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ConnectWithWps, (::std::uint32_t method, const ::nn::sf::InArray<char>& wpsPinArray, ::std::int32_t beaconLostTimeout))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ConnectWithWps)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(method)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(wpsPinArray)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(beaconLostTimeout)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ConnectWithWps)
    }

    // nn::Result GetWakeupReason(nn::sf::Out<std::uint32_t> pOutReason) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetWakeupReason, (::nn::sf::Out<::std::uint32_t> pOutReason))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetWakeupReason)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutReason)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetWakeupReason)
    }

    // nn::Result SetTcpSessionInformation(nn::wlan::detail::SfdlMacAddress dstMac, nn::wlan::WlanIpv4Address srcIp, nn::wlan::WlanIpv4Address dstIp, std::uint16_t srcPort, std::uint16_t dstPort, std::uint32_t ackNum, std::uint16_t windowSize) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetTcpSessionInformation, (::nn::wlan::detail::SfdlMacAddress dstMac, ::nn::wlan::WlanIpv4Address srcIp, ::nn::wlan::WlanIpv4Address dstIp, ::std::uint16_t srcPort, ::std::uint16_t dstPort, ::std::uint32_t ackNum, ::std::uint16_t windowSize))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetTcpSessionInformation)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dstMac)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(srcIp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dstIp)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(srcPort)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dstPort)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ackNum)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(windowSize)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetTcpSessionInformation)
    }

    // nn::Result RemoveTcpSessionInformation() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(RemoveTcpSessionInformation)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RemoveTcpSessionInformation)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RemoveTcpSessionInformation)
    }

    // nn::Result GetWakeupReasonRaw(nn::sf::Out<std::uint32_t> pOutReason) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetWakeupReasonRaw, (::nn::sf::Out<::std::uint32_t> pOutReason))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetWakeupReasonRaw)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutReason)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetWakeupReasonRaw)
    }

    // nn::Result SetWakeupReasonRaw(std::uint32_t reason) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetWakeupReasonRaw, (::std::uint32_t reason))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetWakeupReasonRaw)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(reason)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetWakeupReasonRaw)
    }

    // nn::Result EnableWowlFeatures(std::uint32_t features) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(EnableWowlFeatures, (::std::uint32_t features))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableWowlFeatures)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(features)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableWowlFeatures)
    }

    // nn::Result GetWowlStats(nn::sf::Out<nn::wlan::WowlWakeCount> pOutCounts, nn::sf::Out<nn::wlan::WowlSleepStats> pOutStats) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetWowlStats, (::nn::sf::Out<::nn::wlan::WowlWakeCount> pOutCounts, ::nn::sf::Out<::nn::wlan::WowlSleepStats> pOutStats))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetWowlStats)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCounts)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutStats)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetWowlStats)
    }

    // nn::Result ClearWowlStats(bool counts, bool stats) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(ClearWowlStats, (bool counts, bool stats))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(ClearWowlStats)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(counts)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(stats)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(ClearWowlStats)
    }

    // nn::Result InitializeWlanOnSkipBoot() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(InitializeWlanOnSkipBoot)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(InitializeWlanOnSkipBoot)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(InitializeWlanOnSkipBoot)
    }

    // nn::Result EmulateDriverInitFail() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(EmulateDriverInitFail)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EmulateDriverInitFail)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EmulateDriverInitFail)
    }

    // nn::Result GetAllowedChannels(const nn::sf::OutArray<std::int16_t>& outArray, nn::sf::Out<std::uint32_t> pOutCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAllowedChannels, (const ::nn::sf::OutArray<::std::int16_t>& outArray, ::nn::sf::Out<::std::uint32_t> pOutCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAllowedChannels)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outArray)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAllowedChannels)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::wlan::detail::IInfraManager>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::wlan::detail::IInfraManager))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CloseMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CloseMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetMacAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetMacAddress)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutMacAddr)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartScan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(scanParam)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartScan)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(scanParam)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StopScan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StopScan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Connect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Connect)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ssid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bssid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(channel),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(security),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(autoKeepAlive),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(beaconLostTimeout)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelConnect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelConnect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Disconnect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Disconnect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSystemEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pOutSystemEventReadableHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSystemEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pOutSystemEventReadableHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetConnectionStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetConnectionStatus)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetScanResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutScanBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetScanResult)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutScanBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRssi)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRssi)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRssi)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ChangeRxAntenna)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ChangeRxAntenna)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rxAntenna)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFwVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFwVersion)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutBuffer)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestSleep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestSleep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RequestWakeUp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RequestWakeUp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ConnectWithWps)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(wpsPinArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ConnectWithWps)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(method),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(wpsPinArray),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(beaconLostTimeout)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetWakeupReason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetWakeupReason)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutReason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetTcpSessionInformation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetTcpSessionInformation)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(dstMac),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(srcIp),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(dstIp),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(srcPort),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(dstPort),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ackNum),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(windowSize)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RemoveTcpSessionInformation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RemoveTcpSessionInformation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetWakeupReasonRaw)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetWakeupReasonRaw)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutReason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetWakeupReasonRaw)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetWakeupReasonRaw)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(reason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableWowlFeatures)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableWowlFeatures)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(features)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetWowlStats)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetWowlStats)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCounts),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutStats)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(ClearWowlStats)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(ClearWowlStats)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(counts),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(stats)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(InitializeWlanOnSkipBoot)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(InitializeWlanOnSkipBoot)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EmulateDriverInitFail)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EmulateDriverInitFail)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAllowedChannels)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAllowedChannels)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outArray),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CloseMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetMacAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartScan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StopScan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Connect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelConnect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Disconnect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSystemEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetConnectionStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetScanResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRssi)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ChangeRxAntenna)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFwVersion)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestSleep)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RequestWakeUp)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ConnectWithWps)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetWakeupReason)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetTcpSessionInformation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RemoveTcpSessionInformation)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetWakeupReasonRaw)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetWakeupReasonRaw)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableWowlFeatures)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetWowlStats)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(ClearWowlStats)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(InitializeWlanOnSkipBoot)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EmulateDriverInitFail)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAllowedChannels)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::wlan::detail::IInfraManager))

namespace nn { namespace wlan { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ILocalGetActionFrame, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ILocalGetActionFrame)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetActionFrameCore, (::nn::sf::Out<::nn::wlan::detail::SfdlMacAddress> pOutMacAddr, const ::nn::sf::OutBuffer& pOutRxData, ::nn::sf::Out<::std::uint32_t> pOutSize, ::std::uint32_t rxId, ::nn::sf::Out<::std::uint16_t> pOutChannel, ::nn::sf::Out<::std::int16_t> pOutRssi, bool isEx))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ILocalGetActionFrame)

        ::nn::Result GetActionFrameCore(::nn::sf::Out<::nn::wlan::detail::SfdlMacAddress> pOutMacAddr, const ::nn::sf::OutBuffer& pOutRxData, ::nn::sf::Out<::std::uint32_t> pOutSize, ::std::uint32_t rxId, ::nn::sf::Out<::std::uint16_t> pOutChannel, ::nn::sf::Out<::std::int16_t> pOutRssi, bool isEx) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetActionFrameCore, (pOutMacAddr, pOutRxData, pOutSize, rxId, pOutChannel, pOutRssi, isEx));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ILocalGetActionFrame
    {
    public:
        nn::Result GetActionFrameCore(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr, const nn::sf::OutBuffer& pOutRxData, nn::sf::Out<std::uint32_t> pOutSize, std::uint32_t rxId, nn::sf::Out<std::uint16_t> pOutChannel, nn::sf::Out<std::int16_t> pOutRssi, bool isEx) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetActionFrameCore(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr, const nn::sf::OutBuffer& pOutRxData, nn::sf::Out<std::uint32_t> pOutSize, std::uint32_t rxId, nn::sf::Out<std::uint16_t> pOutChannel, nn::sf::Out<std::int16_t> pOutRssi, bool isEx) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::wlan::detail::ILocalGetActionFrame))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActionFrameCore, (::nn::sf::Out<::nn::wlan::detail::SfdlMacAddress> pOutMacAddr, const ::nn::sf::OutBuffer& pOutRxData, ::nn::sf::Out<::std::uint32_t> pOutSize, ::std::uint32_t rxId, ::nn::sf::Out<::std::uint16_t> pOutChannel, ::nn::sf::Out<::std::int16_t> pOutRssi, bool isEx))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetActionFrameCore, (pOutMacAddr, pOutRxData, pOutSize, rxId, pOutChannel, pOutRssi, isEx));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::wlan::detail::ILocalGetActionFrame>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::wlan::detail::ILocalGetActionFrame))

    // nn::Result GetActionFrameCore(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr, const nn::sf::OutBuffer& pOutRxData, nn::sf::Out<std::uint32_t> pOutSize, std::uint32_t rxId, nn::sf::Out<std::uint16_t> pOutChannel, nn::sf::Out<std::int16_t> pOutRssi, bool isEx) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetActionFrameCore)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutRxData, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutRxData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(isEx, (bool), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rxId, (::std::uint32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (isEx, rxId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutMacAddr, (::nn::wlan::detail::SfdlMacAddress), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutChannel, (::std::uint16_t), 6)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRssi, (::std::int16_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSize, (::std::uint32_t), 12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(4, (pOutMacAddr, pOutChannel, pOutRssi, pOutSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutMacAddr), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRxData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rxId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutChannel), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRssi), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(isEx)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetActionFrameCore)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::wlan::detail::ILocalGetActionFrame, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::wlan::detail::ILocalGetActionFrame))

    // nn::Result GetActionFrameCore(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr, const nn::sf::OutBuffer& pOutRxData, nn::sf::Out<std::uint32_t> pOutSize, std::uint32_t rxId, nn::sf::Out<std::uint16_t> pOutChannel, nn::sf::Out<std::int16_t> pOutRssi, bool isEx) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetActionFrameCore, (::nn::sf::Out<::nn::wlan::detail::SfdlMacAddress> pOutMacAddr, const ::nn::sf::OutBuffer& pOutRxData, ::nn::sf::Out<::std::uint32_t> pOutSize, ::std::uint32_t rxId, ::nn::sf::Out<::std::uint16_t> pOutChannel, ::nn::sf::Out<::std::int16_t> pOutRssi, bool isEx))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetActionFrameCore)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutMacAddr)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRxData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rxId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutChannel)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRssi)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(isEx)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetActionFrameCore)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::wlan::detail::ILocalGetActionFrame>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::wlan::detail::ILocalGetActionFrame))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetActionFrameCore)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutRxData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetActionFrameCore)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutMacAddr),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutRxData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rxId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutChannel),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRssi),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(isEx)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetActionFrameCore)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::wlan::detail::ILocalGetActionFrame))

namespace nn { namespace wlan { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ILocalGetFrame, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ILocalGetFrame)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFrameRaw, (const ::nn::sf::OutBuffer& pOutRxData, ::nn::sf::Out<::std::uint32_t> pOutSize, ::std::uint32_t rxId))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ILocalGetFrame)

        ::nn::Result GetFrameRaw(const ::nn::sf::OutBuffer& pOutRxData, ::nn::sf::Out<::std::uint32_t> pOutSize, ::std::uint32_t rxId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFrameRaw, (pOutRxData, pOutSize, rxId));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ILocalGetFrame
    {
    public:
        nn::Result GetFrameRaw(const nn::sf::OutBuffer& pOutRxData, nn::sf::Out<std::uint32_t> pOutSize, std::uint32_t rxId) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetFrameRaw(const nn::sf::OutBuffer& pOutRxData, nn::sf::Out<std::uint32_t> pOutSize, std::uint32_t rxId) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::wlan::detail::ILocalGetFrame))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFrameRaw, (const ::nn::sf::OutBuffer& pOutRxData, ::nn::sf::Out<::std::uint32_t> pOutSize, ::std::uint32_t rxId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFrameRaw, (pOutRxData, pOutSize, rxId));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::wlan::detail::ILocalGetFrame>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::wlan::detail::ILocalGetFrame))

    // nn::Result GetFrameRaw(const nn::sf::OutBuffer& pOutRxData, nn::sf::Out<std::uint32_t> pOutSize, std::uint32_t rxId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFrameRaw)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutRxData, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutRxData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rxId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rxId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSize, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRxData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rxId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFrameRaw)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::wlan::detail::ILocalGetFrame, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::wlan::detail::ILocalGetFrame))

    // nn::Result GetFrameRaw(const nn::sf::OutBuffer& pOutRxData, nn::sf::Out<std::uint32_t> pOutSize, std::uint32_t rxId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFrameRaw, (const ::nn::sf::OutBuffer& pOutRxData, ::nn::sf::Out<::std::uint32_t> pOutSize, ::std::uint32_t rxId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFrameRaw)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRxData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rxId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFrameRaw)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::wlan::detail::ILocalGetFrame>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::wlan::detail::ILocalGetFrame))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFrameRaw)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutRxData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFrameRaw)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutRxData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rxId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFrameRaw)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::wlan::detail::ILocalGetFrame))

namespace nn { namespace wlan { namespace detail { // NOLINT(whitespace/braces)

struct SfdlBssInfo
{
    nn::Bit8 bssinfo[1300];
};

struct SfdlClientStatus
{
    std::uint32_t state;
    std::uint32_t cause;
    nn::wlan::detail::SfdlMacAddress clientMacAddress;
    std::uint16_t statusReasonCode;
    std::uint16_t capabilityInfo;
    std::int32_t rssi;
    std::int64_t updateTick;
};

struct SfdlClientStatusList
{
    nn::wlan::detail::SfdlClientStatus statusList[7];
    nn::Bit32 updatedIndexBitMap;
};

struct SfdlDisconnectClient
{
    nn::wlan::detail::SfdlMacAddress clientMacAddress;
    std::uint32_t reasonCode;
};

struct SfdlMasterBssParameters
{
    std::uint32_t inactivePeriod;
    std::uint32_t supportedRates;
    std::uint32_t basicRates;
    nn::wlan::detail::SfdlSecurity security;
    nn::wlan::detail::SfdlSsid ssid;
    std::uint16_t beaconInterval;
    std::int16_t channel;
    bool hiddenSsid;
    bool autoKeepAlive;
};

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ILocalManager, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ILocalManager)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(OpenMasterMode)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CloseMasterMode)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(OpenClientMode)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CloseClientMode)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(OpenSpectatorMode)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CloseSpectatorMode)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetMacAddress, (::nn::sf::Out<::nn::wlan::detail::SfdlMacAddress> pOutMacAddr))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateBss, (const ::nn::wlan::detail::SfdlMasterBssParameters& bssParameters))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(DestroyBss)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(StartScan, (const ::nn::wlan::detail::SfdlScanParameters& scanParam))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(StopScan)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Connect, (const ::nn::wlan::detail::SfdlSsid& ssid, ::nn::wlan::detail::SfdlMacAddress bssid, ::std::int16_t channel, const ::nn::wlan::detail::SfdlSecurity& security, bool autoKeepAlive, ::std::uint32_t beaconInd, ::std::int32_t beaconLostTimeout))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CancelConnect)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Join, (const ::nn::wlan::detail::SfdlSsid& ssid, ::nn::wlan::detail::SfdlMacAddress bssid, ::std::int16_t channel, const ::nn::wlan::detail::SfdlSecurity& security, ::std::uint32_t beaconInd, ::std::int32_t beaconLostTimeout))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CancelJoin)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(Disconnect, (::std::uint32_t mode, const ::nn::wlan::detail::SfdlDisconnectClient& client))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetBeaconLostCount, (::std::uint32_t count))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutSystemEventReadableHandle, ::std::uint32_t type))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetConnectionStatus, (::nn::sf::Out<::nn::wlan::detail::SfdlConnectionStatus> pOutStatus))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetClientStatus, (::nn::sf::Out<::nn::wlan::detail::SfdlClientStatusList> pOutStatusList))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetBssIndicationEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutSystemEventReadableHandle))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetBssIndicationInfo, (::nn::sf::Out<::nn::wlan::detail::SfdlBssInfo> pOutInfo))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::std::uint32_t> pOutState))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetAllowedChannels, (const ::nn::sf::OutArray<::std::int16_t>& pOutArray, ::nn::sf::Out<::std::uint32_t> pOutCount))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AddIe, (::nn::sf::Out<::std::uint32_t> pOutIeIndex, ::std::uint32_t managementFrameType, const ::nn::sf::InBuffer& pIeBody))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteIe, (::std::uint32_t ieIndex))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PutFrameRaw, (const ::nn::sf::InBuffer& pTxData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CancelGetFrame, (::std::uint32_t rxId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateRxEntry, (::nn::sf::Out<::std::uint32_t> pOutRxId, const ::nn::sf::InArray<::std::uint16_t>& pEthertypeArray, ::std::uint32_t capacity))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteRxEntry, (::std::uint32_t rxId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AddEthertypeToRxEntry, (::std::uint32_t rxId, ::std::uint16_t ethertype))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteEthertypeFromRxEntry, (::nn::sf::Out<::std::uint32_t> pOutRxId, ::std::uint16_t ethertype))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AddMatchingDataToRxEntry, (::std::uint32_t rxId, const ::nn::wlan::ReceivedDataMatchInfo& pMatchInfo))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RemoveMatchingDataFromRxEntry, (::std::uint32_t rxId, const ::nn::wlan::ReceivedDataMatchInfo& pMatchInfo))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetScanResult, (const ::nn::sf::OutBuffer& pOutScanBuffer, const ::nn::wlan::ScanIeMatchInfo& ieInfo))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PutActionFrameOneShot, (::nn::wlan::detail::SfdlMacAddress macAddr, const ::nn::sf::InBuffer& pTxData, ::std::uint32_t channel, ::std::uint32_t dwellTime))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetActionFrameWithBeacon, (const ::nn::sf::InBuffer& pTxData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CancelActionFrameWithBeacon)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateRxEntryForActionFrame, (::nn::sf::Out<::std::uint32_t> pOutRxId, const ::nn::sf::InArray<::std::uint16_t>& pSubtypeArray, ::std::uint32_t capacity))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteRxEntryForActionFrame, (::std::uint32_t rxId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AddSubtypeToRxEntryForActionFrame, (::std::uint32_t rxId, ::std::uint32_t type))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteSubtypeFromRxEntryForActionFrame, (::nn::sf::Out<::std::uint32_t> pOutRxId, ::std::uint32_t type))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CancelGetActionFrame, (::std::uint32_t rxId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetRssi, (::nn::sf::Out<::std::int32_t> pOutRssi))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetMaxAssociationNumber, (::std::uint32_t maxNum))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(OpenLcsMasterMode)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CloseLcsMasterMode)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(OpenLcsClientMode)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(CloseLcsClientMode)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetChannelStats, (const ::nn::sf::OutArray<::nn::wlan::ChannelStats>& outStats, ::nn::sf::Out<::std::uint32_t> pOutCount))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ILocalManager)

        ::nn::Result OpenMasterMode() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(OpenMasterMode);
        }

        ::nn::Result CloseMasterMode() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CloseMasterMode);
        }

        ::nn::Result OpenClientMode() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(OpenClientMode);
        }

        ::nn::Result CloseClientMode() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CloseClientMode);
        }

        ::nn::Result OpenSpectatorMode() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(OpenSpectatorMode);
        }

        ::nn::Result CloseSpectatorMode() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CloseSpectatorMode);
        }

        ::nn::Result GetMacAddress(::nn::sf::Out<::nn::wlan::detail::SfdlMacAddress> pOutMacAddr) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetMacAddress, (pOutMacAddr));
        }

        ::nn::Result CreateBss(const ::nn::wlan::detail::SfdlMasterBssParameters& bssParameters) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateBss, (bssParameters));
        }

        ::nn::Result DestroyBss() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(DestroyBss);
        }

        ::nn::Result StartScan(const ::nn::wlan::detail::SfdlScanParameters& scanParam) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(StartScan, (scanParam));
        }

        ::nn::Result StopScan() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(StopScan);
        }

        ::nn::Result Connect(const ::nn::wlan::detail::SfdlSsid& ssid, ::nn::wlan::detail::SfdlMacAddress bssid, ::std::int16_t channel, const ::nn::wlan::detail::SfdlSecurity& security, bool autoKeepAlive, ::std::uint32_t beaconInd, ::std::int32_t beaconLostTimeout) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Connect, (ssid, bssid, channel, security, autoKeepAlive, beaconInd, beaconLostTimeout));
        }

        ::nn::Result CancelConnect() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CancelConnect);
        }

        ::nn::Result Join(const ::nn::wlan::detail::SfdlSsid& ssid, ::nn::wlan::detail::SfdlMacAddress bssid, ::std::int16_t channel, const ::nn::wlan::detail::SfdlSecurity& security, ::std::uint32_t beaconInd, ::std::int32_t beaconLostTimeout) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Join, (ssid, bssid, channel, security, beaconInd, beaconLostTimeout));
        }

        ::nn::Result CancelJoin() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CancelJoin);
        }

        ::nn::Result Disconnect(::std::uint32_t mode, const ::nn::wlan::detail::SfdlDisconnectClient& client) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(Disconnect, (mode, client));
        }

        ::nn::Result SetBeaconLostCount(::std::uint32_t count) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetBeaconLostCount, (count));
        }

        ::nn::Result GetSystemEvent(::nn::sf::Out<::nn::sf::NativeHandle> pOutSystemEventReadableHandle, ::std::uint32_t type) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetSystemEvent, (pOutSystemEventReadableHandle, type));
        }

        ::nn::Result GetConnectionStatus(::nn::sf::Out<::nn::wlan::detail::SfdlConnectionStatus> pOutStatus) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetConnectionStatus, (pOutStatus));
        }

        ::nn::Result GetClientStatus(::nn::sf::Out<::nn::wlan::detail::SfdlClientStatusList> pOutStatusList) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetClientStatus, (pOutStatusList));
        }

        ::nn::Result GetBssIndicationEvent(::nn::sf::Out<::nn::sf::NativeHandle> pOutSystemEventReadableHandle) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetBssIndicationEvent, (pOutSystemEventReadableHandle));
        }

        ::nn::Result GetBssIndicationInfo(::nn::sf::Out<::nn::wlan::detail::SfdlBssInfo> pOutInfo) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetBssIndicationInfo, (pOutInfo));
        }

        ::nn::Result GetState(::nn::sf::Out<::std::uint32_t> pOutState) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetState, (pOutState));
        }

        ::nn::Result GetAllowedChannels(const ::nn::sf::OutArray<::std::int16_t>& pOutArray, ::nn::sf::Out<::std::uint32_t> pOutCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetAllowedChannels, (pOutArray, pOutCount));
        }

        ::nn::Result AddIe(::nn::sf::Out<::std::uint32_t> pOutIeIndex, ::std::uint32_t managementFrameType, const ::nn::sf::InBuffer& pIeBody) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AddIe, (pOutIeIndex, managementFrameType, pIeBody));
        }

        ::nn::Result DeleteIe(::std::uint32_t ieIndex) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteIe, (ieIndex));
        }

        ::nn::Result PutFrameRaw(const ::nn::sf::InBuffer& pTxData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PutFrameRaw, (pTxData));
        }

        ::nn::Result CancelGetFrame(::std::uint32_t rxId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CancelGetFrame, (rxId));
        }

        ::nn::Result CreateRxEntry(::nn::sf::Out<::std::uint32_t> pOutRxId, const ::nn::sf::InArray<::std::uint16_t>& pEthertypeArray, ::std::uint32_t capacity) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateRxEntry, (pOutRxId, pEthertypeArray, capacity));
        }

        ::nn::Result DeleteRxEntry(::std::uint32_t rxId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteRxEntry, (rxId));
        }

        ::nn::Result AddEthertypeToRxEntry(::std::uint32_t rxId, ::std::uint16_t ethertype) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AddEthertypeToRxEntry, (rxId, ethertype));
        }

        ::nn::Result DeleteEthertypeFromRxEntry(::nn::sf::Out<::std::uint32_t> pOutRxId, ::std::uint16_t ethertype) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteEthertypeFromRxEntry, (pOutRxId, ethertype));
        }

        ::nn::Result AddMatchingDataToRxEntry(::std::uint32_t rxId, const ::nn::wlan::ReceivedDataMatchInfo& pMatchInfo) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AddMatchingDataToRxEntry, (rxId, pMatchInfo));
        }

        ::nn::Result RemoveMatchingDataFromRxEntry(::std::uint32_t rxId, const ::nn::wlan::ReceivedDataMatchInfo& pMatchInfo) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RemoveMatchingDataFromRxEntry, (rxId, pMatchInfo));
        }

        ::nn::Result GetScanResult(const ::nn::sf::OutBuffer& pOutScanBuffer, const ::nn::wlan::ScanIeMatchInfo& ieInfo) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetScanResult, (pOutScanBuffer, ieInfo));
        }

        ::nn::Result PutActionFrameOneShot(::nn::wlan::detail::SfdlMacAddress macAddr, const ::nn::sf::InBuffer& pTxData, ::std::uint32_t channel, ::std::uint32_t dwellTime) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PutActionFrameOneShot, (macAddr, pTxData, channel, dwellTime));
        }

        ::nn::Result SetActionFrameWithBeacon(const ::nn::sf::InBuffer& pTxData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetActionFrameWithBeacon, (pTxData));
        }

        ::nn::Result CancelActionFrameWithBeacon() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CancelActionFrameWithBeacon);
        }

        ::nn::Result CreateRxEntryForActionFrame(::nn::sf::Out<::std::uint32_t> pOutRxId, const ::nn::sf::InArray<::std::uint16_t>& pSubtypeArray, ::std::uint32_t capacity) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateRxEntryForActionFrame, (pOutRxId, pSubtypeArray, capacity));
        }

        ::nn::Result DeleteRxEntryForActionFrame(::std::uint32_t rxId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteRxEntryForActionFrame, (rxId));
        }

        ::nn::Result AddSubtypeToRxEntryForActionFrame(::std::uint32_t rxId, ::std::uint32_t type) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AddSubtypeToRxEntryForActionFrame, (rxId, type));
        }

        ::nn::Result DeleteSubtypeFromRxEntryForActionFrame(::nn::sf::Out<::std::uint32_t> pOutRxId, ::std::uint32_t type) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteSubtypeFromRxEntryForActionFrame, (pOutRxId, type));
        }

        ::nn::Result CancelGetActionFrame(::std::uint32_t rxId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CancelGetActionFrame, (rxId));
        }

        ::nn::Result GetRssi(::nn::sf::Out<::std::int32_t> pOutRssi) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetRssi, (pOutRssi));
        }

        ::nn::Result SetMaxAssociationNumber(::std::uint32_t maxNum) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetMaxAssociationNumber, (maxNum));
        }

        ::nn::Result OpenLcsMasterMode() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(OpenLcsMasterMode);
        }

        ::nn::Result CloseLcsMasterMode() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CloseLcsMasterMode);
        }

        ::nn::Result OpenLcsClientMode() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(OpenLcsClientMode);
        }

        ::nn::Result CloseLcsClientMode() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(CloseLcsClientMode);
        }

        ::nn::Result GetChannelStats(const ::nn::sf::OutArray<::nn::wlan::ChannelStats>& outStats, ::nn::sf::Out<::std::uint32_t> pOutCount) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetChannelStats, (outStats, pOutCount));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ILocalManager
    {
    public:
        nn::Result OpenMasterMode() NN_NOEXCEPT;
        nn::Result CloseMasterMode() NN_NOEXCEPT;
        nn::Result OpenClientMode() NN_NOEXCEPT;
        nn::Result CloseClientMode() NN_NOEXCEPT;
        nn::Result OpenSpectatorMode() NN_NOEXCEPT;
        nn::Result CloseSpectatorMode() NN_NOEXCEPT;
        nn::Result GetMacAddress(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr) NN_NOEXCEPT;
        nn::Result CreateBss(const nn::wlan::detail::SfdlMasterBssParameters& bssParameters) NN_NOEXCEPT;
        nn::Result DestroyBss() NN_NOEXCEPT;
        nn::Result StartScan(const nn::wlan::detail::SfdlScanParameters& scanParam) NN_NOEXCEPT;
        nn::Result StopScan() NN_NOEXCEPT;
        nn::Result Connect(const nn::wlan::detail::SfdlSsid& ssid, nn::wlan::detail::SfdlMacAddress bssid, std::int16_t channel, const nn::wlan::detail::SfdlSecurity& security, bool autoKeepAlive, std::uint32_t beaconInd, std::int32_t beaconLostTimeout) NN_NOEXCEPT;
        nn::Result CancelConnect() NN_NOEXCEPT;
        nn::Result Join(const nn::wlan::detail::SfdlSsid& ssid, nn::wlan::detail::SfdlMacAddress bssid, std::int16_t channel, const nn::wlan::detail::SfdlSecurity& security, std::uint32_t beaconInd, std::int32_t beaconLostTimeout) NN_NOEXCEPT;
        nn::Result CancelJoin() NN_NOEXCEPT;
        nn::Result Disconnect(std::uint32_t mode, const nn::wlan::detail::SfdlDisconnectClient& client) NN_NOEXCEPT;
        nn::Result SetBeaconLostCount(std::uint32_t count) NN_NOEXCEPT;
        nn::Result GetSystemEvent(nn::sf::Out<nn::sf::NativeHandle> pOutSystemEventReadableHandle, std::uint32_t type) NN_NOEXCEPT;
        nn::Result GetConnectionStatus(nn::sf::Out<nn::wlan::detail::SfdlConnectionStatus> pOutStatus) NN_NOEXCEPT;
        nn::Result GetClientStatus(nn::sf::Out<nn::wlan::detail::SfdlClientStatusList> pOutStatusList) NN_NOEXCEPT;
        nn::Result GetBssIndicationEvent(nn::sf::Out<nn::sf::NativeHandle> pOutSystemEventReadableHandle) NN_NOEXCEPT;
        nn::Result GetBssIndicationInfo(nn::sf::Out<nn::wlan::detail::SfdlBssInfo> pOutInfo) NN_NOEXCEPT;
        nn::Result GetState(nn::sf::Out<std::uint32_t> pOutState) NN_NOEXCEPT;
        nn::Result GetAllowedChannels(const nn::sf::OutArray<std::int16_t>& pOutArray, nn::sf::Out<std::uint32_t> pOutCount) NN_NOEXCEPT;
        nn::Result AddIe(nn::sf::Out<std::uint32_t> pOutIeIndex, std::uint32_t managementFrameType, const nn::sf::InBuffer& pIeBody) NN_NOEXCEPT;
        nn::Result DeleteIe(std::uint32_t ieIndex) NN_NOEXCEPT;
        nn::Result PutFrameRaw(const nn::sf::InBuffer& pTxData) NN_NOEXCEPT;
        nn::Result CancelGetFrame(std::uint32_t rxId) NN_NOEXCEPT;
        nn::Result CreateRxEntry(nn::sf::Out<std::uint32_t> pOutRxId, const nn::sf::InArray<std::uint16_t>& pEthertypeArray, std::uint32_t capacity) NN_NOEXCEPT;
        nn::Result DeleteRxEntry(std::uint32_t rxId) NN_NOEXCEPT;
        nn::Result AddEthertypeToRxEntry(std::uint32_t rxId, std::uint16_t ethertype) NN_NOEXCEPT;
        nn::Result DeleteEthertypeFromRxEntry(nn::sf::Out<std::uint32_t> pOutRxId, std::uint16_t ethertype) NN_NOEXCEPT;
        nn::Result AddMatchingDataToRxEntry(std::uint32_t rxId, const nn::wlan::ReceivedDataMatchInfo& pMatchInfo) NN_NOEXCEPT;
        nn::Result RemoveMatchingDataFromRxEntry(std::uint32_t rxId, const nn::wlan::ReceivedDataMatchInfo& pMatchInfo) NN_NOEXCEPT;
        nn::Result GetScanResult(const nn::sf::OutBuffer& pOutScanBuffer, const nn::wlan::ScanIeMatchInfo& ieInfo) NN_NOEXCEPT;
        nn::Result PutActionFrameOneShot(nn::wlan::detail::SfdlMacAddress macAddr, const nn::sf::InBuffer& pTxData, std::uint32_t channel, std::uint32_t dwellTime) NN_NOEXCEPT;
        nn::Result SetActionFrameWithBeacon(const nn::sf::InBuffer& pTxData) NN_NOEXCEPT;
        nn::Result CancelActionFrameWithBeacon() NN_NOEXCEPT;
        nn::Result CreateRxEntryForActionFrame(nn::sf::Out<std::uint32_t> pOutRxId, const nn::sf::InArray<std::uint16_t>& pSubtypeArray, std::uint32_t capacity) NN_NOEXCEPT;
        nn::Result DeleteRxEntryForActionFrame(std::uint32_t rxId) NN_NOEXCEPT;
        nn::Result AddSubtypeToRxEntryForActionFrame(std::uint32_t rxId, std::uint32_t type) NN_NOEXCEPT;
        nn::Result DeleteSubtypeFromRxEntryForActionFrame(nn::sf::Out<std::uint32_t> pOutRxId, std::uint32_t type) NN_NOEXCEPT;
        nn::Result CancelGetActionFrame(std::uint32_t rxId) NN_NOEXCEPT;
        nn::Result GetRssi(nn::sf::Out<std::int32_t> pOutRssi) NN_NOEXCEPT;
        nn::Result SetMaxAssociationNumber(std::uint32_t maxNum) NN_NOEXCEPT;
        nn::Result OpenLcsMasterMode() NN_NOEXCEPT;
        nn::Result CloseLcsMasterMode() NN_NOEXCEPT;
        nn::Result OpenLcsClientMode() NN_NOEXCEPT;
        nn::Result CloseLcsClientMode() NN_NOEXCEPT;
        nn::Result GetChannelStats(const nn::sf::OutArray<nn::wlan::ChannelStats>& outStats, nn::sf::Out<std::uint32_t> pOutCount) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result OpenMasterMode() NN_NOEXCEPT;
    nn::Result CloseMasterMode() NN_NOEXCEPT;
    nn::Result OpenClientMode() NN_NOEXCEPT;
    nn::Result CloseClientMode() NN_NOEXCEPT;
    nn::Result OpenSpectatorMode() NN_NOEXCEPT;
    nn::Result CloseSpectatorMode() NN_NOEXCEPT;
    nn::Result GetMacAddress(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr) NN_NOEXCEPT;
    nn::Result CreateBss(const nn::wlan::detail::SfdlMasterBssParameters& bssParameters) NN_NOEXCEPT;
    nn::Result DestroyBss() NN_NOEXCEPT;
    nn::Result StartScan(const nn::wlan::detail::SfdlScanParameters& scanParam) NN_NOEXCEPT;
    nn::Result StopScan() NN_NOEXCEPT;
    nn::Result Connect(const nn::wlan::detail::SfdlSsid& ssid, nn::wlan::detail::SfdlMacAddress bssid, std::int16_t channel, const nn::wlan::detail::SfdlSecurity& security, bool autoKeepAlive, std::uint32_t beaconInd, std::int32_t beaconLostTimeout) NN_NOEXCEPT;
    nn::Result CancelConnect() NN_NOEXCEPT;
    nn::Result Join(const nn::wlan::detail::SfdlSsid& ssid, nn::wlan::detail::SfdlMacAddress bssid, std::int16_t channel, const nn::wlan::detail::SfdlSecurity& security, std::uint32_t beaconInd, std::int32_t beaconLostTimeout) NN_NOEXCEPT;
    nn::Result CancelJoin() NN_NOEXCEPT;
    nn::Result Disconnect(std::uint32_t mode, const nn::wlan::detail::SfdlDisconnectClient& client) NN_NOEXCEPT;
    nn::Result SetBeaconLostCount(std::uint32_t count) NN_NOEXCEPT;
    nn::Result GetSystemEvent(nn::sf::Out<nn::sf::NativeHandle> pOutSystemEventReadableHandle, std::uint32_t type) NN_NOEXCEPT;
    nn::Result GetConnectionStatus(nn::sf::Out<nn::wlan::detail::SfdlConnectionStatus> pOutStatus) NN_NOEXCEPT;
    nn::Result GetClientStatus(nn::sf::Out<nn::wlan::detail::SfdlClientStatusList> pOutStatusList) NN_NOEXCEPT;
    nn::Result GetBssIndicationEvent(nn::sf::Out<nn::sf::NativeHandle> pOutSystemEventReadableHandle) NN_NOEXCEPT;
    nn::Result GetBssIndicationInfo(nn::sf::Out<nn::wlan::detail::SfdlBssInfo> pOutInfo) NN_NOEXCEPT;
    nn::Result GetState(nn::sf::Out<std::uint32_t> pOutState) NN_NOEXCEPT;
    nn::Result GetAllowedChannels(const nn::sf::OutArray<std::int16_t>& pOutArray, nn::sf::Out<std::uint32_t> pOutCount) NN_NOEXCEPT;
    nn::Result AddIe(nn::sf::Out<std::uint32_t> pOutIeIndex, std::uint32_t managementFrameType, const nn::sf::InBuffer& pIeBody) NN_NOEXCEPT;
    nn::Result DeleteIe(std::uint32_t ieIndex) NN_NOEXCEPT;
    nn::Result PutFrameRaw(const nn::sf::InBuffer& pTxData) NN_NOEXCEPT;
    nn::Result CancelGetFrame(std::uint32_t rxId) NN_NOEXCEPT;
    nn::Result CreateRxEntry(nn::sf::Out<std::uint32_t> pOutRxId, const nn::sf::InArray<std::uint16_t>& pEthertypeArray, std::uint32_t capacity) NN_NOEXCEPT;
    nn::Result DeleteRxEntry(std::uint32_t rxId) NN_NOEXCEPT;
    nn::Result AddEthertypeToRxEntry(std::uint32_t rxId, std::uint16_t ethertype) NN_NOEXCEPT;
    nn::Result DeleteEthertypeFromRxEntry(nn::sf::Out<std::uint32_t> pOutRxId, std::uint16_t ethertype) NN_NOEXCEPT;
    nn::Result AddMatchingDataToRxEntry(std::uint32_t rxId, const nn::wlan::ReceivedDataMatchInfo& pMatchInfo) NN_NOEXCEPT;
    nn::Result RemoveMatchingDataFromRxEntry(std::uint32_t rxId, const nn::wlan::ReceivedDataMatchInfo& pMatchInfo) NN_NOEXCEPT;
    nn::Result GetScanResult(const nn::sf::OutBuffer& pOutScanBuffer, const nn::wlan::ScanIeMatchInfo& ieInfo) NN_NOEXCEPT;
    nn::Result PutActionFrameOneShot(nn::wlan::detail::SfdlMacAddress macAddr, const nn::sf::InBuffer& pTxData, std::uint32_t channel, std::uint32_t dwellTime) NN_NOEXCEPT;
    nn::Result SetActionFrameWithBeacon(const nn::sf::InBuffer& pTxData) NN_NOEXCEPT;
    nn::Result CancelActionFrameWithBeacon() NN_NOEXCEPT;
    nn::Result CreateRxEntryForActionFrame(nn::sf::Out<std::uint32_t> pOutRxId, const nn::sf::InArray<std::uint16_t>& pSubtypeArray, std::uint32_t capacity) NN_NOEXCEPT;
    nn::Result DeleteRxEntryForActionFrame(std::uint32_t rxId) NN_NOEXCEPT;
    nn::Result AddSubtypeToRxEntryForActionFrame(std::uint32_t rxId, std::uint32_t type) NN_NOEXCEPT;
    nn::Result DeleteSubtypeFromRxEntryForActionFrame(nn::sf::Out<std::uint32_t> pOutRxId, std::uint32_t type) NN_NOEXCEPT;
    nn::Result CancelGetActionFrame(std::uint32_t rxId) NN_NOEXCEPT;
    nn::Result GetRssi(nn::sf::Out<std::int32_t> pOutRssi) NN_NOEXCEPT;
    nn::Result SetMaxAssociationNumber(std::uint32_t maxNum) NN_NOEXCEPT;
    nn::Result OpenLcsMasterMode() NN_NOEXCEPT;
    nn::Result CloseLcsMasterMode() NN_NOEXCEPT;
    nn::Result OpenLcsClientMode() NN_NOEXCEPT;
    nn::Result CloseLcsClientMode() NN_NOEXCEPT;
    nn::Result GetChannelStats(const nn::sf::OutArray<nn::wlan::ChannelStats>& outStats, nn::sf::Out<std::uint32_t> pOutCount) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::wlan::detail::ILocalManager))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(OpenMasterMode)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(OpenMasterMode);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CloseMasterMode)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CloseMasterMode);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(OpenClientMode)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(OpenClientMode);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CloseClientMode)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CloseClientMode);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(OpenSpectatorMode)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(OpenSpectatorMode);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CloseSpectatorMode)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CloseSpectatorMode);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMacAddress, (::nn::sf::Out<::nn::wlan::detail::SfdlMacAddress> pOutMacAddr))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetMacAddress, (pOutMacAddr));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateBss, (const ::nn::wlan::detail::SfdlMasterBssParameters& bssParameters))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateBss, (bssParameters));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DestroyBss)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(DestroyBss);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartScan, (const ::nn::wlan::detail::SfdlScanParameters& scanParam))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(StartScan, (scanParam));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StopScan)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(StopScan);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Connect, (const ::nn::wlan::detail::SfdlSsid& ssid, ::nn::wlan::detail::SfdlMacAddress bssid, ::std::int16_t channel, const ::nn::wlan::detail::SfdlSecurity& security, bool autoKeepAlive, ::std::uint32_t beaconInd, ::std::int32_t beaconLostTimeout))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Connect, (ssid, bssid, channel, security, autoKeepAlive, beaconInd, beaconLostTimeout));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CancelConnect)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CancelConnect);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Join, (const ::nn::wlan::detail::SfdlSsid& ssid, ::nn::wlan::detail::SfdlMacAddress bssid, ::std::int16_t channel, const ::nn::wlan::detail::SfdlSecurity& security, ::std::uint32_t beaconInd, ::std::int32_t beaconLostTimeout))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Join, (ssid, bssid, channel, security, beaconInd, beaconLostTimeout));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CancelJoin)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CancelJoin);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Disconnect, (::std::uint32_t mode, const ::nn::wlan::detail::SfdlDisconnectClient& client))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(Disconnect, (mode, client));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetBeaconLostCount, (::std::uint32_t count))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetBeaconLostCount, (count));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutSystemEventReadableHandle, ::std::uint32_t type))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetSystemEvent, (pOutSystemEventReadableHandle, type));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetConnectionStatus, (::nn::sf::Out<::nn::wlan::detail::SfdlConnectionStatus> pOutStatus))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetConnectionStatus, (pOutStatus));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetClientStatus, (::nn::sf::Out<::nn::wlan::detail::SfdlClientStatusList> pOutStatusList))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetClientStatus, (pOutStatusList));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBssIndicationEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutSystemEventReadableHandle))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetBssIndicationEvent, (pOutSystemEventReadableHandle));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBssIndicationInfo, (::nn::sf::Out<::nn::wlan::detail::SfdlBssInfo> pOutInfo))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetBssIndicationInfo, (pOutInfo));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::std::uint32_t> pOutState))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetState, (pOutState));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAllowedChannels, (const ::nn::sf::OutArray<::std::int16_t>& pOutArray, ::nn::sf::Out<::std::uint32_t> pOutCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetAllowedChannels, (pOutArray, pOutCount));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddIe, (::nn::sf::Out<::std::uint32_t> pOutIeIndex, ::std::uint32_t managementFrameType, const ::nn::sf::InBuffer& pIeBody))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AddIe, (pOutIeIndex, managementFrameType, pIeBody));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteIe, (::std::uint32_t ieIndex))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteIe, (ieIndex));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PutFrameRaw, (const ::nn::sf::InBuffer& pTxData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PutFrameRaw, (pTxData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelGetFrame, (::std::uint32_t rxId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CancelGetFrame, (rxId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateRxEntry, (::nn::sf::Out<::std::uint32_t> pOutRxId, const ::nn::sf::InArray<::std::uint16_t>& pEthertypeArray, ::std::uint32_t capacity))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateRxEntry, (pOutRxId, pEthertypeArray, capacity));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteRxEntry, (::std::uint32_t rxId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteRxEntry, (rxId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddEthertypeToRxEntry, (::std::uint32_t rxId, ::std::uint16_t ethertype))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AddEthertypeToRxEntry, (rxId, ethertype));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteEthertypeFromRxEntry, (::nn::sf::Out<::std::uint32_t> pOutRxId, ::std::uint16_t ethertype))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteEthertypeFromRxEntry, (pOutRxId, ethertype));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddMatchingDataToRxEntry, (::std::uint32_t rxId, const ::nn::wlan::ReceivedDataMatchInfo& pMatchInfo))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AddMatchingDataToRxEntry, (rxId, pMatchInfo));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RemoveMatchingDataFromRxEntry, (::std::uint32_t rxId, const ::nn::wlan::ReceivedDataMatchInfo& pMatchInfo))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RemoveMatchingDataFromRxEntry, (rxId, pMatchInfo));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetScanResult, (const ::nn::sf::OutBuffer& pOutScanBuffer, const ::nn::wlan::ScanIeMatchInfo& ieInfo))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetScanResult, (pOutScanBuffer, ieInfo));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PutActionFrameOneShot, (::nn::wlan::detail::SfdlMacAddress macAddr, const ::nn::sf::InBuffer& pTxData, ::std::uint32_t channel, ::std::uint32_t dwellTime))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PutActionFrameOneShot, (macAddr, pTxData, channel, dwellTime));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetActionFrameWithBeacon, (const ::nn::sf::InBuffer& pTxData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetActionFrameWithBeacon, (pTxData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CancelActionFrameWithBeacon)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CancelActionFrameWithBeacon);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateRxEntryForActionFrame, (::nn::sf::Out<::std::uint32_t> pOutRxId, const ::nn::sf::InArray<::std::uint16_t>& pSubtypeArray, ::std::uint32_t capacity))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateRxEntryForActionFrame, (pOutRxId, pSubtypeArray, capacity));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteRxEntryForActionFrame, (::std::uint32_t rxId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteRxEntryForActionFrame, (rxId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddSubtypeToRxEntryForActionFrame, (::std::uint32_t rxId, ::std::uint32_t type))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AddSubtypeToRxEntryForActionFrame, (rxId, type));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteSubtypeFromRxEntryForActionFrame, (::nn::sf::Out<::std::uint32_t> pOutRxId, ::std::uint32_t type))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteSubtypeFromRxEntryForActionFrame, (pOutRxId, type));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelGetActionFrame, (::std::uint32_t rxId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CancelGetActionFrame, (rxId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRssi, (::nn::sf::Out<::std::int32_t> pOutRssi))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetRssi, (pOutRssi));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetMaxAssociationNumber, (::std::uint32_t maxNum))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetMaxAssociationNumber, (maxNum));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(OpenLcsMasterMode)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(OpenLcsMasterMode);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CloseLcsMasterMode)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CloseLcsMasterMode);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(OpenLcsClientMode)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(OpenLcsClientMode);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CloseLcsClientMode)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(CloseLcsClientMode);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetChannelStats, (const ::nn::sf::OutArray<::nn::wlan::ChannelStats>& outStats, ::nn::sf::Out<::std::uint32_t> pOutCount))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetChannelStats, (outStats, pOutCount));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::wlan::detail::ILocalManager>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::wlan::detail::ILocalManager))

    // nn::Result OpenMasterMode() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenMasterMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenMasterMode)

    // nn::Result CloseMasterMode() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CloseMasterMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CloseMasterMode)

    // nn::Result OpenClientMode() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenClientMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenClientMode)

    // nn::Result CloseClientMode() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CloseClientMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CloseClientMode)

    // nn::Result OpenSpectatorMode() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenSpectatorMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenSpectatorMode)

    // nn::Result CloseSpectatorMode() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CloseSpectatorMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CloseSpectatorMode)

    // nn::Result GetMacAddress(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetMacAddress)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutMacAddr, (::nn::wlan::detail::SfdlMacAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutMacAddr))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutMacAddr)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetMacAddress)

    // nn::Result CreateBss(const nn::wlan::detail::SfdlMasterBssParameters& bssParameters) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateBss)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bssParameters, (::nn::wlan::detail::SfdlMasterBssParameters), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (bssParameters))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(132)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bssParameters)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateBss)

    // nn::Result DestroyBss() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DestroyBss)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DestroyBss)

    // nn::Result StartScan(const nn::wlan::detail::SfdlScanParameters& scanParam) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StartScan)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(scanParam, 0, (const ::nn::wlan::detail::SfdlScanParameters&), 432, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (scanParam))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(scanParam)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StartScan)

    // nn::Result StopScan() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(StopScan)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(StopScan)

    // nn::Result Connect(const nn::wlan::detail::SfdlSsid& ssid, nn::wlan::detail::SfdlMacAddress bssid, std::int16_t channel, const nn::wlan::detail::SfdlSecurity& security, bool autoKeepAlive, std::uint32_t beaconInd, std::int32_t beaconLostTimeout) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Connect)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ssid, (::nn::wlan::detail::SfdlSsid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bssid, (::nn::wlan::detail::SfdlMacAddress), 33)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(autoKeepAlive, (bool), 39)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(channel, (::std::int16_t), 40)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(security, (::nn::wlan::detail::SfdlSecurity), 44)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(beaconInd, (::std::uint32_t), 124)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(beaconLostTimeout, (::std::int32_t), 128)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(7, (ssid, bssid, autoKeepAlive, channel, security, beaconInd, beaconLostTimeout))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(132)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ssid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bssid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(channel), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(security), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(autoKeepAlive), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(beaconInd), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(beaconLostTimeout)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Connect)

    // nn::Result CancelConnect() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelConnect)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelConnect)

    // nn::Result Join(const nn::wlan::detail::SfdlSsid& ssid, nn::wlan::detail::SfdlMacAddress bssid, std::int16_t channel, const nn::wlan::detail::SfdlSecurity& security, std::uint32_t beaconInd, std::int32_t beaconLostTimeout) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Join)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(13)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ssid, (::nn::wlan::detail::SfdlSsid), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(bssid, (::nn::wlan::detail::SfdlMacAddress), 33)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(channel, (::std::int16_t), 40)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(security, (::nn::wlan::detail::SfdlSecurity), 44)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(beaconInd, (::std::uint32_t), 124)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(beaconLostTimeout, (::std::int32_t), 128)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(6, (ssid, bssid, channel, security, beaconInd, beaconLostTimeout))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(132)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ssid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(bssid), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(channel), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(security), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(beaconInd), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(beaconLostTimeout)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Join)

    // nn::Result CancelJoin() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelJoin)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(14)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelJoin)

    // nn::Result Disconnect(std::uint32_t mode, const nn::wlan::detail::SfdlDisconnectClient& client) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(Disconnect)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(15)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(mode, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(client, (::nn::wlan::detail::SfdlDisconnectClient), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (mode, client))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(mode), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(client)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(Disconnect)

    // nn::Result SetBeaconLostCount(std::uint32_t count) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetBeaconLostCount)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(16)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(count, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (count))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(count)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetBeaconLostCount)

    // nn::Result GetSystemEvent(nn::sf::Out<nn::sf::NativeHandle> pOutSystemEventReadableHandle, std::uint32_t type) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetSystemEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(17)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pOutSystemEventReadableHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pOutSystemEventReadableHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (type))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSystemEventReadableHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetSystemEvent)

    // nn::Result GetConnectionStatus(nn::sf::Out<nn::wlan::detail::SfdlConnectionStatus> pOutStatus) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetConnectionStatus)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(18)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutStatus, (::nn::wlan::detail::SfdlConnectionStatus), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutStatus))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(60)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutStatus)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetConnectionStatus)

    // nn::Result GetClientStatus(nn::sf::Out<nn::wlan::detail::SfdlClientStatusList> pOutStatusList) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetClientStatus)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(19)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOutStatusList, 0, (::nn::sf::Out<::nn::wlan::detail::SfdlClientStatusList>), 232, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutStatusList))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutStatusList)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetClientStatus)

    // nn::Result GetBssIndicationEvent(nn::sf::Out<nn::sf::NativeHandle> pOutSystemEventReadableHandle) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBssIndicationEvent)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(20)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFO(pOutSystemEventReadableHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_NATIVE_HANDLE_INFOS_END(1, (pOutSystemEventReadableHandle))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSystemEventReadableHandle)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBssIndicationEvent)

    // nn::Result GetBssIndicationInfo(nn::sf::Out<nn::wlan::detail::SfdlBssInfo> pOutInfo) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetBssIndicationInfo)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(21)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pOutInfo, 0, (::nn::sf::Out<::nn::wlan::detail::SfdlBssInfo>), 1300, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutInfo))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutInfo)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetBssIndicationInfo)

    // nn::Result GetState(nn::sf::Out<std::uint32_t> pOutState) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetState)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(22)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutState, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutState))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutState)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetState)

    // nn::Result GetAllowedChannels(const nn::sf::OutArray<std::int16_t>& pOutArray, nn::sf::Out<std::uint32_t> pOutCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetAllowedChannels)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(23)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutArray, 0, (const ::nn::sf::OutArray<::std::int16_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutArray), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetAllowedChannels)

    // nn::Result AddIe(nn::sf::Out<std::uint32_t> pOutIeIndex, std::uint32_t managementFrameType, const nn::sf::InBuffer& pIeBody) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AddIe)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(24)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pIeBody, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pIeBody))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(managementFrameType, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (managementFrameType))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutIeIndex, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutIeIndex))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutIeIndex), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(managementFrameType), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pIeBody)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AddIe)

    // nn::Result DeleteIe(std::uint32_t ieIndex) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteIe)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(25)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ieIndex, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (ieIndex))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ieIndex)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteIe)

    // nn::Result PutFrameRaw(const nn::sf::InBuffer& pTxData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PutFrameRaw)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(26)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pTxData, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pTxData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pTxData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PutFrameRaw)

    // nn::Result CancelGetFrame(std::uint32_t rxId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelGetFrame)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(27)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rxId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rxId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rxId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelGetFrame)

    // nn::Result CreateRxEntry(nn::sf::Out<std::uint32_t> pOutRxId, const nn::sf::InArray<std::uint16_t>& pEthertypeArray, std::uint32_t capacity) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateRxEntry)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(28)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pEthertypeArray, 0, (const ::nn::sf::InArray<::std::uint16_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pEthertypeArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(capacity, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (capacity))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRxId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutRxId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRxId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pEthertypeArray), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(capacity)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateRxEntry)

    // nn::Result DeleteRxEntry(std::uint32_t rxId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteRxEntry)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(29)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rxId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rxId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rxId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteRxEntry)

    // nn::Result AddEthertypeToRxEntry(std::uint32_t rxId, std::uint16_t ethertype) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AddEthertypeToRxEntry)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(30)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ethertype, (::std::uint16_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rxId, (::std::uint32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (ethertype, rxId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rxId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ethertype)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AddEthertypeToRxEntry)

    // nn::Result DeleteEthertypeFromRxEntry(nn::sf::Out<std::uint32_t> pOutRxId, std::uint16_t ethertype) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteEthertypeFromRxEntry)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(31)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ethertype, (::std::uint16_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (ethertype))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRxId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutRxId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRxId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ethertype)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteEthertypeFromRxEntry)

    // nn::Result AddMatchingDataToRxEntry(std::uint32_t rxId, const nn::wlan::ReceivedDataMatchInfo& pMatchInfo) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AddMatchingDataToRxEntry)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(32)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pMatchInfo, 0, (const ::nn::wlan::ReceivedDataMatchInfo&), 21, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pMatchInfo))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rxId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rxId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rxId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pMatchInfo)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AddMatchingDataToRxEntry)

    // nn::Result RemoveMatchingDataFromRxEntry(std::uint32_t rxId, const nn::wlan::ReceivedDataMatchInfo& pMatchInfo) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RemoveMatchingDataFromRxEntry)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(33)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(pMatchInfo, 0, (const ::nn::wlan::ReceivedDataMatchInfo&), 21, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pMatchInfo))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rxId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rxId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rxId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pMatchInfo)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RemoveMatchingDataFromRxEntry)

    // nn::Result GetScanResult(const nn::sf::OutBuffer& pOutScanBuffer, const nn::wlan::ScanIeMatchInfo& ieInfo) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetScanResult)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(34)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_FIXED_SIZE_BUFFER_INFO(ieInfo, 0, (const ::nn::wlan::ScanIeMatchInfo&), 256, NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutScanBuffer, 1, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(2, (ieInfo, pOutScanBuffer))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutScanBuffer), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ieInfo)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetScanResult)

    // nn::Result PutActionFrameOneShot(nn::wlan::detail::SfdlMacAddress macAddr, const nn::sf::InBuffer& pTxData, std::uint32_t channel, std::uint32_t dwellTime) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PutActionFrameOneShot)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(35)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pTxData, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pTxData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(macAddr, (::nn::wlan::detail::SfdlMacAddress), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(channel, (::std::uint32_t), 8)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(dwellTime, (::std::uint32_t), 12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(3, (macAddr, channel, dwellTime))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(16)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(macAddr), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pTxData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(channel), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(dwellTime)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PutActionFrameOneShot)

    // nn::Result SetActionFrameWithBeacon(const nn::sf::InBuffer& pTxData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetActionFrameWithBeacon)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(36)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pTxData, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pTxData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pTxData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetActionFrameWithBeacon)

    // nn::Result CancelActionFrameWithBeacon() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelActionFrameWithBeacon)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(37)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelActionFrameWithBeacon)

    // nn::Result CreateRxEntryForActionFrame(nn::sf::Out<std::uint32_t> pOutRxId, const nn::sf::InArray<std::uint16_t>& pSubtypeArray, std::uint32_t capacity) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateRxEntryForActionFrame)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(38)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pSubtypeArray, 0, (const ::nn::sf::InArray<::std::uint16_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pSubtypeArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(capacity, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (capacity))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRxId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutRxId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRxId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pSubtypeArray), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(capacity)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateRxEntryForActionFrame)

    // nn::Result DeleteRxEntryForActionFrame(std::uint32_t rxId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteRxEntryForActionFrame)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(39)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rxId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rxId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rxId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteRxEntryForActionFrame)

    // nn::Result AddSubtypeToRxEntryForActionFrame(std::uint32_t rxId, std::uint32_t type) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AddSubtypeToRxEntryForActionFrame)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(40)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rxId, (::std::uint32_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::std::uint32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (rxId, type))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rxId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AddSubtypeToRxEntryForActionFrame)

    // nn::Result DeleteSubtypeFromRxEntryForActionFrame(nn::sf::Out<std::uint32_t> pOutRxId, std::uint32_t type) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteSubtypeFromRxEntryForActionFrame)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(41)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(type, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (type))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRxId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutRxId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRxId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(type)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteSubtypeFromRxEntryForActionFrame)

    // nn::Result CancelGetActionFrame(std::uint32_t rxId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelGetActionFrame)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(42)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rxId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rxId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rxId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelGetActionFrame)

    // nn::Result GetRssi(nn::sf::Out<std::int32_t> pOutRssi) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetRssi)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(43)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRssi, (::std::int32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutRssi))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRssi)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetRssi)

    // nn::Result SetMaxAssociationNumber(std::uint32_t maxNum) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetMaxAssociationNumber)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(44)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(maxNum, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (maxNum))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(maxNum)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetMaxAssociationNumber)

    // nn::Result OpenLcsMasterMode() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenLcsMasterMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(45)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenLcsMasterMode)

    // nn::Result CloseLcsMasterMode() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CloseLcsMasterMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(46)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CloseLcsMasterMode)

    // nn::Result OpenLcsClientMode() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(OpenLcsClientMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(47)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(OpenLcsClientMode)

    // nn::Result CloseLcsClientMode() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CloseLcsClientMode)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(48)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CloseLcsClientMode)

    // nn::Result GetChannelStats(const nn::sf::OutArray<nn::wlan::ChannelStats>& outStats, nn::sf::Out<std::uint32_t> pOutCount) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetChannelStats)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(49)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(outStats, 0, (const ::nn::sf::OutArray<::nn::wlan::ChannelStats>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (outStats))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutCount, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutCount))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(outStats), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutCount)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetChannelStats)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::wlan::detail::SfdlMasterBssParameters), 132, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::wlan::detail::SfdlScanParameters), 432, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::wlan::detail::SfdlSsid), 33, 1)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::wlan::detail::SfdlSecurity), 80, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::wlan::detail::SfdlDisconnectClient), 12, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::wlan::detail::SfdlConnectionStatus), 60, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::wlan::detail::SfdlClientStatusList), 232, 8)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::wlan::ReceivedDataMatchInfo), 21, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::wlan::ScanIeMatchInfo), 256, 4)
    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::wlan::ChannelStats), 4, 4)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::wlan::detail::ILocalManager, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::wlan::detail::ILocalManager))

    // nn::Result OpenMasterMode() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(OpenMasterMode)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenMasterMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenMasterMode)
    }

    // nn::Result CloseMasterMode() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CloseMasterMode)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CloseMasterMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CloseMasterMode)
    }

    // nn::Result OpenClientMode() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(OpenClientMode)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenClientMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenClientMode)
    }

    // nn::Result CloseClientMode() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CloseClientMode)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CloseClientMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CloseClientMode)
    }

    // nn::Result OpenSpectatorMode() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(OpenSpectatorMode)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenSpectatorMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenSpectatorMode)
    }

    // nn::Result CloseSpectatorMode() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CloseSpectatorMode)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CloseSpectatorMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CloseSpectatorMode)
    }

    // nn::Result GetMacAddress(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMacAddress, (::nn::sf::Out<::nn::wlan::detail::SfdlMacAddress> pOutMacAddr))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetMacAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutMacAddr)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetMacAddress)
    }

    // nn::Result CreateBss(const nn::wlan::detail::SfdlMasterBssParameters& bssParameters) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateBss, (const ::nn::wlan::detail::SfdlMasterBssParameters& bssParameters))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateBss)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bssParameters)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateBss)
    }

    // nn::Result DestroyBss() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(DestroyBss)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DestroyBss)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DestroyBss)
    }

    // nn::Result StartScan(const nn::wlan::detail::SfdlScanParameters& scanParam) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(StartScan, (const ::nn::wlan::detail::SfdlScanParameters& scanParam))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StartScan)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(scanParam)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StartScan)
    }

    // nn::Result StopScan() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(StopScan)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(StopScan)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(StopScan)
    }

    // nn::Result Connect(const nn::wlan::detail::SfdlSsid& ssid, nn::wlan::detail::SfdlMacAddress bssid, std::int16_t channel, const nn::wlan::detail::SfdlSecurity& security, bool autoKeepAlive, std::uint32_t beaconInd, std::int32_t beaconLostTimeout) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Connect, (const ::nn::wlan::detail::SfdlSsid& ssid, ::nn::wlan::detail::SfdlMacAddress bssid, ::std::int16_t channel, const ::nn::wlan::detail::SfdlSecurity& security, bool autoKeepAlive, ::std::uint32_t beaconInd, ::std::int32_t beaconLostTimeout))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Connect)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ssid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bssid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(channel)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(security)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(autoKeepAlive)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(beaconInd)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(beaconLostTimeout)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Connect)
    }

    // nn::Result CancelConnect() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CancelConnect)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelConnect)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelConnect)
    }

    // nn::Result Join(const nn::wlan::detail::SfdlSsid& ssid, nn::wlan::detail::SfdlMacAddress bssid, std::int16_t channel, const nn::wlan::detail::SfdlSecurity& security, std::uint32_t beaconInd, std::int32_t beaconLostTimeout) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Join, (const ::nn::wlan::detail::SfdlSsid& ssid, ::nn::wlan::detail::SfdlMacAddress bssid, ::std::int16_t channel, const ::nn::wlan::detail::SfdlSecurity& security, ::std::uint32_t beaconInd, ::std::int32_t beaconLostTimeout))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Join)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ssid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(bssid)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(channel)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(security)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(beaconInd)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(beaconLostTimeout)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Join)
    }

    // nn::Result CancelJoin() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CancelJoin)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelJoin)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelJoin)
    }

    // nn::Result Disconnect(std::uint32_t mode, const nn::wlan::detail::SfdlDisconnectClient& client) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(Disconnect, (::std::uint32_t mode, const ::nn::wlan::detail::SfdlDisconnectClient& client))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(Disconnect)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(mode)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(client)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(Disconnect)
    }

    // nn::Result SetBeaconLostCount(std::uint32_t count) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetBeaconLostCount, (::std::uint32_t count))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetBeaconLostCount)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(count)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetBeaconLostCount)
    }

    // nn::Result GetSystemEvent(nn::sf::Out<nn::sf::NativeHandle> pOutSystemEventReadableHandle, std::uint32_t type) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetSystemEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutSystemEventReadableHandle, ::std::uint32_t type))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetSystemEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSystemEventReadableHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetSystemEvent)
    }

    // nn::Result GetConnectionStatus(nn::sf::Out<nn::wlan::detail::SfdlConnectionStatus> pOutStatus) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetConnectionStatus, (::nn::sf::Out<::nn::wlan::detail::SfdlConnectionStatus> pOutStatus))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetConnectionStatus)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutStatus)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetConnectionStatus)
    }

    // nn::Result GetClientStatus(nn::sf::Out<nn::wlan::detail::SfdlClientStatusList> pOutStatusList) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetClientStatus, (::nn::sf::Out<::nn::wlan::detail::SfdlClientStatusList> pOutStatusList))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetClientStatus)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutStatusList)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetClientStatus)
    }

    // nn::Result GetBssIndicationEvent(nn::sf::Out<nn::sf::NativeHandle> pOutSystemEventReadableHandle) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBssIndicationEvent, (::nn::sf::Out<::nn::sf::NativeHandle> pOutSystemEventReadableHandle))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBssIndicationEvent)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSystemEventReadableHandle)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBssIndicationEvent)
    }

    // nn::Result GetBssIndicationInfo(nn::sf::Out<nn::wlan::detail::SfdlBssInfo> pOutInfo) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetBssIndicationInfo, (::nn::sf::Out<::nn::wlan::detail::SfdlBssInfo> pOutInfo))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetBssIndicationInfo)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutInfo)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetBssIndicationInfo)
    }

    // nn::Result GetState(nn::sf::Out<std::uint32_t> pOutState) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetState, (::nn::sf::Out<::std::uint32_t> pOutState))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetState)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutState)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetState)
    }

    // nn::Result GetAllowedChannels(const nn::sf::OutArray<std::int16_t>& pOutArray, nn::sf::Out<std::uint32_t> pOutCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetAllowedChannels, (const ::nn::sf::OutArray<::std::int16_t>& pOutArray, ::nn::sf::Out<::std::uint32_t> pOutCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetAllowedChannels)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutArray)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetAllowedChannels)
    }

    // nn::Result AddIe(nn::sf::Out<std::uint32_t> pOutIeIndex, std::uint32_t managementFrameType, const nn::sf::InBuffer& pIeBody) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddIe, (::nn::sf::Out<::std::uint32_t> pOutIeIndex, ::std::uint32_t managementFrameType, const ::nn::sf::InBuffer& pIeBody))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AddIe)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutIeIndex)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(managementFrameType)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pIeBody)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AddIe)
    }

    // nn::Result DeleteIe(std::uint32_t ieIndex) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteIe, (::std::uint32_t ieIndex))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteIe)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ieIndex)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteIe)
    }

    // nn::Result PutFrameRaw(const nn::sf::InBuffer& pTxData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PutFrameRaw, (const ::nn::sf::InBuffer& pTxData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PutFrameRaw)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pTxData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PutFrameRaw)
    }

    // nn::Result CancelGetFrame(std::uint32_t rxId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelGetFrame, (::std::uint32_t rxId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelGetFrame)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rxId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelGetFrame)
    }

    // nn::Result CreateRxEntry(nn::sf::Out<std::uint32_t> pOutRxId, const nn::sf::InArray<std::uint16_t>& pEthertypeArray, std::uint32_t capacity) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateRxEntry, (::nn::sf::Out<::std::uint32_t> pOutRxId, const ::nn::sf::InArray<::std::uint16_t>& pEthertypeArray, ::std::uint32_t capacity))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateRxEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRxId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pEthertypeArray)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(capacity)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateRxEntry)
    }

    // nn::Result DeleteRxEntry(std::uint32_t rxId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteRxEntry, (::std::uint32_t rxId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteRxEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rxId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteRxEntry)
    }

    // nn::Result AddEthertypeToRxEntry(std::uint32_t rxId, std::uint16_t ethertype) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddEthertypeToRxEntry, (::std::uint32_t rxId, ::std::uint16_t ethertype))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AddEthertypeToRxEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rxId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ethertype)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AddEthertypeToRxEntry)
    }

    // nn::Result DeleteEthertypeFromRxEntry(nn::sf::Out<std::uint32_t> pOutRxId, std::uint16_t ethertype) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteEthertypeFromRxEntry, (::nn::sf::Out<::std::uint32_t> pOutRxId, ::std::uint16_t ethertype))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteEthertypeFromRxEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRxId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ethertype)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteEthertypeFromRxEntry)
    }

    // nn::Result AddMatchingDataToRxEntry(std::uint32_t rxId, const nn::wlan::ReceivedDataMatchInfo& pMatchInfo) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddMatchingDataToRxEntry, (::std::uint32_t rxId, const ::nn::wlan::ReceivedDataMatchInfo& pMatchInfo))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AddMatchingDataToRxEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rxId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pMatchInfo)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AddMatchingDataToRxEntry)
    }

    // nn::Result RemoveMatchingDataFromRxEntry(std::uint32_t rxId, const nn::wlan::ReceivedDataMatchInfo& pMatchInfo) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RemoveMatchingDataFromRxEntry, (::std::uint32_t rxId, const ::nn::wlan::ReceivedDataMatchInfo& pMatchInfo))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RemoveMatchingDataFromRxEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rxId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pMatchInfo)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RemoveMatchingDataFromRxEntry)
    }

    // nn::Result GetScanResult(const nn::sf::OutBuffer& pOutScanBuffer, const nn::wlan::ScanIeMatchInfo& ieInfo) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetScanResult, (const ::nn::sf::OutBuffer& pOutScanBuffer, const ::nn::wlan::ScanIeMatchInfo& ieInfo))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetScanResult)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutScanBuffer)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ieInfo)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetScanResult)
    }

    // nn::Result PutActionFrameOneShot(nn::wlan::detail::SfdlMacAddress macAddr, const nn::sf::InBuffer& pTxData, std::uint32_t channel, std::uint32_t dwellTime) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PutActionFrameOneShot, (::nn::wlan::detail::SfdlMacAddress macAddr, const ::nn::sf::InBuffer& pTxData, ::std::uint32_t channel, ::std::uint32_t dwellTime))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PutActionFrameOneShot)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(macAddr)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pTxData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(channel)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(dwellTime)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PutActionFrameOneShot)
    }

    // nn::Result SetActionFrameWithBeacon(const nn::sf::InBuffer& pTxData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetActionFrameWithBeacon, (const ::nn::sf::InBuffer& pTxData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetActionFrameWithBeacon)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pTxData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetActionFrameWithBeacon)
    }

    // nn::Result CancelActionFrameWithBeacon() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CancelActionFrameWithBeacon)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelActionFrameWithBeacon)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelActionFrameWithBeacon)
    }

    // nn::Result CreateRxEntryForActionFrame(nn::sf::Out<std::uint32_t> pOutRxId, const nn::sf::InArray<std::uint16_t>& pSubtypeArray, std::uint32_t capacity) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateRxEntryForActionFrame, (::nn::sf::Out<::std::uint32_t> pOutRxId, const ::nn::sf::InArray<::std::uint16_t>& pSubtypeArray, ::std::uint32_t capacity))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateRxEntryForActionFrame)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRxId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pSubtypeArray)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(capacity)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateRxEntryForActionFrame)
    }

    // nn::Result DeleteRxEntryForActionFrame(std::uint32_t rxId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteRxEntryForActionFrame, (::std::uint32_t rxId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteRxEntryForActionFrame)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rxId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteRxEntryForActionFrame)
    }

    // nn::Result AddSubtypeToRxEntryForActionFrame(std::uint32_t rxId, std::uint32_t type) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddSubtypeToRxEntryForActionFrame, (::std::uint32_t rxId, ::std::uint32_t type))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AddSubtypeToRxEntryForActionFrame)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rxId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AddSubtypeToRxEntryForActionFrame)
    }

    // nn::Result DeleteSubtypeFromRxEntryForActionFrame(nn::sf::Out<std::uint32_t> pOutRxId, std::uint32_t type) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteSubtypeFromRxEntryForActionFrame, (::nn::sf::Out<::std::uint32_t> pOutRxId, ::std::uint32_t type))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteSubtypeFromRxEntryForActionFrame)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRxId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(type)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteSubtypeFromRxEntryForActionFrame)
    }

    // nn::Result CancelGetActionFrame(std::uint32_t rxId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelGetActionFrame, (::std::uint32_t rxId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelGetActionFrame)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rxId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelGetActionFrame)
    }

    // nn::Result GetRssi(nn::sf::Out<std::int32_t> pOutRssi) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetRssi, (::nn::sf::Out<::std::int32_t> pOutRssi))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetRssi)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRssi)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetRssi)
    }

    // nn::Result SetMaxAssociationNumber(std::uint32_t maxNum) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetMaxAssociationNumber, (::std::uint32_t maxNum))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetMaxAssociationNumber)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(maxNum)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetMaxAssociationNumber)
    }

    // nn::Result OpenLcsMasterMode() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(OpenLcsMasterMode)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenLcsMasterMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenLcsMasterMode)
    }

    // nn::Result CloseLcsMasterMode() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CloseLcsMasterMode)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CloseLcsMasterMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CloseLcsMasterMode)
    }

    // nn::Result OpenLcsClientMode() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(OpenLcsClientMode)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(OpenLcsClientMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(OpenLcsClientMode)
    }

    // nn::Result CloseLcsClientMode() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(CloseLcsClientMode)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CloseLcsClientMode)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CloseLcsClientMode)
    }

    // nn::Result GetChannelStats(const nn::sf::OutArray<nn::wlan::ChannelStats>& outStats, nn::sf::Out<std::uint32_t> pOutCount) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetChannelStats, (const ::nn::sf::OutArray<::nn::wlan::ChannelStats>& outStats, ::nn::sf::Out<::std::uint32_t> pOutCount))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetChannelStats)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(outStats)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutCount)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetChannelStats)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::wlan::detail::ILocalManager>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::wlan::detail::ILocalManager))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenMasterMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenMasterMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CloseMasterMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CloseMasterMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenClientMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenClientMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CloseClientMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CloseClientMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenSpectatorMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenSpectatorMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CloseSpectatorMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CloseSpectatorMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetMacAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetMacAddress)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutMacAddr)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateBss)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateBss)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bssParameters)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DestroyBss)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DestroyBss)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StartScan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(scanParam)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StartScan)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(scanParam)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(StopScan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(StopScan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Connect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Connect)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ssid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bssid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(channel),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(security),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(autoKeepAlive),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(beaconInd),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(beaconLostTimeout)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelConnect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelConnect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Join)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Join)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ssid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(bssid),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(channel),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(security),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(beaconInd),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(beaconLostTimeout)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelJoin)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelJoin)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(Disconnect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(Disconnect)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(mode),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(client)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetBeaconLostCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetBeaconLostCount)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(count)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetSystemEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pOutSystemEventReadableHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetSystemEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pOutSystemEventReadableHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetConnectionStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetConnectionStatus)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetClientStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutStatusList)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetClientStatus)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutStatusList)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBssIndicationEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLE(pOutSystemEventReadableHandle)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_OUT_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBssIndicationEvent)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_NATIVE_HANDLE(pOutSystemEventReadableHandle)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetBssIndicationInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetBssIndicationInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetState)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetAllowedChannels)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetAllowedChannels)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutArray),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AddIe)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pIeBody)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AddIe)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutIeIndex),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(managementFrameType),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pIeBody)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteIe)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteIe)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ieIndex)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PutFrameRaw)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pTxData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PutFrameRaw)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pTxData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelGetFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelGetFrame)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rxId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateRxEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pEthertypeArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateRxEntry)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRxId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pEthertypeArray),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(capacity)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteRxEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteRxEntry)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rxId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AddEthertypeToRxEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AddEthertypeToRxEntry)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rxId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ethertype)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteEthertypeFromRxEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteEthertypeFromRxEntry)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRxId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ethertype)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AddMatchingDataToRxEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pMatchInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AddMatchingDataToRxEntry)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rxId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pMatchInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RemoveMatchingDataFromRxEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pMatchInfo)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RemoveMatchingDataFromRxEntry)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rxId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pMatchInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetScanResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(ieInfo)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutScanBuffer)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetScanResult)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutScanBuffer),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(ieInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PutActionFrameOneShot)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pTxData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PutActionFrameOneShot)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(macAddr),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pTxData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(channel),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(dwellTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetActionFrameWithBeacon)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pTxData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetActionFrameWithBeacon)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pTxData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelActionFrameWithBeacon)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelActionFrameWithBeacon)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateRxEntryForActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pSubtypeArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateRxEntryForActionFrame)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRxId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pSubtypeArray),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(capacity)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteRxEntryForActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteRxEntryForActionFrame)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rxId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AddSubtypeToRxEntryForActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AddSubtypeToRxEntryForActionFrame)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rxId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteSubtypeFromRxEntryForActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteSubtypeFromRxEntryForActionFrame)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRxId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(type)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelGetActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelGetActionFrame)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rxId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetRssi)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetRssi)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRssi)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetMaxAssociationNumber)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetMaxAssociationNumber)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(maxNum)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenLcsMasterMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenLcsMasterMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CloseLcsMasterMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CloseLcsMasterMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(OpenLcsClientMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(OpenLcsClientMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CloseLcsClientMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CloseLcsClientMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetChannelStats)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(outStats)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetChannelStats)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(outStats),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenMasterMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CloseMasterMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenClientMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CloseClientMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenSpectatorMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CloseSpectatorMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetMacAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateBss)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DestroyBss)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StartScan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(StopScan)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Connect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelConnect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Join)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelJoin)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(Disconnect)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetBeaconLostCount)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetSystemEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetConnectionStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetClientStatus)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBssIndicationEvent)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetBssIndicationInfo)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetState)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetAllowedChannels)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AddIe)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteIe)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PutFrameRaw)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelGetFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateRxEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteRxEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AddEthertypeToRxEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteEthertypeFromRxEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AddMatchingDataToRxEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RemoveMatchingDataFromRxEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetScanResult)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PutActionFrameOneShot)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetActionFrameWithBeacon)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelActionFrameWithBeacon)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateRxEntryForActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteRxEntryForActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AddSubtypeToRxEntryForActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteSubtypeFromRxEntryForActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelGetActionFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetRssi)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetMaxAssociationNumber)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenLcsMasterMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CloseLcsMasterMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(OpenLcsClientMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CloseLcsClientMode)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetChannelStats)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::wlan::detail::ILocalManager))

namespace nn { namespace wlan { namespace detail { // NOLINT(whitespace/braces)

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ISocketGetFrame, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ISocketGetFrame)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetFrameRaw, (const ::nn::sf::OutBuffer& pOutRxData, ::nn::sf::Out<::std::uint32_t> pOutSize, ::std::uint32_t rxId))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ISocketGetFrame)

        ::nn::Result GetFrameRaw(const ::nn::sf::OutBuffer& pOutRxData, ::nn::sf::Out<::std::uint32_t> pOutSize, ::std::uint32_t rxId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetFrameRaw, (pOutRxData, pOutSize, rxId));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ISocketGetFrame
    {
    public:
        nn::Result GetFrameRaw(const nn::sf::OutBuffer& pOutRxData, nn::sf::Out<std::uint32_t> pOutSize, std::uint32_t rxId) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result GetFrameRaw(const nn::sf::OutBuffer& pOutRxData, nn::sf::Out<std::uint32_t> pOutSize, std::uint32_t rxId) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::wlan::detail::ISocketGetFrame))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFrameRaw, (const ::nn::sf::OutBuffer& pOutRxData, ::nn::sf::Out<::std::uint32_t> pOutSize, ::std::uint32_t rxId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetFrameRaw, (pOutRxData, pOutSize, rxId));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::wlan::detail::ISocketGetFrame>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::wlan::detail::ISocketGetFrame))

    // nn::Result GetFrameRaw(const nn::sf::OutBuffer& pOutRxData, nn::sf::Out<std::uint32_t> pOutSize, std::uint32_t rxId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetFrameRaw)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pOutRxData, 0, (const ::nn::sf::OutBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_OUT | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pOutRxData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rxId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rxId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutSize, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRxData), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rxId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetFrameRaw)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::wlan::detail::ISocketGetFrame, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::wlan::detail::ISocketGetFrame))

    // nn::Result GetFrameRaw(const nn::sf::OutBuffer& pOutRxData, nn::sf::Out<std::uint32_t> pOutSize, std::uint32_t rxId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetFrameRaw, (const ::nn::sf::OutBuffer& pOutRxData, ::nn::sf::Out<::std::uint32_t> pOutSize, ::std::uint32_t rxId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetFrameRaw)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRxData)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rxId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetFrameRaw)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::wlan::detail::ISocketGetFrame>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::wlan::detail::ISocketGetFrame))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetFrameRaw)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pOutRxData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetFrameRaw)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pOutRxData),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rxId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetFrameRaw)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::wlan::detail::ISocketGetFrame))

namespace nn { namespace wlan { namespace detail { // NOLINT(whitespace/braces)

struct SfdlMulticastFilterInfo
{
    std::uint8_t count;
    nn::wlan::detail::SfdlMacAddress address[8];
};

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE(ISocketManager, (::nn::sf::IServiceObject))

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_SYNC_METHOD(ISocketManager)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(PutFrameRaw, (const ::nn::sf::InBuffer& pTxData))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CancelGetFrame, (::std::uint32_t rxId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(CreateRxEntry, (::nn::sf::Out<::std::uint32_t> pOutRxId, const ::nn::sf::InArray<::std::uint16_t>& pEthertypeArray, ::std::uint32_t capacity))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteRxEntry, (::std::uint32_t rxId))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(AddEthertypeToRxEntry, (::std::uint32_t rxId, ::std::uint16_t ethertype))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(DeleteEthertypeFromRxEntry, (::nn::sf::Out<::std::uint32_t> pOutRxId, ::std::uint16_t ethertype))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetMacAddress, (::nn::sf::Out<::nn::wlan::detail::SfdlMacAddress> pOutMacAddr))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SwitchTsfTimerFunction, (bool enable))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(GetDeltaTimeBetweenSystemAndTsf, (::nn::sf::Out<::std::int64_t> pOutDeltaTime))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(RegisterSharedMemory, (::nn::sf::NativeHandle&& memHandle, ::std::uint32_t memSize, ::nn::sf::NativeHandle&& RxEventHandle, ::nn::sf::NativeHandle&& TxEventHandle, ::nn::sf::NativeHandle&& RxCbufEventHandle, ::nn::sf::NativeHandle&& TxCbufEventHandlw))
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(UnregisterSharedMemory)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_0(EnableSharedMemory)
        NN_SF_DETAIL_INTERNAL_INTERFACE_DEFINE_SYNC_METHOD_RESULT_N(SetMulticastFilter, (const ::nn::wlan::detail::SfdlMulticastFilterInfo& info))
    NN_SF_DETAIL_SERVICE_INTERFACE_END_SYNC_METHOD

    NN_SF_DETAIL_SERVICE_INTERFACE_BEGIN_ACCESSOR(ISocketManager)

        ::nn::Result PutFrameRaw(const ::nn::sf::InBuffer& pTxData) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(PutFrameRaw, (pTxData));
        }

        ::nn::Result CancelGetFrame(::std::uint32_t rxId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CancelGetFrame, (rxId));
        }

        ::nn::Result CreateRxEntry(::nn::sf::Out<::std::uint32_t> pOutRxId, const ::nn::sf::InArray<::std::uint16_t>& pEthertypeArray, ::std::uint32_t capacity) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(CreateRxEntry, (pOutRxId, pEthertypeArray, capacity));
        }

        ::nn::Result DeleteRxEntry(::std::uint32_t rxId) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteRxEntry, (rxId));
        }

        ::nn::Result AddEthertypeToRxEntry(::std::uint32_t rxId, ::std::uint16_t ethertype) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(AddEthertypeToRxEntry, (rxId, ethertype));
        }

        ::nn::Result DeleteEthertypeFromRxEntry(::nn::sf::Out<::std::uint32_t> pOutRxId, ::std::uint16_t ethertype) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(DeleteEthertypeFromRxEntry, (pOutRxId, ethertype));
        }

        ::nn::Result GetMacAddress(::nn::sf::Out<::nn::wlan::detail::SfdlMacAddress> pOutMacAddr) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetMacAddress, (pOutMacAddr));
        }

        ::nn::Result SwitchTsfTimerFunction(bool enable) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SwitchTsfTimerFunction, (enable));
        }

        ::nn::Result GetDeltaTimeBetweenSystemAndTsf(::nn::sf::Out<::std::int64_t> pOutDeltaTime) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(GetDeltaTimeBetweenSystemAndTsf, (pOutDeltaTime));
        }

        ::nn::Result RegisterSharedMemory(::nn::sf::NativeHandle&& memHandle, ::std::uint32_t memSize, ::nn::sf::NativeHandle&& RxEventHandle, ::nn::sf::NativeHandle&& TxEventHandle, ::nn::sf::NativeHandle&& RxCbufEventHandle, ::nn::sf::NativeHandle&& TxCbufEventHandlw) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(RegisterSharedMemory, (::std::move(memHandle), memSize, ::std::move(RxEventHandle), ::std::move(TxEventHandle), ::std::move(RxCbufEventHandle), ::std::move(TxCbufEventHandlw)));
        }

        ::nn::Result UnregisterSharedMemory() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(UnregisterSharedMemory);
        }

        ::nn::Result EnableSharedMemory() NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_0(EnableSharedMemory);
        }

        ::nn::Result SetMulticastFilter(const ::nn::wlan::detail::SfdlMulticastFilterInfo& info) NN_NOEXCEPT
        {
            NN_SF_DETAIL_RETURN_INTERNAL_SYNC_METHOD_RESULT_N(SetMulticastFilter, (info));
        }

    NN_SF_DETAIL_SERVICE_INTERFACE_END_ACCESSOR

NN_SF_DETAIL_DEFINE_SERVICE_INTERFACE_END

#if 0
    class ISocketManager
    {
    public:
        nn::Result PutFrameRaw(const nn::sf::InBuffer& pTxData) NN_NOEXCEPT;
        nn::Result CancelGetFrame(std::uint32_t rxId) NN_NOEXCEPT;
        nn::Result CreateRxEntry(nn::sf::Out<std::uint32_t> pOutRxId, const nn::sf::InArray<std::uint16_t>& pEthertypeArray, std::uint32_t capacity) NN_NOEXCEPT;
        nn::Result DeleteRxEntry(std::uint32_t rxId) NN_NOEXCEPT;
        nn::Result AddEthertypeToRxEntry(std::uint32_t rxId, std::uint16_t ethertype) NN_NOEXCEPT;
        nn::Result DeleteEthertypeFromRxEntry(nn::sf::Out<std::uint32_t> pOutRxId, std::uint16_t ethertype) NN_NOEXCEPT;
        nn::Result GetMacAddress(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr) NN_NOEXCEPT;
        nn::Result SwitchTsfTimerFunction(bool enable) NN_NOEXCEPT;
        nn::Result GetDeltaTimeBetweenSystemAndTsf(nn::sf::Out<std::int64_t> pOutDeltaTime) NN_NOEXCEPT;
        nn::Result RegisterSharedMemory(nn::sf::NativeHandle&& memHandle, std::uint32_t memSize, nn::sf::NativeHandle&& RxEventHandle, nn::sf::NativeHandle&& TxEventHandle, nn::sf::NativeHandle&& RxCbufEventHandle, nn::sf::NativeHandle&& TxCbufEventHandlw) NN_NOEXCEPT;
        nn::Result UnregisterSharedMemory() NN_NOEXCEPT;
        nn::Result EnableSharedMemory() NN_NOEXCEPT;
        nn::Result SetMulticastFilter(const nn::wlan::detail::SfdlMulticastFilterInfo& info) NN_NOEXCEPT;
    };
#endif

}}}

#if 0

// Template for implementation users
class Impl
{
public:
    nn::Result PutFrameRaw(const nn::sf::InBuffer& pTxData) NN_NOEXCEPT;
    nn::Result CancelGetFrame(std::uint32_t rxId) NN_NOEXCEPT;
    nn::Result CreateRxEntry(nn::sf::Out<std::uint32_t> pOutRxId, const nn::sf::InArray<std::uint16_t>& pEthertypeArray, std::uint32_t capacity) NN_NOEXCEPT;
    nn::Result DeleteRxEntry(std::uint32_t rxId) NN_NOEXCEPT;
    nn::Result AddEthertypeToRxEntry(std::uint32_t rxId, std::uint16_t ethertype) NN_NOEXCEPT;
    nn::Result DeleteEthertypeFromRxEntry(nn::sf::Out<std::uint32_t> pOutRxId, std::uint16_t ethertype) NN_NOEXCEPT;
    nn::Result GetMacAddress(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr) NN_NOEXCEPT;
    nn::Result SwitchTsfTimerFunction(bool enable) NN_NOEXCEPT;
    nn::Result GetDeltaTimeBetweenSystemAndTsf(nn::sf::Out<std::int64_t> pOutDeltaTime) NN_NOEXCEPT;
    nn::Result RegisterSharedMemory(nn::sf::NativeHandle&& memHandle, std::uint32_t memSize, nn::sf::NativeHandle&& RxEventHandle, nn::sf::NativeHandle&& TxEventHandle, nn::sf::NativeHandle&& RxCbufEventHandle, nn::sf::NativeHandle&& TxCbufEventHandlw) NN_NOEXCEPT;
    nn::Result UnregisterSharedMemory() NN_NOEXCEPT;
    nn::Result EnableSharedMemory() NN_NOEXCEPT;
    nn::Result SetMulticastFilter(const nn::wlan::detail::SfdlMulticastFilterInfo& info) NN_NOEXCEPT;
};

#endif

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE((::nn::wlan::detail::ISocketManager))

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PutFrameRaw, (const ::nn::sf::InBuffer& pTxData))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(PutFrameRaw, (pTxData));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelGetFrame, (::std::uint32_t rxId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CancelGetFrame, (rxId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateRxEntry, (::nn::sf::Out<::std::uint32_t> pOutRxId, const ::nn::sf::InArray<::std::uint16_t>& pEthertypeArray, ::std::uint32_t capacity))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(CreateRxEntry, (pOutRxId, pEthertypeArray, capacity));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteRxEntry, (::std::uint32_t rxId))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteRxEntry, (rxId));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddEthertypeToRxEntry, (::std::uint32_t rxId, ::std::uint16_t ethertype))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(AddEthertypeToRxEntry, (rxId, ethertype));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteEthertypeFromRxEntry, (::nn::sf::Out<::std::uint32_t> pOutRxId, ::std::uint16_t ethertype))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(DeleteEthertypeFromRxEntry, (pOutRxId, ethertype));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMacAddress, (::nn::sf::Out<::nn::wlan::detail::SfdlMacAddress> pOutMacAddr))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetMacAddress, (pOutMacAddr));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SwitchTsfTimerFunction, (bool enable))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SwitchTsfTimerFunction, (enable));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeltaTimeBetweenSystemAndTsf, (::nn::sf::Out<::std::int64_t> pOutDeltaTime))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(GetDeltaTimeBetweenSystemAndTsf, (pOutDeltaTime));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterSharedMemory, (::nn::sf::NativeHandle&& memHandle, ::std::uint32_t memSize, ::nn::sf::NativeHandle&& RxEventHandle, ::nn::sf::NativeHandle&& TxEventHandle, ::nn::sf::NativeHandle&& RxCbufEventHandle, ::nn::sf::NativeHandle&& TxCbufEventHandlw))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(RegisterSharedMemory, (::std::move(memHandle), memSize, ::std::move(RxEventHandle), ::std::move(TxEventHandle), ::std::move(RxCbufEventHandle), ::std::move(TxCbufEventHandlw)));
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnregisterSharedMemory)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(UnregisterSharedMemory);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(EnableSharedMemory)
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_0(EnableSharedMemory);
    }

    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetMulticastFilter, (const ::nn::wlan::detail::SfdlMulticastFilterInfo& info))
    {
        NN_SF_IMPL_DETAIL_RETURN_IMPL_METHOD_RESULT_N(SetMulticastFilter, (info));
    }

NN_SF_IMPL_DETAIL_DEFINE_IMPL_TEMPLATE_BASE_END

// template <> struct nn::sf::cmif::detail::MethodInfos<nn::wlan::detail::ISocketManager>
NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS((::nn::wlan::detail::ISocketManager))

    // nn::Result PutFrameRaw(const nn::sf::InBuffer& pTxData) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(PutFrameRaw)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pTxData, 0, (const ::nn::sf::InBuffer&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_MAP_ALIAS)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pTxData))

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pTxData)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(PutFrameRaw)

    // nn::Result CancelGetFrame(std::uint32_t rxId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CancelGetFrame)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rxId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rxId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rxId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CancelGetFrame)

    // nn::Result CreateRxEntry(nn::sf::Out<std::uint32_t> pOutRxId, const nn::sf::InArray<std::uint16_t>& pEthertypeArray, std::uint32_t capacity) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(CreateRxEntry)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(2)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_COUNT(1)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFO(pEthertypeArray, 0, (const ::nn::sf::InArray<::std::uint16_t>&), NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_IN | NN_SF_CMIF_DETAIL_BUFFER_ATTRIBUTE_HIPC_POINTER)
        NN_SF_CMIF_DETAIL_METHOD_INFO_BUFFER_INFOS_END(1, (pEthertypeArray))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(capacity, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (capacity))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRxId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutRxId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRxId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pEthertypeArray), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(capacity)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(CreateRxEntry)

    // nn::Result DeleteRxEntry(std::uint32_t rxId) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteRxEntry)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(3)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rxId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (rxId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rxId)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteRxEntry)

    // nn::Result AddEthertypeToRxEntry(std::uint32_t rxId, std::uint16_t ethertype) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(AddEthertypeToRxEntry)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ethertype, (::std::uint16_t), 0)
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(rxId, (::std::uint32_t), 4)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(2, (ethertype, rxId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(rxId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ethertype)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(AddEthertypeToRxEntry)

    // nn::Result DeleteEthertypeFromRxEntry(nn::sf::Out<std::uint32_t> pOutRxId, std::uint16_t ethertype) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(DeleteEthertypeFromRxEntry)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(ethertype, (::std::uint16_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (ethertype))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(2)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutRxId, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutRxId))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutRxId), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(ethertype)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(DeleteEthertypeFromRxEntry)

    // nn::Result GetMacAddress(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetMacAddress)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(6)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutMacAddr, (::nn::wlan::detail::SfdlMacAddress), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutMacAddr))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(6)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutMacAddr)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetMacAddress)

    // nn::Result SwitchTsfTimerFunction(bool enable) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SwitchTsfTimerFunction)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(7)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(enable, (bool), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (enable))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(1)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(enable)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SwitchTsfTimerFunction)

    // nn::Result GetDeltaTimeBetweenSystemAndTsf(nn::sf::Out<std::int64_t> pOutDeltaTime) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(GetDeltaTimeBetweenSystemAndTsf)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(8)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_MEMBER(pOutDeltaTime, (::std::int64_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_OUT_RAW_STRUCT_END(1, (pOutDeltaTime))
        NN_SF_CMIF_DETAIL_METHOD_INFO_OUT_RAW_SIZE(8)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(pOutDeltaTime)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(GetDeltaTimeBetweenSystemAndTsf)

    // nn::Result RegisterSharedMemory(nn::sf::NativeHandle&& memHandle, std::uint32_t memSize, nn::sf::NativeHandle&& RxEventHandle, nn::sf::NativeHandle&& TxEventHandle, nn::sf::NativeHandle&& RxCbufEventHandle, nn::sf::NativeHandle&& TxCbufEventHandlw) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(RegisterSharedMemory)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(9)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_COUNT(5)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(memHandle, 0, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(RxEventHandle, 1, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(TxEventHandle, 2, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(RxCbufEventHandle, 3, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
            NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFO(TxCbufEventHandlw, 4, NN_SF_CMIF_DETAIL_NATIVE_HANDLE_ATTRIBUTE_HIPC_COPY)
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_NATIVE_HANDLE_INFOS_END(5, (memHandle, RxEventHandle, TxEventHandle, RxCbufEventHandle, TxCbufEventHandlw))

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(memSize, (::std::uint32_t), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (memSize))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(4)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(memHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(memSize), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(RxEventHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(TxEventHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(RxCbufEventHandle), NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(TxCbufEventHandlw)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(RegisterSharedMemory)

    // nn::Result UnregisterSharedMemory() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(UnregisterSharedMemory)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(10)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(UnregisterSharedMemory)

    // nn::Result EnableSharedMemory() NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(EnableSharedMemory)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(11)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS(())

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(EnableSharedMemory)

    // nn::Result SetMulticastFilter(const nn::wlan::detail::SfdlMulticastFilterInfo& info) NN_NOEXCEPT
    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO(SetMulticastFilter)

        NN_SF_CMIF_DETAIL_METHOD_INFO_METHOD_ID(12)
        NN_SF_CMIF_DETAIL_METHOD_INFO_RETURN_TYPE_IS_RESULT(true)

        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT
            NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_MEMBER(info, (::nn::wlan::detail::SfdlMulticastFilterInfo), 0)
        NN_SF_CMIF_DETAIL_METHOD_INFO_DEFINE_IN_RAW_STRUCT_END(1, (info))
        NN_SF_CMIF_DETAIL_METHOD_INFO_IN_RAW_SIZE(49)

        NN_SF_CMIF_DETAIL_METHOD_INFO_ARGUMENT_INFOS((NN_SF_CMIF_DETAIL_METHOD_INFO_GET_ARGUMENT_INFO(info)))

    NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFO_END(SetMulticastFilter)

    NN_SF_CMIF_DETAIL_METHOD_INFO_REFERRED_STRUCT_ASSERTION_CHECK((::nn::wlan::detail::SfdlMulticastFilterInfo), 49, 1)

NN_SF_CMIF_DETAIL_DEFINE_METHOD_INFOS_END

// template <...> class nn::sf::client::detail::CmifProxy<nn::wlan::detail::ISocketManager, ...>
NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY((::nn::wlan::detail::ISocketManager))

    // nn::Result PutFrameRaw(const nn::sf::InBuffer& pTxData) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(PutFrameRaw, (const ::nn::sf::InBuffer& pTxData))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(PutFrameRaw)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pTxData)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(PutFrameRaw)
    }

    // nn::Result CancelGetFrame(std::uint32_t rxId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CancelGetFrame, (::std::uint32_t rxId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CancelGetFrame)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rxId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CancelGetFrame)
    }

    // nn::Result CreateRxEntry(nn::sf::Out<std::uint32_t> pOutRxId, const nn::sf::InArray<std::uint16_t>& pEthertypeArray, std::uint32_t capacity) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(CreateRxEntry, (::nn::sf::Out<::std::uint32_t> pOutRxId, const ::nn::sf::InArray<::std::uint16_t>& pEthertypeArray, ::std::uint32_t capacity))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(CreateRxEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRxId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pEthertypeArray)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(capacity)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(CreateRxEntry)
    }

    // nn::Result DeleteRxEntry(std::uint32_t rxId) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteRxEntry, (::std::uint32_t rxId))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteRxEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rxId)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteRxEntry)
    }

    // nn::Result AddEthertypeToRxEntry(std::uint32_t rxId, std::uint16_t ethertype) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(AddEthertypeToRxEntry, (::std::uint32_t rxId, ::std::uint16_t ethertype))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(AddEthertypeToRxEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(rxId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ethertype)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(AddEthertypeToRxEntry)
    }

    // nn::Result DeleteEthertypeFromRxEntry(nn::sf::Out<std::uint32_t> pOutRxId, std::uint16_t ethertype) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(DeleteEthertypeFromRxEntry, (::nn::sf::Out<::std::uint32_t> pOutRxId, ::std::uint16_t ethertype))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(DeleteEthertypeFromRxEntry)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutRxId)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(ethertype)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(DeleteEthertypeFromRxEntry)
    }

    // nn::Result GetMacAddress(nn::sf::Out<nn::wlan::detail::SfdlMacAddress> pOutMacAddr) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetMacAddress, (::nn::sf::Out<::nn::wlan::detail::SfdlMacAddress> pOutMacAddr))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetMacAddress)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutMacAddr)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetMacAddress)
    }

    // nn::Result SwitchTsfTimerFunction(bool enable) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SwitchTsfTimerFunction, (bool enable))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SwitchTsfTimerFunction)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(enable)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SwitchTsfTimerFunction)
    }

    // nn::Result GetDeltaTimeBetweenSystemAndTsf(nn::sf::Out<std::int64_t> pOutDeltaTime) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(GetDeltaTimeBetweenSystemAndTsf, (::nn::sf::Out<::std::int64_t> pOutDeltaTime))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(GetDeltaTimeBetweenSystemAndTsf)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(pOutDeltaTime)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(GetDeltaTimeBetweenSystemAndTsf)
    }

    // nn::Result RegisterSharedMemory(nn::sf::NativeHandle&& memHandle, std::uint32_t memSize, nn::sf::NativeHandle&& RxEventHandle, nn::sf::NativeHandle&& TxEventHandle, nn::sf::NativeHandle&& RxCbufEventHandle, nn::sf::NativeHandle&& TxCbufEventHandlw) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(RegisterSharedMemory, (::nn::sf::NativeHandle&& memHandle, ::std::uint32_t memSize, ::nn::sf::NativeHandle&& RxEventHandle, ::nn::sf::NativeHandle&& TxEventHandle, ::nn::sf::NativeHandle&& RxCbufEventHandle, ::nn::sf::NativeHandle&& TxCbufEventHandlw))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(RegisterSharedMemory)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(memHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(memSize)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(RxEventHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(TxEventHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(RxCbufEventHandle)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(TxCbufEventHandlw)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(RegisterSharedMemory)
    }

    // nn::Result UnregisterSharedMemory() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(UnregisterSharedMemory)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(UnregisterSharedMemory)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(UnregisterSharedMemory)
    }

    // nn::Result EnableSharedMemory() NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_0(EnableSharedMemory)
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(EnableSharedMemory)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(EnableSharedMemory)
    }

    // nn::Result SetMulticastFilter(const nn::wlan::detail::SfdlMulticastFilterInfo& info) NN_NOEXCEPT
    NN_SF_IMPL_DETAIL_IMPL_TEMPLATE_BASE_DEFINE_SYNC_METHOD_RESULT_N(SetMulticastFilter, (const ::nn::wlan::detail::SfdlMulticastFilterInfo& info))
    {
        NN_SF_CMIF_CLIENT_DETAIL_CALL_BEGIN(SetMulticastFilter)
            NN_SF_CMIF_CLIENT_DETAIL_CALL_ARGUMENT(info)
        NN_SF_CMIF_CLIENT_DETAIL_CALL_END(SetMulticastFilter)
    }

NN_SF_CMIF_CLIENT_DETAIL_DEFINE_PROXY_END

// template <> class nn::sf::server::detail::CmifProcessFunctionTableGetterImpl<nn::wlan::detail::ISocketManager>
NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER((::nn::wlan::detail::ISocketManager))

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(PutFrameRaw)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pTxData)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(PutFrameRaw)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pTxData)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CancelGetFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CancelGetFrame)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rxId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(CreateRxEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFER(pEthertypeArray)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_BUFFERS_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(CreateRxEntry)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRxId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_BUFFER(pEthertypeArray),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(capacity)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteRxEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteRxEntry)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rxId)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(AddEthertypeToRxEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(AddEthertypeToRxEntry)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(rxId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ethertype)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(DeleteEthertypeFromRxEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(DeleteEthertypeFromRxEntry)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutRxId),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(ethertype)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetMacAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetMacAddress)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutMacAddr)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SwitchTsfTimerFunction)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SwitchTsfTimerFunction)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(enable)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(GetDeltaTimeBetweenSystemAndTsf)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(GetDeltaTimeBetweenSystemAndTsf)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_OUT_MEMBER(pOutDeltaTime)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(RegisterSharedMemory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(memHandle)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(RxEventHandle)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(TxEventHandle)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(RxCbufEventHandle)
                NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLE(TxCbufEventHandlw)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_IN_NATIVE_HANDLES_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(RegisterSharedMemory)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(memHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(memSize),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(RxEventHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(TxEventHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(RxCbufEventHandle),
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_NATIVE_HANDLE(TxCbufEventHandlw)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(UnregisterSharedMemory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(UnregisterSharedMemory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(EnableSharedMemory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(EnableSharedMemory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD(SetMulticastFilter)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_PREPARE_END
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE(SetMulticastFilter)
            NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_IN_MEMBER(info)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_INVOKE_END
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_METHOD_END

    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(PutFrameRaw)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CancelGetFrame)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(CreateRxEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteRxEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(AddEthertypeToRxEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(DeleteEthertypeFromRxEntry)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetMacAddress)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SwitchTsfTimerFunction)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(GetDeltaTimeBetweenSystemAndTsf)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(RegisterSharedMemory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(UnregisterSharedMemory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(EnableSharedMemory)
        NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_CASE(SetMulticastFilter)
    NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCH_MESSAGE_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_END

NN_SF_CMIF_SERVER_DETAIL_DEFINE_DISPATCHER_FUNCTION_TABLE((::nn::wlan::detail::ISocketManager))

namespace nn { namespace wlan { namespace detail { // NOLINT(whitespace/braces)

struct SfdlScanIeMatchInfo
{
    nn::Bit8 matchData[255];
    std::uint8_t matchLength;
};

}}}
