﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_ResourceIdManagement.h"

#include <atomic>

namespace {
    std::atomic<uint64_t> g_ResourceId;
}

namespace nn{ namespace visrv{

    uint64_t AcquireResourceId() NN_NOEXCEPT
    {
        uint64_t value = ++g_ResourceId;
        return value;
    }

    void ReleaseResourceId(uint64_t value) NN_NOEXCEPT
    {
        NN_UNUSED(value);
        // do nothing
    }

}}
