﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "visrv_VicTaskQueue.h"

namespace nn{ namespace visrv{ namespace vic{

    class VicTaskWorker
    {
    public:
        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        // キューが満杯の場合ブロックする。
        // *pTask をコピーしないので実行が完了するまで *pTask を破棄しないこと。
        // 実行の完了は pTask->Execute() が走ったことで判定する。
        void SubmitTask(IVicTask* pTask) NN_NOEXCEPT;

        // TORIAEZU: 停止する方法はない。
        void Run() NN_NOEXCEPT;
    private:
        VicTaskQueue m_TaskQueue;
    };

    extern VicTaskWorker g_VicTaskWorker;

}}}
