﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>

namespace nn{ namespace visrv{ namespace vic{

    class IVicTask
    {
    public:
        virtual ~IVicTask() NN_NOEXCEPT =0;
        virtual void Execute() NN_NOEXCEPT =0;
    };

    class VicTaskQueue
    {
    public:
        static const int Capacity = 15;
        static const int Size = 16;

    public:
        VicTaskQueue() NN_NOEXCEPT;

        void Initialize() NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        // 成功するまでブロックする。
        void Enqueue(IVicTask* pTask) NN_NOEXCEPT;
        // 成功するまでブロックする。
        void Dequeue(IVicTask** ppOutTask) NN_NOEXCEPT;

    private:
        nn::Result EnqueueImpl(IVicTask* pTask) NN_NOEXCEPT;
        nn::Result DequeueImpl(IVicTask** ppOutTask) NN_NOEXCEPT;

    public:
        IVicTask* m_TaskList[Size];
        int m_Head;
        int m_Tail;
        nn::os::MutexType             m_Mutex;
        nn::os::ConditionVariableType m_ConditionVariable;
    };

}}}
