﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/util/util_Color.h>
#include <nn/vi/vi_ImageTransform.h>
#include <nvrm_surface.h>

#include "visrv_VicRectangle.h"
#include "visrv_VicModule.h"

namespace nn{ namespace visrv{ namespace vic{

    enum VicCopyFilter
    {
        VicCopyFilter_Nearest,
        VicCopyFilter_Bilinear,
        VicCopyFilter_Nicest,
    };

    enum VicCopyAlphaMode
    {
        VicCopyAlphaMode_Opaque,
        VicCopyAlphaMode_Source,
    };

    struct VicCopySingleDestinationInfo
    {
        // コピー先の Surface
        NvRmSurface* pSurface;
        // コピー先の矩形範囲（ピクセル）
        VicRectangle region;
        // コピー先の回転
        nn::vi::ImageTransformType transform;
    };

    struct VicCopySingleSourceInfo
    {
        // コピー元の Surface
        const NvRmSurface* pSurface;
        // コピー元の矩形範囲（ピクセル）
        VicRectangle region;
        // コピー元の回転
        nn::vi::ImageTransformType transform;
    };


    struct VicCopyOption
    {
        VicCopyFilter filter;
        VicCopyAlphaMode alphaMode;
        nn::util::Color4f backgroundColor;
    };

    class VicOperation
    {
    public:
        static nn::Result CopySingle(
            NvRmFence* pOutFence,
            VicCopySingleDestinationInfo& dst,
            VicModule* pModule,
            const VicCopySingleSourceInfo& src,
            const VicCopyOption& option
        ) NN_NOEXCEPT;
    };

}}}
