﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nvrm_memmgr.h>

#include "visrv_VicConfig.h"
#include "visrv_VicModule.h"

namespace nn{ namespace visrv{ namespace vic{

    class VicMemoryPool
    {
    public:
        static size_t GetRequiredAlignment() NN_NOEXCEPT;
        static size_t GetRequiredUnitSize() NN_NOEXCEPT;

        VicMemoryPool() NN_NOEXCEPT;

        nn::Result Initialize(VicModule* pModule, void* pMemory, size_t size) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        bool IsInitialized() const NN_NOEXCEPT;

        NvRmMemHandle GetHandle() const NN_NOEXCEPT;
        void*         GetPointer() const NN_NOEXCEPT;
        uintptr_t     GetAddress() const NN_NOEXCEPT;
        size_t        GetSize() const NN_NOEXCEPT;

    private:
        NvRmMemHandle m_hMemory;
        void*         m_pMemory;
        size_t        m_Size;
    };

}}}
