﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_TransferMemory.h>
#include <nn/sf/sf_NativeHandleFwd.h>

namespace nn{ namespace visrv{ namespace util{

    class TransferMemoryBinder
    {
    public:
        TransferMemoryBinder() NN_NOEXCEPT;

        // @pre true
        bool IsBound() const NN_NOEXCEPT;

        // @pre IsBound
        void* GetBoundMemory() NN_NOEXCEPT;

        // @pre IsBound
        const void* GetBoundMemory() const NN_NOEXCEPT;

        // @pre IsBound
        size_t GetBoundMemorySize() const NN_NOEXCEPT;

        // @pre !IsBound
        // @post IsBound
        nn::Result Bind(nn::sf::NativeHandle& handle, size_t size, nn::os::MemoryPermission ownerPermission) NN_NOEXCEPT;

        // @pre IsBound
        // @post !IsBound
        void Unbind() NN_NOEXCEPT;

    private:
        nn::os::TransferMemoryType m_TransferMemory;
        void*  m_pBoundMemory;
        size_t m_BoundMemorySize;

    };

}}}
