﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/vi/sf/vi_DisplayService.sfdl.h>
#include "../client/visrv_ClientObject.h"

namespace nn{ namespace visrv{ namespace service{

    class SystemDisplayServiceImpl
    {
    public:
        NN_IMPLICIT SystemDisplayServiceImpl(client::ClientObjectSmartHolder* pClientHolder) NN_NOEXCEPT;
        ~SystemDisplayServiceImpl() NN_NOEXCEPT;

        nn::Result GetZOrderCountMin(nn::sf::Out<std::int64_t> outValue, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result GetZOrderCountMax(nn::sf::Out<std::int64_t> outValue, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result SetLayerPosition(nn::vi::LayerId layerId, float x, float y) NN_NOEXCEPT;
        nn::Result SetLayerSize(nn::vi::LayerId layerId, std::int64_t width, std::int64_t height) NN_NOEXCEPT;
        nn::Result GetLayerZ(nn::sf::Out<std::int64_t> outZ, nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result SetLayerZ(nn::vi::LayerId layerId, std::int64_t z) NN_NOEXCEPT;
        nn::Result SetLayerVisibility(nn::vi::LayerId layerId, bool isVisible) NN_NOEXCEPT;
        nn::Result SetLayerAlpha(nn::vi::LayerId layerId, float alpha) NN_NOEXCEPT;
        nn::Result ListDisplayModes(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::vi::DisplayModeInfo>& outModes, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result ListDisplayRgbRanges(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::vi::RgbRangeType>& outRanges, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result ListDisplayContentTypes(nn::sf::Out<std::int64_t> outCount, const nn::sf::OutArray<nn::vi::ContentTypeType>& outTypes, nn::vi::DisplayId dispayId) NN_NOEXCEPT;
        nn::Result GetDisplayMode(nn::sf::Out<nn::vi::DisplayModeInfo> outMode, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result SetDisplayMode(nn::vi::DisplayId displayId, const nn::vi::DisplayModeInfo& mode) NN_NOEXCEPT;
        nn::Result GetDisplayUnderscan(nn::sf::Out<std::int64_t> outUnderscan, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result SetDisplayUnderscan(nn::vi::DisplayId displayId, std::int64_t underscan) NN_NOEXCEPT;
        nn::Result GetDisplayContentType(nn::sf::Out<nn::vi::ContentTypeType> outType, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result SetDisplayContentType(nn::vi::DisplayId displayId, nn::vi::ContentTypeType type) NN_NOEXCEPT;
        nn::Result GetDisplayRgbRange(nn::sf::Out<nn::vi::RgbRangeType> outRange, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result SetDisplayRgbRange(nn::vi::DisplayId displayId, nn::vi::RgbRangeType range) NN_NOEXCEPT;
        nn::Result GetDisplayCmuMode(nn::sf::Out<nn::vi::CmuModeType> outMode, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result SetDisplayCmuMode(nn::vi::DisplayId displayId, nn::vi::CmuModeType mode) NN_NOEXCEPT;
        nn::Result GetDisplayContrastRatio(nn::sf::Out<float> outRatio, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result SetDisplayContrastRatio(nn::vi::DisplayId displayId, float ratio) NN_NOEXCEPT;
        nn::Result GetDisplayGamma(nn::sf::Out<float> outGamma, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result SetDisplayGamma(nn::vi::DisplayId displayId, float gamma) NN_NOEXCEPT;
        nn::Result GetDisplayCmuLuma(nn::sf::Out<float> outValue, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result SetDisplayCmuLuma(nn::vi::DisplayId displayId, float value) NN_NOEXCEPT;
        nn::Result CreateStrayLayer(
            nn::sf::Out<nn::vi::LayerId> outLayerId,
            nn::sf::Out<std::int64_t> outNativeWindowDataSize,
            const nn::sf::OutBuffer& outNativeWindowData,
            nn::vi::DisplayId displayId,
            nn::vi::LayerSettingsType settings
            ) NN_NOEXCEPT;
        nn::Result GetDisplayLogicalResolution(nn::sf::Out<std::int32_t> outWidth, nn::sf::Out<std::int32_t> outHeight, nn::vi::DisplayId displayId) NN_NOEXCEPT;

        nn::Result OpenIndirectLayer(nn::sf::Out<std::int64_t> outNativeWindowDataSize, const nn::sf::OutBuffer& outNativeWindowData, nn::vi::IndirectProducerHandleType producerHandle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result CloseIndirectLayer(nn::vi::IndirectProducerHandleType producerHandle) NN_NOEXCEPT;
        nn::Result FlipIndirectLayer(nn::vi::IndirectProducerHandleType producerHandle) NN_NOEXCEPT;
        nn::Result SetDisplayMagnification(nn::vi::DisplayId displayId, int x, int y, int width, int height) NN_NOEXCEPT;

        nn::Result GetSharedBufferMemoryHandleId(nn::sf::Out<nn::vi::native::NativeMemoryHandleId> outMemoryHandleId, nn::sf::Out<std::uint64_t> outMemorySize, nn::sf::Out<nn::vi::fbshare::SharedMemoryPoolLayout> outLayout, nn::vi::fbshare::SharedBufferHandle hBuffer, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result OpenSharedLayer(nn::vi::fbshare::SharedLayerHandle hLayer, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result CloseSharedLayer(nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT;
        nn::Result ConnectSharedLayer(nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT;
        nn::Result DisconnectSharedLayer(nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT;
        nn::Result AcquireSharedFrameBuffer(nn::sf::Out<std::int64_t> outIndex, nn::sf::Out<nn::vi::native::NativeSync> outSync, nn::sf::Out<nn::vi::fbshare::SharedLayerTextureIndexList> outIndexList, nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT;
        nn::Result PresentSharedFrameBuffer(nn::vi::fbshare::SharedLayerHandle hLayer, std::int64_t index, const nn::vi::native::NativeSync& sync, const nn::vi::CropRegion& crop, nn::vi::ImageTransformType transform, std::int32_t presentInterval) NN_NOEXCEPT;
        nn::Result GetSharedFrameBufferAcquirableEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT;
        nn::Result FillSharedFrameBufferColor(nn::vi::fbshare::SharedLayerHandle hLayer, std::int64_t index, std::int32_t r, std::int32_t g, std::int32_t b, std::int32_t a) NN_NOEXCEPT;
        nn::Result CancelSharedFrameBuffer(nn::vi::fbshare::SharedLayerHandle hLayer, std::int64_t index) NN_NOEXCEPT;
    private:
        client::ClientObjectSmartHolder m_ClientHolder;
    };

}}}
