﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/vi/sf/vi_DisplayService.sfdl.h>
#include "../client/visrv_ClientObject.h"

namespace nn{ namespace visrv{ namespace service{

    class ManagerDisplayServiceImpl
    {
    public:
        NN_IMPLICIT ManagerDisplayServiceImpl(client::ClientObjectSmartHolder* pClientHolder) NN_NOEXCEPT;
        ~ManagerDisplayServiceImpl() NN_NOEXCEPT;

        nn::Result AllocateProcessHeapBlock(nn::sf::Out<std::uint64_t> outBlockId, std::uint64_t size) NN_NOEXCEPT;
        nn::Result FreeProcessHeapBlock(std::uint64_t blockId) NN_NOEXCEPT;

        nn::Result GetDisplayResolution(nn::sf::Out<std::int64_t> pOutWidth, nn::sf::Out<std::int64_t> pOutHeight, nn::vi::DisplayId displayId) NN_NOEXCEPT;

        nn::Result CreateManagedLayer(nn::sf::Out<nn::vi::LayerId> outLayerId, nn::vi::DisplayId displayId, nn::vi::LayerSettingsType settings, nn::applet::AppletResourceUserId userAruid) NN_NOEXCEPT;
        nn::Result DestroyManagedLayer(nn::vi::LayerId layerId) NN_NOEXCEPT;

        nn::Result CreateIndirectLayer(nn::sf::Out<nn::vi::IndirectLayerHandleType> outLayerHandle) NN_NOEXCEPT;
        nn::Result DestroyIndirectLayer(nn::vi::IndirectLayerHandleType layerHandle) NN_NOEXCEPT;
        nn::Result CreateIndirectProducerEndPoint(nn::sf::Out<nn::vi::IndirectProducerHandleType> outProducerEndPointHandle, nn::vi::IndirectLayerHandleType layerHandle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result DestroyIndirectProducerEndPoint(nn::vi::IndirectLayerHandleType layerHandle) NN_NOEXCEPT;
        nn::Result CreateIndirectConsumerEndPoint(nn::sf::Out<nn::vi::IndirectConsumerHandleType> outConsumerEndPointHandle, nn::vi::IndirectLayerHandleType layerHandle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result DestroyIndirectConsumerEndPoint(nn::vi::IndirectLayerHandleType layerHandle) NN_NOEXCEPT;

        nn::Result CreateSharedBufferStaticStorage(nn::sf::Out<nn::vi::fbshare::SharedBufferHandle> outHandle, std::uint64_t storageKey, const nn::vi::fbshare::SharedMemoryPoolLayout& layout) NN_NOEXCEPT;
        nn::Result CreateSharedBufferTransferMemory(nn::sf::Out<nn::vi::fbshare::SharedBufferHandle> outHandle, nn::sf::NativeHandle&& transferMemoryHandle, std::uint64_t transferMemorySize, const nn::vi::fbshare::SharedMemoryPoolLayout& layout) NN_NOEXCEPT;
        nn::Result CreateSharedBufferProcessHeap(nn::sf::Out<nn::vi::fbshare::SharedBufferHandle> outHandle, std::uint64_t blockId, const nn::vi::fbshare::SharedMemoryPoolLayout& layout) NN_NOEXCEPT;
        nn::Result DestroySharedBuffer(nn::vi::fbshare::SharedBufferHandle handle) NN_NOEXCEPT;
        nn::Result BindSharedLowLevelLayerToManagedLayer(nn::vi::LayerId layerId, const nn::vi::DisplayName& displayName, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result BindSharedLowLevelLayerToIndirectLayer(nn::vi::IndirectLayerHandleType handle, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;
        nn::Result UnbindSharedLowLevelLayer(nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result ConnectSharedLowLevelLayerToSharedBuffer(nn::vi::LayerId layerId, nn::vi::fbshare::SharedBufferHandle hSharedBuffer) NN_NOEXCEPT;
        nn::Result DisconnectSharedLowLevelLayerFromSharedBuffer(nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result CreateSharedLayer(nn::sf::Out<nn::vi::fbshare::SharedLayerHandle> outLayerHandle, nn::applet::AppletResourceUserId userAruid) NN_NOEXCEPT;
        nn::Result DestroySharedLayer(nn::vi::fbshare::SharedLayerHandle hLayer) NN_NOEXCEPT;
        nn::Result AttachSharedLayerToLowLevelLayer(nn::vi::fbshare::SharedLayerHandle hSharedLayer, nn::vi::LayerId layerId, const nn::vi::fbshare::SharedLayerTextureIndexList& frameBufferIndexList) NN_NOEXCEPT;
        nn::Result StartDetachSharedLayerFromLowLevelLayer(nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT;
        nn::Result FinishDetachSharedLayerFromLowLevelLayer(nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT;
        nn::Result GetSharedLayerDetachReadyEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT;
        nn::Result ForceDetachSharedLayerFromLowLevelLayer(nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT;
        nn::Result GetSharedLowLevelLayerSynchronizedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result CheckSharedLowLevelLayerSynchronized(nn::sf::Out<std::int64_t> outDisplayedIndex, nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result RegisterSharedBufferImporterAruid(nn::vi::fbshare::SharedBufferHandle hBuffer, nn::applet::AppletResourceUserId importerAruid) NN_NOEXCEPT;
        nn::Result UnregisterSharedBufferImporterAruid(nn::vi::fbshare::SharedBufferHandle hBuffer, nn::applet::AppletResourceUserId importerAruid) NN_NOEXCEPT;
        nn::Result GetSharedLayerLayerStacks(nn::sf::Out<nn::vi::LayerStackFlagType> outStacks, nn::vi::fbshare::SharedLayerHandle hSharedLayer) NN_NOEXCEPT;
        nn::Result SetSharedLayerLayerStacks(nn::vi::fbshare::SharedLayerHandle hSharedLayer, nn::vi::LayerStackFlagType stacks) NN_NOEXCEPT;
        nn::Result PresentDetachedSharedFrameBufferToLowLevelLayer(nn::vi::fbshare::SharedBufferHandle hSharedBuffer, nn::vi::LayerId layerId, std::int64_t index) NN_NOEXCEPT;
        nn::Result FillDetachedSharedFrameBufferColor(nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t index, std::uint32_t color, const nn::vi::fbshare::SharedTextureOption& option) NN_NOEXCEPT;
        nn::Result GetDetachedSharedFrameBufferImage(nn::sf::Out<std::uint64_t> outDataSize, const nn::sf::OutBuffer& data, nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t index) NN_NOEXCEPT;
        nn::Result SetDetachedSharedFrameBufferImage(nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t index, const nn::sf::InBuffer& data, const nn::vi::fbshare::SharedTextureOption& dstOption, nn::vi::ImageTransformType srcTransform) NN_NOEXCEPT;
        nn::Result CopyDetachedSharedFrameBufferImage(nn::vi::fbshare::SharedBufferHandle hDstSharedBuffer, std::int64_t dstIndex, nn::vi::fbshare::SharedBufferHandle hSrcSharedBuffer, std::int64_t srcIndex, const nn::vi::fbshare::SharedTextureOption& dstOption, nn::vi::LayerStackFlagType maskStacks, nn::vi::LayerStackFlagType nullStacks) NN_NOEXCEPT;
        nn::Result SetDetachedSharedFrameBufferSubImage(nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t index, std::int32_t x, std::int32_t y, std::int32_t w, std::int32_t h, std::uint32_t bgColor, const nn::sf::InBuffer& data, const nn::vi::fbshare::SharedTextureOption& dstOption, nn::vi::ImageTransformType srcTransform) NN_NOEXCEPT;
        nn::Result GetSharedFrameBufferContentParameter(nn::sf::Out<nn::vi::LayerStackFlagType> outLayerStacks, nn::sf::Out<nn::vi::CropRegion> outCropRegion, nn::sf::Out<std::int32_t> outScalingMode, nn::sf::Out<std::uint32_t> outTransform, nn::sf::Out<std::int32_t> outPresentInterval, nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t index) NN_NOEXCEPT;
        nn::Result ExpandStartupLogoOnSharedFrameBuffer(nn::vi::fbshare::SharedBufferHandle hSharedBuffer, std::int64_t dstIndex, const nn::vi::fbshare::SharedTextureOption& option) NN_NOEXCEPT;

        nn::Result AcquireLayerTexturePresentingEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result ReleaseLayerTexturePresentingEvent(nn::vi::LayerId layerId) NN_NOEXCEPT;

        Result AddToLayerStack(nn::vi::LayerId layerId, nn::vi::LayerStackType stackId) NN_NOEXCEPT;
        Result RemoveFromLayerStack(nn::vi::LayerId layerId, nn::vi::LayerStackType stackId) NN_NOEXCEPT;
        Result SetLayerVisibility(nn::vi::LayerId layerId, bool isVisible) NN_NOEXCEPT;
        Result SetLayerConfig(nn::vi::LayerId layerId, nn::vi::LayerConfig config) NN_NOEXCEPT;

        nn::Result AttachLayerPresentationTracer(nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result DetachLayerPresentationTracer(nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result StartLayerPresentationRecording(nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result StopLayerPresentationRecording(nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result StartLayerPresentationFenceWait(nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result StopLayerPresentationFenceWait(nn::vi::LayerId layerId) NN_NOEXCEPT;
        nn::Result GetLayerPresentationAllFencesExpiredEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::LayerId layerId) NN_NOEXCEPT;

        void SetContentVisibility(bool isVisible) NN_NOEXCEPT;

        nn::Result GetDisplayHotplugState(nn::sf::Out<nn::vi::HotplugStateType> outState, nn::vi::DisplayId displayId) NN_NOEXCEPT;

        nn::Result SetDisplayAlpha(nn::vi::DisplayId displayId, float alpha) NN_NOEXCEPT;
        nn::Result SetDisplayLayerStack(nn::vi::DisplayId displayId, nn::vi::LayerStackType id) NN_NOEXCEPT;
        nn::Result SetDisplayPowerState(nn::vi::DisplayId displayId, nn::vi::PowerStateType state) NN_NOEXCEPT;
        nn::Result GetDisplayHotplugEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result GetDisplayModeChangedEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::DisplayId displayId) NN_NOEXCEPT;

        nn::Result GetDisplayErrorEvent(nn::sf::Out<nn::sf::NativeHandle> outHandle, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        nn::Result GetCompositorErrorInfo(nn::sf::Out<nn::vi::CompositorError> outErrorInfo, nn::sf::Out<std::int32_t> outLength, std::int64_t errorId, nn::vi::DisplayId displayId) NN_NOEXCEPT;

        Result SetConductorLayer(nn::vi::LayerId layerId, bool isConductor) NN_NOEXCEPT;
        nn::Result SetIndirectProducerFlipOffset(nn::vi::IndirectLayerHandleType layerHandle, nn::vi::IndirectProducerHandleType producerHandle, nn::TimeSpan offset) NN_NOEXCEPT;

        nn::Result SetDefaultDisplay(nn::vi::DisplayId id) NN_NOEXCEPT;


    private:
        client::ClientObjectSmartHolder m_ClientHolder;
    };

}}}
