﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_CheckPermission.h"

namespace nn{ namespace visrv{ namespace service{

    bool CheckPolicyPermission(client::ClientPermission permission, nn::vi::PolicyLevelType policy) NN_NOEXCEPT
    {
        if(permission == client::ClientPermission_Application)
        {
            switch(policy)
            {
            case nn::vi::PolicyLevel_Standard:
                {
                    return true;
                }
            default:
                {
                    return false;
                }
            }
        }
        else if(permission == client::ClientPermission_System)
        {
            switch(policy)
            {
            case nn::vi::PolicyLevel_Standard:
            case nn::vi::PolicyLevel_Composition:
                {
                    return true;
                }
            default:
                {
                    return false;
                }
            }
        }
        else if(permission == client::ClientPermission_Manager)
        {
            switch(policy)
            {
            case nn::vi::PolicyLevel_Standard:
            case nn::vi::PolicyLevel_Composition:
                {
                    return true;
                }
            default:
                {
                    return false;
                }
            }
        }
        else
        {
            return false;
        }
    }


    bool CheckServicePermission(client::ClientPermission permission, ServiceLevel service) NN_NOEXCEPT
    {
        if(permission == client::ClientPermission_Application)
        {
            switch(service)
            {
            case ServiceLevel_ApplicationDisplay:
            case ServiceLevel_Relay:
                {
                    return true;
                }
            default:
                {
                    return false;
                }
            }
        }
        else if(permission == client::ClientPermission_System)
        {
            switch(service)
            {
            case ServiceLevel_ApplicationDisplay:
            case ServiceLevel_SystemDisplay:
            case ServiceLevel_Relay:
            case ServiceLevel_IndirectDisplay:
                {
                    return true;
                }
            default:
                {
                    return false;
                }
            }
        }
        else if(permission == client::ClientPermission_Manager)
        {
            // manager can do everything!
            return true;
        }
        else
        {
            return false;
        }
    }

}}}
