﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_ApplicationRootServiceImpl.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/os.h>
#include <nn/vi/vi_Result.public.h>
#include "../visrv_Log.h"
#include "../visrv_Config.h"
#include "visrv_ApplicationDisplayServiceFactory.h"
#include "visrv_CheckPermission.h"

namespace nn{ namespace visrv{ namespace service{

    ApplicationRootServiceImpl::ApplicationRootServiceImpl() NN_NOEXCEPT
    {
        NN_VISRV_LOG_LIFETIME("ApplicationRootServiceImpl ctor\n");
    }
    ApplicationRootServiceImpl::~ApplicationRootServiceImpl() NN_NOEXCEPT
    {
        NN_VISRV_LOG_LIFETIME("ApplicationRootServiceImpl dtor\n");
    }


    nn::Result ApplicationRootServiceImpl::GetDisplayService(
        nn::sf::Out<nn::sf::SharedPointer<nn::visrv::sf::IApplicationDisplayService>> outService,
        nn::vi::PolicyLevelType policyLevel
        ) NN_NOEXCEPT
    {
        NN_VISRV_TRACE_IPC_U(GetDisplayService);
        const client::ClientPermission clientPermission  = client::ClientPermission_Application;

        if(!CheckPolicyPermission(clientPermission, policyLevel))
        {
            NN_VISRV_LOG_ERR("GetDisplayService failed: permission denied\n");
            NN_RESULT_THROW(ResultDenied());
        }

        client::ClientConstants constants(
            clientPermission,
            policyLevel,
            false,
            {}
        );

        auto p = ApplicationDisplayServiceFactory::Create(constants);
        if(p == nullptr)
        {
            NN_VISRV_LOG_ERR("GetDisplayService failed: creating display service failed\n");
            NN_RESULT_THROW(ResultOperationFailed());
        }

        outService.Set(std::move(p));
        NN_RESULT_SUCCESS;
    }

}}}
