﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_ApplicationDisplayServiceFactory.h"

#include <memory>

#include <nn/sf/sf_ObjectFactory.h>
#include "visrv_ApplicationDisplayServiceImpl.h"
#include "../visrv_Log.h"
#include "../visrv_MemoryManagement.h"

namespace nn{ namespace visrv{ namespace service{

    nn::sf::SharedPointer<sf::IApplicationDisplayService> ApplicationDisplayServiceFactory::Create(
        const client::ClientConstants& clientConstants
        ) NN_NOEXCEPT
    {
        auto p = nn::sf::CreateSharedObjectEmplaced<sf::IApplicationDisplayService, ApplicationDisplayServiceImpl>(clientConstants);

        if(p == nullptr)
        {
            NN_VISRV_LOG_ERR("Creating DisplayService failed: service object construction failed.\n");
            return nullptr;
        }

        return p;
    };

}}}
