﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/lmem/lmem_UnitHeap.h>
#include <nn/vi/sf/vi_ServiceTypes.h>
#include <binder/IBinder.h>
#include "../visrv_Config.h"

namespace nn{ namespace visrv{ namespace native{

    enum BinderClass
    {
        BinderClass_Unknown,
        BinderClass_IGraphicBufferProducer,
    };
    typedef int32_t BinderClassType;

    class BinderEntry
    {
    public:
        void Initialize(
            const android::sp<android::IBinder>& pIBinder,
            BinderClassType binderClass,
            int32_t driverHandle,
            nn::vi::DisplayId displayId,
            nn::vi::LayerId layerId
            ) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        bool IsInitialized() const NN_NOEXCEPT;

        BinderClassType GetBinderClass() const NN_NOEXCEPT;
        int32_t GetDriverHandle() const NN_NOEXCEPT;
        nn::vi::DisplayId GetDisplayId() const NN_NOEXCEPT;
        nn::vi::LayerId GetLayerId() const NN_NOEXCEPT;

        int GetRemoteStrongReferenceCount() const NN_NOEXCEPT;
        int GetRemoteWeakReferenceCount() const NN_NOEXCEPT;

        void AddRemoteStrongReferenceCount(int delta) NN_NOEXCEPT;
        void AddRemoteWeakReferenceCount(int delta) NN_NOEXCEPT;


    private:
        android::sp<android::IBinder> m_pIBinder;
        BinderClassType   m_BinderClass;
        int32_t           m_DriverHandle;
        nn::vi::DisplayId m_DisplayId;
        nn::vi::LayerId   m_LayerId;
        int               m_RemoteStrongReferenceCount;
        int               m_RemoteWeakReferenceCount;
    };

    class BinderTable
    {
    public:
        static const int Capacity = DriverObjectPerClientMax;

    public:
        BinderEntry* AddEntry(
            const android::sp<android::IBinder>& pIBinder,
            BinderClassType binderClass,
            int32_t driverHandle,
            nn::vi::DisplayId displayId,
            nn::vi::LayerId layerId
            ) NN_NOEXCEPT;

        BinderEntry* FindEntryByDriverHandle(int32_t driverHandle) NN_NOEXCEPT;

        //void RemoveHandlesOnDisplay(nn::vi::DisplayId displayId) NN_NOEXCEPT;
        void RemoveHandlesOnLayer(nn::vi::LayerId layerId) NN_NOEXCEPT;

        bool IsEmpty() const NN_NOEXCEPT;

    private:
        BinderEntry m_EntryList[Capacity];
    };

}}}
