﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/vi/vi_Types.h>
#include <nn/vi/vi_PixelFormat.h>
#include <nn/vi/vi_ScalingMode.h>
#include <nn/vi/vi_LayerSettings.h>
#include <nn/vi/sf/vi_PolicyLevel.h>
#include <nn/vi/vi_LayerStack.h>
#include "detail/visrv_Android.h"

namespace nn { namespace visrv { namespace master{

    class Display;

    class Layer
    {
        friend class Display;
    public:
        explicit Layer(Display* pDisplay, nn::vi::PolicyLevelType policyLevel) NN_NOEXCEPT;
        ~Layer() NN_NOEXCEPT;

        nn::Result Initialize(nn::vi::LayerSettings settings, nn::applet::AppletResourceUserId aruid) NN_NOEXCEPT;

        nn::Result SetPosition(float x, float y) NN_NOEXCEPT;
        nn::Result SetZ(int z) NN_NOEXCEPT;
        nn::Result SetZUnsafe(int z) NN_NOEXCEPT;
        nn::Result SetSize(int width, int height) NN_NOEXCEPT;
        nn::Result SetVisibility(bool isVisible) NN_NOEXCEPT;
        nn::Result SetAlpha(float alpha) NN_NOEXCEPT;

        nn::Result AddToStack(nn::vi::LayerStack id) NN_NOEXCEPT;
        nn::Result RemoveFromStack(nn::vi::LayerStack id) NN_NOEXCEPT;
        nn::Result SetStacks(std::uint32_t stacks) NN_NOEXCEPT;
        std::uint32_t GetStacks() const NN_NOEXCEPT;
        nn::Result SetStackUnsafe(nn::vi::LayerStackSet stacks, nn::vi::LayerStackSet mask) NN_NOEXCEPT;

        float GetX() const NN_NOEXCEPT;
        float GetY() const NN_NOEXCEPT;
        int GetZ() const NN_NOEXCEPT;
        int GetCurrentWidth() const NN_NOEXCEPT;
        int GetCurrentHeight() const NN_NOEXCEPT;
        nn::vi::NativeWindowHandle GetNativeWindow() const NN_NOEXCEPT;
        Display* GetDisplay() const NN_NOEXCEPT;
        nn::vi::LayerSettings GetSettings() const NN_NOEXCEPT;

        nn::util::IntrusiveListNode m_ListNode;

        android::SurfaceComposerClient& m_Client;
        android::sp<android::SurfaceControl> m_Control;
        android::sp<android::IBinder> m_Handle;
        android::sp<android::IGraphicBufferProducer> m_GraphicBufferProducer;

        bool IsValidZOrder(int z) NN_NOEXCEPT;

        static bool IsValidStackSet(nn::vi::LayerStackSet stacks) NN_NOEXCEPT;
    private:
        Display* m_pDisplay;
        int m_Z;
        int m_CurrentWidth;
        int m_CurrentHeight;
        float m_X;
        float m_Y;
        nn::vi::LayerSettings m_Settings;
        nn::vi::PolicyLevelType m_PolicyLevel;
        nn::vi::LayerStackSet m_Stack;

        ANativeWindow* GetWindow() const NN_NOEXCEPT;

        static bool IsValidStack(nn::vi::LayerStack id) NN_NOEXCEPT;
        static bool IsValidStackMask(std::uint32_t stacks) NN_NOEXCEPT;
        nn::Result UpdateLayerStack() NN_NOEXCEPT;
        android::status_t SetVisibilityUnsafe(bool isVisible) NN_NOEXCEPT;
    };

}}}
