﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/vi/vi_Types.h>
#include <nn/vi/vi_PixelFormat.h>
#include <nn/vi/vi_ScalingMode.h>
#include "visrv_DisplayPolicy.h"
#include "visrv_DisplaySupport.h"

namespace nn{ namespace visrv{ namespace master{ namespace detail{

    class PlatformDisplayInfo
    {
    public:
        PlatformDisplayInfo() NN_NOEXCEPT;
        PlatformDisplayInfo(const char* name,
                            int layerWidthPixelCountMax,
                            int layerHeightPixelCountMax,
                            const DisplayPolicy& policy,
                            const DisplaySupport& support,
                            bool isTouchscreen) NN_NOEXCEPT;
        PlatformDisplayInfo(const PlatformDisplayInfo& rhs);

        const DisplayPolicy& GetPolicy() const NN_NOEXCEPT;
        const DisplaySupport& GetSupport() const NN_NOEXCEPT;

        bool HasValidName() const NN_NOEXCEPT;
        const char* GetName() const NN_NOEXCEPT;
        int GetLayerWidthPixelCountMax() const NN_NOEXCEPT;
        int GetLayerHeightPixelCountMax() const NN_NOEXCEPT;

        bool IsTouchscreen() const NN_NOEXCEPT;

        bool ValidateLayerDimensions(int width, int height) const NN_NOEXCEPT;
        bool ValidateZOrder(int z) const NN_NOEXCEPT;
        bool ValidateScalingMode(nn::vi::ScalingMode mode) const NN_NOEXCEPT;

        void WriteInfo(nn::vi::DisplayInfo* pOutInfo) const NN_NOEXCEPT;
    private:
        char m_Name[nn::vi::DisplayInfo::NameLengthMax];
        DisplayPolicy m_Policy;
        DisplaySupport m_Support;

        int m_LayerWidthPixelCountMax;
        int m_LayerHeightPixelCountMax;

        bool m_isTouchscreen;
    };

}}}}
