﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_Abort.h>
#include <nn/util/util_ScopeExit.h>
#include <nn/result/result_HandlingUtility.h>
#include <nn/vi/vi_Result.h>
#include "visrv_Nvdc.h"

namespace
{
    nvdcHandle g_Handle = nullptr;
}

void nn::visrv::master::nvdc::Initialize() NN_NOEXCEPT
{
    int fd = NvRm_MemmgrGetIoctlFile();
    NN_ABORT_UNLESS(fd > 0);

    g_Handle = nvdcOpen(fd);
    NN_ABORT_UNLESS(g_Handle != nullptr);
}

void nn::visrv::master::nvdc::Finalize() NN_NOEXCEPT
{
    if( g_Handle != nullptr )
    {
        nvdcClose(g_Handle);
        g_Handle = nullptr;
    }
}

nn::Result nn::visrv::master::nvdc::GetConnectionState(nn::vi::HotplugStateType* pOutState, nvdcDisplayType interface) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(g_Handle);

    nvdcDisplay** displays = nullptr;
    int displayCount;
    NN_RESULT_THROW_UNLESS(nvdcQueryDisplays(g_Handle, &displays, &displayCount) == NvSuccess,
                           nn::vi::ResultOperationFailed());

    NN_UTIL_SCOPE_EXIT
    {
        nvdcFreeDisplays(g_Handle, displays);
    };

    for( int i = 0; i < displayCount; ++i )
    {
        nvdcDisplayInfo info;
        NN_RESULT_THROW_UNLESS(nvdcQueryDisplayInfo(g_Handle, displays[i], &info) == NvSuccess,
                               nn::vi::ResultOperationFailed());

        if( info.type == interface )
        {
            if( info.connected )
            {
                *pOutState = nn::vi::HotplugState_Connected;
            }
            else
            {
                *pOutState = nn::vi::HotplugState_Disconnected;
            }

            NN_RESULT_SUCCESS;
        }
    }

    NN_RESULT_THROW(nn::vi::ResultOperationFailed());
}
