﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/vi/vi_Result.h>
#include "visrv_NullDisplay.h"

namespace nn { namespace visrv { namespace master { namespace detail {

    NullDisplay::NullDisplay() NN_NOEXCEPT
        : AndroidDisplay(&m_Filter, android::ISurfaceComposer::eDisplayIdNull, nn::vi::LayerStack_Null)
    {
    }

    nn::Result NullDisplay::GetHotplugState(nn::vi::HotplugStateType* pOutState) const NN_NOEXCEPT
    {
        NN_UNUSED(pOutState);

        return nn::vi::ResultNotSupported();
    }

    int NullDisplay::ListModes(nn::vi::DisplayModeInfo* pOutModes, int modeCountMax) const NN_NOEXCEPT
    {
        NN_UNUSED(pOutModes);
        NN_UNUSED(modeCountMax);
        NN_UNUSED(pFilter);

        return 0;
    }

    nn::Result NullDisplay::GetMode(nn::vi::DisplayModeInfo* pOutMode) const NN_NOEXCEPT
    {
        NN_UNUSED(pOutMode);

        return nn::vi::ResultOperationFailed();
    }

    nn::Result NullDisplay::SetMode(const nn::vi::DisplayModeInfo& mode) NN_NOEXCEPT
    {
        NN_UNUSED(mode);
        NN_UNUSED(pFilter);

        return nn::vi::ResultNotSupported();
    }

    int NullDisplay::ListRgbRanges(nn::vi::RgbRangeType* pOutRanges, int rgbRangeCountMax) const NN_NOEXCEPT
    {
        NN_UNUSED(pOutRanges);
        NN_UNUSED(rgbRangeCountMax);

        return 0;
    }

    nn::Result NullDisplay::GetRgbRange(nn::vi::RgbRangeType* pOutRange) const NN_NOEXCEPT
    {
        NN_UNUSED(pOutRange);

        return nn::vi::ResultOperationFailed();
    }

    nn::Result NullDisplay::SetRgbRange(nn::vi::RgbRange range) NN_NOEXCEPT
    {
        NN_UNUSED(range);

        return nn::vi::ResultNotSupported();
    }

    nn::Result NullDisplay::SetUnderscan(int underscan) NN_NOEXCEPT
    {
        NN_UNUSED(underscan);

        return nn::vi::ResultNotSupported();
    }

    nn::Result NullDisplay::GetUnderscan(int* pOutUnderscan) const NN_NOEXCEPT
    {
        NN_UNUSED(pOutUnderscan);

        return nn::vi::ResultNotSupported();
    }

    nn::Result NullDisplay::SetAlpha(float alpha) NN_NOEXCEPT
    {
        NN_UNUSED(alpha);

        return nn::vi::ResultNotSupported();
    }

    nn::Result NullDisplay::SetPowerState(nn::vi::PowerState state) NN_NOEXCEPT
    {
        NN_UNUSED(state);

        return nn::vi::ResultNotSupported();
    }

    nn::Result NullDisplay::SetCmuLuma(float luma) NN_NOEXCEPT
    {
        NN_UNUSED(luma);

        return nn::vi::ResultNotSupported();
    }

    nn::Result NullDisplay::GetCmuLuma(float* pOutLuma) const NN_NOEXCEPT
    {
        NN_UNUSED(pOutLuma);

        return nn::vi::ResultNotSupported();
    }

    bool NullDisplay::IsHotplugEventSupported() const NN_NOEXCEPT
    {
        return false;
    }

    bool NullDisplay::IsVsyncEventSupported() const NN_NOEXCEPT
    {
        return false;
    }

    bool NullDisplay::IsModeChangedEventSupported() const NN_NOEXCEPT
    {
        return false;
    }

    nn::Result NullDisplay::GetLogicalResolution(int* pOutWidth, int* pOutHeight) const NN_NOEXCEPT
    {
        NN_UNUSED(pOutWidth);
        NN_UNUSED(pOutHeight);

        return nn::vi::ResultNotSupported();
    }

    nn::Result NullDisplay::GetCmuMode(nn::vi::CmuModeType* pOutMode) const NN_NOEXCEPT
    {
        NN_UNUSED(pOutMode);

        return nn::vi::ResultNotSupported();
    }

    nn::Result NullDisplay::SetCmuMode(nn::vi::CmuMode mode) NN_NOEXCEPT
    {
        NN_UNUSED(mode);

        return nn::vi::ResultNotSupported();
    }

    nn::Result NullDisplay::GetContrastRatio(float* pOutRatio) const NN_NOEXCEPT
    {
        NN_UNUSED(pOutRatio);

        return nn::vi::ResultNotSupported();
    }

    nn::Result NullDisplay::SetContrastRatio(float ratio) NN_NOEXCEPT
    {
        NN_UNUSED(ratio);

        return nn::vi::ResultNotSupported();
    }

    nn::Result NullDisplay::GetGamma(float* pOutGamma) const NN_NOEXCEPT
    {
        NN_UNUSED(pOutGamma);

        return nn::vi::ResultNotSupported();
    }

    nn::Result NullDisplay::SetGamma(float gamma) NN_NOEXCEPT
    {
        NN_UNUSED(gamma);

        return nn::vi::ResultNotSupported();
    }

}}}}
