﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_DisplayPolicy.h"

#include <cstring> // for memcpy
#include <nn/nn_SdkAssert.h>

namespace nn{ namespace visrv{ namespace master{ namespace detail{

    DisplayPolicy::DisplayPolicy(
        bool hasLayerLimit,
        int layerCountMax,
        int zOrderCountMin,
        int zOrderCountMax
        ) NN_NOEXCEPT
        : m_ZOrderCountMin(zOrderCountMin)
        , m_ZOrderCountMax(zOrderCountMax)
        , m_LayerCountMax(layerCountMax)
        , m_HasLayerLimit(hasLayerLimit)
    {
    }

    int DisplayPolicy::GetLayerCountMax() const NN_NOEXCEPT
    {
        return m_LayerCountMax;
    }

    int DisplayPolicy::GetZOrderCountMin() const NN_NOEXCEPT
    {
        return m_ZOrderCountMin;
    }

    int DisplayPolicy::GetZOrderCountMax() const NN_NOEXCEPT
    {
        return m_ZOrderCountMax;
    }

    bool DisplayPolicy::HasLayerLimit() const NN_NOEXCEPT
    {
        return m_HasLayerLimit;
    }

}}}}
