﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include "visrv_IDisplayStrategy.h"
#include "../../settings/visrv_DisplayController.h"

namespace nn { namespace visrv { namespace master { namespace detail {

    class DefaultDisplayStrategy : public IDisplayStrategy
    {
    public:
        DefaultDisplayStrategy() NN_NOEXCEPT;

        void Initialize(IPhysicalDisplay** pDisplays, int displayCount) NN_NOEXCEPT;

        virtual IPhysicalDisplay* GetDisplay() NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result Visit(DisplayVisitor visitor, void* userData) NN_NOEXCEPT NN_OVERRIDE;
    private:
        IPhysicalDisplay* m_Displays[settings::DisplayControllerCount];
        int m_DisplayCount;
    };

}}}}
