﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/result/result_HandlingUtility.h>
#include "visrv_DefaultDisplayStrategy.h"
#include "visrv_IPhysicalDisplay.h"

namespace nn { namespace visrv { namespace master { namespace detail {

    DefaultDisplayStrategy::DefaultDisplayStrategy() NN_NOEXCEPT
        : m_Displays{ 0 }
        , m_DisplayCount(0)
    {
    }

    void DefaultDisplayStrategy::Initialize(IPhysicalDisplay** pDisplays, int displayCount) NN_NOEXCEPT
    {
        NN_SDK_ASSERT_NOT_NULL(pDisplays);
        NN_SDK_ASSERT_GREATER(displayCount, 0);
        NN_SDK_ASSERT_LESS_EQUAL(displayCount, sizeof(m_Displays) / sizeof(m_Displays[0]));

        for( int i = 0; i < displayCount; ++i )
        {
            NN_SDK_ASSERT_NOT_NULL(pDisplays[i]);
            m_Displays[i] = pDisplays[i];
        }

        m_DisplayCount = displayCount;
    }

    IPhysicalDisplay* DefaultDisplayStrategy::GetDisplay() NN_NOEXCEPT
    {
        NN_SDK_ASSERT_GREATER(m_DisplayCount, 0);

        for( int i = 0; i < m_DisplayCount; ++i )
        {
            nn::vi::PowerStateType state;
            if( m_Displays[i]->GetPowerState(&state).IsSuccess() && state == nn::vi::PowerState_On )
            {
                return m_Displays[i];
            }
        }

        // use lowest priority display
        return m_Displays[m_DisplayCount - 1];
    }

    nn::Result DefaultDisplayStrategy::Visit(DisplayVisitor visitor, void* userData) NN_NOEXCEPT
    {
        NN_SDK_ASSERT_GREATER(m_DisplayCount, 0);
        NN_SDK_ASSERT_NOT_NULL(visitor);

        for( int i = 0; i < m_DisplayCount; ++i )
        {
            NN_RESULT_DO(visitor(m_Displays[i], userData));
        }
        NN_RESULT_SUCCESS;
    }

}}}}
