﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include "visrv_WhitelistFilter.h"
#include "visrv_SingleDisplayStrategy.h"
#include "visrv_EdidDisplay.h"

namespace nn { namespace vi {
    struct DisplayModeInfoInternal;
}}

namespace nn { namespace visrv { namespace master { namespace detail {
    class Allocator;
}}}}

namespace nn { namespace visrv { namespace settings {
    enum class InterfaceType;
}}}

namespace nn { namespace visrv { namespace master { namespace detail {

    class IPhysicalDisplay;
    class IDisplayStrategy;

    class Controller
    {
    public:
        explicit Controller(Allocator* pAllocator) NN_NOEXCEPT;
        ~Controller() NN_NOEXCEPT;

        void Initialize(settings::InterfaceType, const nn::vi::DisplayModeInfoInternal* pModes, int modeCount) NN_NOEXCEPT;

        IPhysicalDisplay* GetDisplay() NN_NOEXCEPT;
        IDisplayStrategy* GetStrategy() NN_NOEXCEPT;

        IPhysicalDisplay* GetEdid() NN_NOEXCEPT;
        IDisplayStrategy* GetEdidStrategy() NN_NOEXCEPT;
    private:
        Allocator* m_pAllocator;

        IPhysicalDisplay* m_pDisplay;
        SingleDisplayStrategy m_Strategy;

        EdidDisplay m_Edid;
        SingleDisplayStrategy m_EdidStrategy;

        WhiteListFilter m_Filter;
    };

}}}}
