﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_Autolock.h"

namespace nn{ namespace visrv{ namespace master{ namespace detail{

    Autolock::Autolock(nn::os::Mutex* pLock) NN_NOEXCEPT
        : m_pLock(pLock)
    {
        m_pLock->Lock();
    }

    Autolock::Autolock(Autolock&& copy) NN_NOEXCEPT
        : m_pLock(copy.m_pLock)
    {
        // mutex is already locked by other object
        copy.m_pLock = nullptr;
    }

    Autolock::~Autolock() NN_NOEXCEPT
    {
        if( m_pLock != nullptr )
        {
            m_pLock->Unlock();
        }
    }

}}}}
