﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/vi/vi_LogicalResolution.h>
#include "visrv_Android.h"
#include "visrv_IPhysicalDisplay.h"

namespace nn { namespace visrv{ namespace master { namespace detail {

    class AndroidDisplay : public IPhysicalDisplay
    {
    public:
        virtual ~AndroidDisplay() NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result Open() NN_NOEXCEPT NN_OVERRIDE;
        virtual void Close() NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result GetHotplugState(nn::vi::HotplugStateType* pOutState) const NN_NOEXCEPT NN_OVERRIDE = 0;
        virtual nn::Result GetMode(nn::vi::DisplayModeInfo* pOutMode) const NN_NOEXCEPT NN_OVERRIDE;

        virtual int ListModes(nn::vi::DisplayModeInfo* pOutModes, int modeCountMax) const NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result SetMode(const nn::vi::DisplayModeInfo& mode) NN_NOEXCEPT NN_OVERRIDE;

        virtual int ListRgbRanges(nn::vi::RgbRangeType* pOutRanges, int rgbCountMax) const NN_NOEXCEPT NN_OVERRIDE = 0;
        virtual nn::Result GetRgbRange(nn::vi::RgbRangeType* pOutRange) const NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result SetRgbRange(nn::vi::RgbRange range) NN_NOEXCEPT NN_OVERRIDE = 0;

        virtual nn::Result SetUnderscan(int underscan) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result GetUnderscan(int* pOutUnderscan) const NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result SetAlpha(float alpha) NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result GetPowerState(nn::vi::PowerStateType* pOutState) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result SetPowerState(nn::vi::PowerState state) NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result SetLayerStack(nn::vi::LayerStackType id) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result GetLayerStack(nn::vi::LayerStackType* pOutStack) const NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result SetCmuLuma(float luma) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result GetCmuLuma(float* pOutLuma) const NN_NOEXCEPT NN_OVERRIDE;

        virtual bool IsHotplugEventSupported() const NN_NOEXCEPT NN_OVERRIDE = 0;
        virtual bool IsVsyncEventSupported() const NN_NOEXCEPT NN_OVERRIDE = 0;

        virtual nn::Result GetLogicalResolution(int* pOutWidth, int* pOutHeight) const NN_NOEXCEPT NN_OVERRIDE;

        virtual nn::Result GetCmuMode(nn::vi::CmuModeType* pOutMode) const NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result SetCmuMode(nn::vi::CmuMode mode) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result GetContrastRatio(float* pOutRatio) const NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result SetContrastRatio(float ratio) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result GetGamma(float* pOutGamma) const NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result SetGamma(float gamma) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result SetViewport(int x, int y, int width, int height) NN_NOEXCEPT NN_OVERRIDE;
        virtual nn::Result GetCompositorErrorInfo(nn::vi::CompositorError* pOutErrorInfo, int* pOutLength, int errorID) NN_NOEXCEPT NN_OVERRIDE;
    protected:
        AndroidDisplay(const IModeFilter* pFilter, int id, nn::vi::LayerStack stack) NN_NOEXCEPT;

        android::sp<android::IBinder> m_Display;
    private:
        int m_Id;

        android::SurfaceComposerClient& m_Client;

        float m_BrightnessMax;

        nn::vi::PowerState m_PowerState;
        nn::vi::LayerStack m_Stack;

        static android::status_t GetCmuMode(const android::sp<android::IBinder>& display, DisplayCMUMode& mode, float& adjustment) NN_NOEXCEPT;
    };

}}}}
