﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os.h>
#include "../util/visrv_TQueue.h"

namespace nn{ namespace visrv{ namespace local{

    class LocalRequestQueue
    {
    public:
        static const int Capacity = 10;

    private:
        struct RequestEntry
        {
            void (*function)(void*);
            void* userPtr;
        };


    public:
        LocalRequestQueue() NN_NOEXCEPT;

        void Initialize(
            void (*registerFunction)(nn::os::MultiWaitHolderType*, void*),
            void (*unregisterFunction)(nn::os::MultiWaitHolderType*, void*),
            void* userPtr,
            uintptr_t multiWaitTag
        ) NN_NOEXCEPT;

        void Finalize() NN_NOEXCEPT;

        void Process(nn::os::MultiWaitHolderType* pHolder, bool isUnlinked) NN_NOEXCEPT;

        // 非同期で要求を投げます。
        // function は vi のメインスレッド上で実行されます。
        // 同期的に処理を行いたい場合は function 内で同期します。
        void EnqueueAsync(void (*function)(void* userPtr), void* userPtr) NN_NOEXCEPT;

    private:
        util::TQueue<RequestEntry, Capacity, true> m_Queue;
        nn::os::MultiWaitHolderType m_Holder;

        void (*m_HolderRegisterFunction)(nn::os::MultiWaitHolderType*, void*);
        void (*m_HolderUnregisterFunction)(nn::os::MultiWaitHolderType*, void*);
        void* m_HolderFunctionUserPtr;
    };

}}}
