﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_LocalRequestQueue.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>
#include "visrv_LocalServerObject.h"

namespace nn{ namespace visrv{ namespace local{

    LocalRequestQueue::LocalRequestQueue() NN_NOEXCEPT
        : m_HolderRegisterFunction(nullptr)
        , m_HolderUnregisterFunction(nullptr)
    {
    }

    void LocalRequestQueue::Initialize(
        void (*registerFunction)(nn::os::MultiWaitHolderType*, void*),
        void (*unregisterFunction)(nn::os::MultiWaitHolderType*, void*),
        void* userPtr,
        uintptr_t multiWaitTag
    ) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(registerFunction);
        NN_SDK_REQUIRES_NOT_NULL(unregisterFunction);

        m_Queue.Initialize();
        m_Queue.InitializeDequeueableMultiWaitHolder(&m_Holder);
        m_Holder.userData = multiWaitTag;

        registerFunction(&m_Holder, userPtr);

        m_HolderRegisterFunction = registerFunction;
        m_HolderUnregisterFunction = unregisterFunction;
        m_HolderFunctionUserPtr = userPtr;
    }

    void LocalRequestQueue::Finalize() NN_NOEXCEPT
    {
        m_HolderUnregisterFunction(&m_Holder, m_HolderFunctionUserPtr);

        m_Queue.FinalizeDequeueableMultiWaitHolder(&m_Holder);
        m_Queue.Finalize();

        m_HolderRegisterFunction = nullptr;
        m_HolderUnregisterFunction = nullptr;
        m_HolderFunctionUserPtr = nullptr;
    }

    void LocalRequestQueue::Process(nn::os::MultiWaitHolderType* pHolder, bool isUnlinked) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_EQUAL(pHolder, &m_Holder);

        RequestEntry e = {};
        m_Queue.Dequeue(&e);

        if(e.function)
        {
            e.function(e.userPtr);
        }

        if(isUnlinked)
        {
            m_HolderRegisterFunction(&m_Holder, m_HolderFunctionUserPtr);
        }
    }

    void LocalRequestQueue::EnqueueAsync(void (*function)(void* userPtr), void* userPtr) NN_NOEXCEPT
    {
        NN_SDK_REQUIRES_NOT_NULL(function);

        RequestEntry e = {};
        e.function = function;
        e.userPtr = userPtr;

        m_Queue.Enqueue(e);
    }

}}}
