﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_InitializeLocalServer.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

#include "visrv_LocalServerObject.h"

namespace nn{ namespace visrv{ namespace local{

    void InitializeLocalServer(
        void (*multiWaitHolderRegisterFunction)(nn::os::MultiWaitHolderType* pHolder, void*),
        void (*multiWaitHolderUnregisterFunction)(nn::os::MultiWaitHolderType* pHolder, void*),
        void* multiWaitHolderUserPtr,
        uintptr_t localRequestQueueMultiWaitTag
    ) NN_NOEXCEPT
    {
        g_LocalRequestQueue.Initialize(
            multiWaitHolderRegisterFunction,
            multiWaitHolderUnregisterFunction,
            multiWaitHolderUserPtr,
            localRequestQueueMultiWaitTag
        );
    }

    void FinalizeLocalServer() NN_NOEXCEPT
    {
        g_LocalRequestQueue.Finalize();
    }

}}}
