﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/os.h>

namespace nn{ namespace visrv{ namespace indirect{

    class IndirectLockCounter
    {
    public:
        IndirectLockCounter() NN_NOEXCEPT;

        // 指定した ThreadId のスレッドをメインスレッドに設定します。
        void Initialize(nn::os::ThreadId mainThreadId) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        // ロックを取ります。
        // @pre スレッドがメインスレッド。
        void AcquireLock() NN_NOEXCEPT;

        // ロックを解放します。
        // どのスレッドからでも実行できます。
        void ReleaseLock() NN_NOEXCEPT;

        // ロックカウントが 0 になるまで待ちます。
        // TORIAEZU: @pre スレッドがメインスレッド
        void WaitUnlocked() NN_NOEXCEPT;

        // ロックされているかを返します。
        bool IsLocked() NN_NOEXCEPT;

    public:
        int m_Count;
        nn::os::ThreadId m_MainThreadId;
        nn::os::MutexType m_Mutex;
        nn::os::ConditionVariableType m_ConditionVariable;

    };

}}}
