﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include "visrv_IndirectLockCounter.h"
#include "visrv_IndirectCopyImageTransfer.h"

namespace nn{ namespace visrv{ namespace indirect{

    namespace detail
    {
        static const size_t IndirectConsumerBindStateExSize = sizeof(IndirectConsumerBindExStateTransfer);
        static const size_t IndirectConsumerBindStateExAlignment = NN_ALIGNOF(IndirectConsumerBindExStateTransfer);

        struct IndirectConsumerBindStateExStorage
        {
            NN_ALIGNAS(IndirectConsumerBindStateExAlignment) char _storage[IndirectConsumerBindStateExSize];
        };
    }

    enum IndirectConsumerBoundMode
    {
        IndirectConsumerBoundMode_None,
        IndirectConsumerBoundMode_MapDefer,
        IndirectConsumerBoundMode_Transfer,
    };

    struct IndirectConsumerBoundId
    {
    public:
        bool operator==(const IndirectConsumerBoundId& v) const NN_NOEXCEPT;
    public:
        uint64_t value;
    };

    class IndirectConsumerBindState
    {
    public:
        IndirectConsumerBindState() NN_NOEXCEPT;

        void InitializeMapDefer() NN_NOEXCEPT;
        nn::Result InitializeTransfer(
            nn::os::NativeHandle* pOutIsBufferReadyEventHandle,
            bool* pOutIsBufferReadyEventHandleManaged,
            nn::os::NativeHandle bufferTransferMemoryHandle,
            bool* pIsBufferTransferMemoryHandleManaged,
            size_t bufferTransferMemorySize,
            int width,
            int height
        ) NN_NOEXCEPT;

        void Finalize() NN_NOEXCEPT;

        IndirectConsumerBoundMode GetBoundMode() const NN_NOEXCEPT;
        IndirectConsumerBoundId   GetBoundId() const NN_NOEXCEPT;
        IndirectLockCounter*      GetLockCounter() NN_NOEXCEPT;

        IndirectConsumerBindExStateTransfer* GetExStateTransfer() NN_NOEXCEPT;

    private:
        IndirectConsumerBoundMode m_BoundMode;
        IndirectConsumerBoundId   m_BoundId;
        IndirectLockCounter       m_LockCounter;

        IndirectConsumerBindExStateTransfer* m_pExStateTransfer;
        detail::IndirectConsumerBindStateExStorage m_ExStorage;
    };

}}}
