﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "visrv_GrAlloc.h"

#include <nn/result/result_HandlingUtility.h>
#include <nn/util/util_ScopeExit.h>

#include <hardware/hardware.h>
#include <hardware/gralloc.h>

namespace nn{ namespace visrv{ namespace fbshare{

    GrAlloc::GrAlloc() NN_NOEXCEPT
        : m_pModule(nullptr)
        , m_pGrAlloc(nullptr)
    {
    }

    void GrAlloc::Initialize() NN_NOEXCEPT
    {
        int result = 0;
        result = hw_get_module(GRALLOC_HARDWARE_MODULE_ID, &m_pModule);
        NN_ABORT_UNLESS_EQUAL(result, 0);

        result = gralloc_open(m_pModule, &m_pGrAlloc);
        NN_ABORT_UNLESS_EQUAL(result, 0);
    }

    void GrAlloc::Finalize() NN_NOEXCEPT
    {
        gralloc_close(m_pGrAlloc);
        m_pGrAlloc = nullptr;
        m_pModule  = nullptr;
    }

    alloc_device_t* GrAlloc::Get() const NN_NOEXCEPT
    {
        return m_pGrAlloc;
    }

}}}
