﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>
#include <nn/os/os_SystemEventTypes.h>
#include <nn/os/os_MultipleWaitTypes.h>
#include <nn/vi/sf/vi_ServiceTypes.h>
#include "../visrv_Config.h"

namespace nn{ namespace visrv{ namespace master{
    class Display;
}}}

namespace nn{ namespace visrv{ namespace client{

    class SystemEventSplitter
    {
    public:
        SystemEventSplitter() NN_NOEXCEPT;
        ~SystemEventSplitter() NN_NOEXCEPT;

        nn::Result Initialize(
            int destinationCountMax,
            nn::os::SystemEventType* pDestinationSystemEventList,
            nn::vi::DisplayId* pDestinationDisplayIdList,
            nn::os::NativeHandle sourceEventHandle,
            bool isManaged
        ) NN_NOEXCEPT;
        void Finalize() NN_NOEXCEPT;

        bool IsInitialized() const NN_NOEXCEPT;

        nn::Result CreateSplittedEvent(nn::os::NativeHandle* pOutHandle, nn::vi::DisplayId displayId) NN_NOEXCEPT;
        void RemoveSplittedEvents(nn::vi::DisplayId displayId) NN_NOEXCEPT;

        nn::os::MultiWaitHolderType* GetSourceMultiWaitHolder() NN_NOEXCEPT;
        nn::os::SystemEventType* GetSourceEvent() NN_NOEXCEPT;
        void SignalSplittedEvents() NN_NOEXCEPT;
        int GetSplittedEventCount() const NN_NOEXCEPT;

        static void OnSourceEventSignaled(void* pArg) NN_NOEXCEPT;

    private:
        bool             m_IsInitialized;
        int              m_DestinationCountMax;
        nn::os::MultiWaitHolderType m_SourceWaitHolder;
        nn::os::SystemEventType     m_SourceSystemEvent;
        nn::os::SystemEventType*    m_pDestinationSystemEventList;
        nn::vi::DisplayId*          m_pDestinationDisplayIdList;
    };

    template<int TDestinationCountMax>
    class SystemEventSplitterHolder
    {
    public:
        nn::Result Initialize(
            nn::os::NativeHandle sourceEventHandle,
            bool isManaged
        ) NN_NOEXCEPT
        {
            return m_Impl.Initialize(
                TDestinationCountMax,
                m_DestinationSystemEventList,
                m_DestinationDisplayIdList,
                sourceEventHandle,
                isManaged
            );
        }

        void Finalize() NN_NOEXCEPT
        {
            m_Impl.Finalize();
        }

        SystemEventSplitter* Get() NN_NOEXCEPT
        {
            return &m_Impl;
        }

        const SystemEventSplitter* Get() const NN_NOEXCEPT
        {
            return &m_Impl;
        }

    private:
        SystemEventSplitter m_Impl;
        nn::os::SystemEventType m_DestinationSystemEventList[TDestinationCountMax];
        nn::vi::DisplayId m_DestinationDisplayIdList[TDestinationCountMax];
    };

    typedef SystemEventSplitterHolder<DisplayHotplugEventCountPerClientMax * ClientProcessCountMax> HotplugSplitter;
    typedef SystemEventSplitterHolder<(DisplayVsyncEventCountPerClientMax + DisplayVsyncEventDebugCountPerClientMax) * ClientProcessCountMax> VsyncSplitter;
    typedef SystemEventSplitterHolder<DisplayErrorReportEventCountPerClientMax * ClientProcessCountMax> ErrorReportSplitter;
    typedef SystemEventSplitterHolder<DisplayModeChangedEventCountPerClientMax * ClientProcessCountMax> ModeChangedSplitter;

    extern HotplugSplitter g_HotplugEventSplitter;
    extern VsyncSplitter g_VsyncEventSplitter;
    extern ErrorReportSplitter g_ErrorReportEventSplitter;
    extern ModeChangedSplitter g_ExternalModeChangedSplitter;

}}}
