﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "visrv_ClientObject.h"
#include "visrv_ClientDisplayHolder.h"
#include "visrv_ClientLayerHolder.h"

//---------------------
// Macro
//---------------------

#define NN_VISRV_CHECK_ALIVE()                  \
    NN_RESULT_THROW_UNLESS(                     \
        IsAlive(),                              \
        nn::vi::ResultOperationFailed()         \
    );

#define NN_VISRV_CHECK_NOT_NULL(p)          \
    NN_RESULT_THROW_UNLESS(                 \
        p != nullptr,                       \
        nn::vi::ResultOperationFailed()     \
    );

#define NN_VISRV_CHECK_MINMAX(value, min, max)  \
    NN_RESULT_THROW_UNLESS(                     \
        (value >= min) && (value <= max),       \
        nn::vi::ResultInvalidRange()            \
    );

#define NN_VISRV_CHECK_RANGE(value, beg, end)   \
    NN_RESULT_THROW_UNLESS(                     \
        (value >= beg) && (value < end),        \
        nn::vi::ResultInvalidRange()            \
    );


#define NN_VISRV_FIND_CLIENT_DISPLAY(VariableName, DisplayId)   \
    auto VariableName = ClientUtility::LookupDisplayHolder(&m_DisplayHolderList, DisplayId); \
    NN_RESULT_THROW_UNLESS(                                     \
        VariableName != nullptr,                                \
        nn::vi::ResultNotFound()                                \
    );                                                          \
    NN_SDK_ASSERT(VariableName->pDisplay->IsOpen());

#define NN_VISRV_FIND_CLIENT_LAYER(VariableName, LayerId)       \
    auto VariableName = ClientUtility::LookupLayerHolderOnClient(&m_LayerHolderList, this, LayerId); \
    NN_RESULT_THROW_UNLESS(                                     \
        VariableName != nullptr,                                \
        nn::vi::ResultNotFound()                                \
    );

namespace nn{ namespace visrv{ namespace client{

    class ClientUtility
    {
    public:
        static ClientDisplayHolder* LookupDisplayHolder(
            ClientDisplayHolderList* pList,
            nn::vi::DisplayId displayId
            ) NN_NOEXCEPT;

        static ClientDisplayHolder* LookupDisplayHolderByName(
            ClientDisplayHolderList* pList,
            const char* name
            ) NN_NOEXCEPT;

        static ClientLayerHolder* LookupLayerHolderOnClient(
            ClientLayerHolderOnClientList* pList,
            ClientObject* pClient,
            nn::vi::LayerId layerId
            ) NN_NOEXCEPT;
    };

}}}
