﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include "visrv_ClientConstants.h"

namespace nn{ namespace visrv{ namespace client{

    class ClientObject;
    class ClientObjectSmartHolder;

    class ClientObjectRefcount
    {
        friend class ClientObjectSmartHolder;

    public:
        bool IsAlive() const NN_NOEXCEPT
        {
            return m_IsAlive;
        }

    private:
        // sum of strong and weak reference counts
        int m_ReferenceCount;
        // whether strong reference remains (only one holder has strong reference)
        bool m_IsAlive;
    };

    class ClientObjectSmartHolder
    {
        NN_DISALLOW_COPY(ClientObjectSmartHolder);
        NN_DISALLOW_MOVE(ClientObjectSmartHolder);
    public:
        // allocate new instance and hold it.
        NN_IMPLICIT ClientObjectSmartHolder(const ClientConstants& clientConstants) NN_NOEXCEPT;
        // share v's instance and increment refcount.
        NN_IMPLICIT ClientObjectSmartHolder(ClientObjectSmartHolder* pHolder) NN_NOEXCEPT;
        // decrement refcount and delete instance if refcount == 0.
        ~ClientObjectSmartHolder() NN_NOEXCEPT;

        ClientObject* Get() NN_NOEXCEPT
        {
            return m_pInstance;
        }

        const ClientObject* Get() const NN_NOEXCEPT
        {
            return m_pInstance;
        }

        ClientObject* operator->() NN_NOEXCEPT
        {
            return m_pInstance;
        }

        const ClientObject* operator->() const NN_NOEXCEPT
        {
            return m_pInstance;
        }

    private:
        ClientObject* m_pInstance;
        bool m_IsStrong;
    };
}}}
