﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/os/os_SdkSystemEventApi.h>
#include <nn/vi/sf/vi_ServiceTypes.h>
#include <nn/applet/applet_FundamentalTypes.h>
#include "../visrv_Config.h"
#include "../master/visrv_Display.h"
#include "../master/visrv_Layer.h"
#include "visrv_PresentationTracer.h"

namespace nn{ namespace visrv{ namespace client{

    struct ClientDisplayHolder;
    class ClientObject;

    enum ClientLayerHolderState
    {
        // not created
        ClientLayerHolderState_Empty,

        // created by the manager but not bound to applet
        ClientLayerHolderState_Unbound,

        // created by the manager and bound to applet
        ClientLayerHolderState_Bound,

        // created by an applet not controlled by am
        ClientLayerHolderState_Stray,
    };

    struct LayerTexturePresentingEventInfo
    {
        bool isInitialized = false;
        nn::os::SystemEventType event = {};
    };

    struct ClientLayerHolder
    {
        ClientLayerHolderState state = ClientLayerHolderState_Empty;
        applet::AppletResourceUserId userAruid = {};

        master::Layer* pLayer = nullptr;
        ClientDisplayHolder* pDisplayHolder = nullptr;
        nn::vi::LayerId layerId = 0;

        ClientObject* pBoundClient = nullptr;

        PresentationTracer* pPresentationTracer = nullptr;
        LayerTexturePresentingEventInfo layerTexturePresentingEvent = {};

        nn::util::IntrusiveListNode nodeClient = {}; // NOTE: default value is NOT zero-fill!
        nn::util::IntrusiveListNode nodeDisplay = {};
    };

    typedef nn::util::IntrusiveList<
        ClientLayerHolder, nn::util::IntrusiveListMemberNodeTraits<ClientLayerHolder, &ClientLayerHolder::nodeClient>
        > ClientLayerHolderOnClientList;

    typedef nn::util::IntrusiveList<
        ClientLayerHolder, nn::util::IntrusiveListMemberNodeTraits<ClientLayerHolder, &ClientLayerHolder::nodeDisplay>
        > ClientLayerHolderOnDisplayList;

}}}
