﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/util/util_IntrusiveList.h>
#include <nn/vi/sf/vi_ServiceTypes.h>
#include <nn/vi/sf/vi_PolicyLevel.h>
#include "../visrv_Config.h"
#include "../master/visrv_Display.h"
#include "visrv_ClientLayerHolder.h"

namespace nn{ namespace visrv{ namespace client{

    struct ClientDisplayHolder
    {
    public:
        struct DisplayEventInfo
        {
            int hotplugEventCount;
            int vsyncEventCount;
            int vsyncEventDebugCount;
            int errorEventCount;
            int modeChangeEventCount;
        };
    public:
        const nn::visrv::master::detail::PlatformDisplayInfo& GetDisplayInfo() const NN_NOEXCEPT
        {
            return this->pDisplay->GetInfo(this->policyLevel);
        }

    public:
        master::Display*        pDisplay;
        nn::vi::DisplayId       displayId;
        nn::vi::DisplayName     name;
        nn::vi::PolicyLevelType policyLevel;

        DisplayEventInfo displayEventInfo;

        ClientLayerHolderOnDisplayList layerList;

        nn::util::IntrusiveListNode node;
    };

    typedef nn::util::IntrusiveList<
        ClientDisplayHolder, nn::util::IntrusiveListMemberNodeTraits<ClientDisplayHolder, &ClientDisplayHolder::node>
        > ClientDisplayHolderList;

}}}
