﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/vi/vi_Layer.private.h>
#include <nn/vi/vi_Result.h>
#include <nn/vi/vi_LayerConfig.h>
#include "detail/vi_Common.h"
#include "vi_Layer.h"
#include "vi_Display.h"

nn::Result nn::vi::SetLayerPosition(Layer* pLayer, float x, float y) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pLayer);

    return pLayer->SetPosition(x, y);
}

nn::Result nn::vi::SetLayerSize(Layer* pLayer, int width, int height) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pLayer);

    if( width < 0 || width > 1920 ||
        height < 0 || height > 1080 )
    {
        return nn::vi::ResultInvalidDimensions();
    }

    return pLayer->SetSize(width, height);
}

nn::Result nn::vi::SetLayerZ(Layer* pLayer, int z) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pLayer);

    Display* display = pLayer->GetDisplay();

    if( display->GetInfo().GetPolicy().GetZOrderCountMin() > z &&
        display->GetInfo().GetPolicy().GetZOrderCountMax() < z )
    {
        return nn::vi::ResultInvalidRange();
    }

    return pLayer->SetZ(z);
}

nn::Result nn::vi::GetLayerZ(int* pOutZ, const Layer* pLayer) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pOutZ);
    NN_SDK_REQUIRES_NOT_NULL(pLayer);

    *pOutZ = pLayer->GetZ();

    return nn::ResultSuccess();
}

nn::Result nn::vi::SetLayerAlpha(Layer* pLayer, float alpha) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pLayer);

    NN_UNUSED(pLayer);
    NN_UNUSED(alpha);

    return nn::ResultSuccess();
}

nn::Result nn::vi::SetLayerVisibility(Layer* pLayer, bool isVisible) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pLayer);

    NN_UNUSED(pLayer);
    NN_UNUSED(isVisible);

    return nn::ResultSuccess();
}
