﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/nn_SdkAssert.h>
#include <nn/vi/vi_Cmu.h>
#include "detail/vi_Common.h"
#include "vi_Display.h"

nn::Result nn::vi::GetDisplayCmuMode(CmuMode* pOutMode, const Display* pDisplay) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pOutMode);
    NN_SDK_REQUIRES_NOT_NULL(pDisplay);
    NN_SDK_REQUIRES(pDisplay->IsOpen());

    NN_UNUSED(pOutMode);
    NN_UNUSED(pDisplay);

    return nn::ResultSuccess();
}

nn::Result nn::vi::SetDisplayCmuMode(Display* pDisplay, CmuMode mode) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pDisplay);
    NN_SDK_REQUIRES(pDisplay->IsOpen());

    NN_UNUSED(pDisplay);
    NN_UNUSED(mode);

    return nn::ResultSuccess();
}

nn::Result nn::vi::GetDisplayContrastRatio(float* pOutRatio, const Display* pDisplay) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pOutRatio);
    NN_SDK_REQUIRES_NOT_NULL(pDisplay);
    NN_SDK_REQUIRES(pDisplay->IsOpen());

    NN_UNUSED(pOutRatio);
    NN_UNUSED(pDisplay);

    return nn::ResultSuccess();
}

nn::Result nn::vi::SetDisplayContrastRatio(Display* pDisplay, float ratio) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pDisplay);
    NN_SDK_REQUIRES(pDisplay->IsOpen());

    NN_UNUSED(pDisplay);
    NN_UNUSED(ratio);

    return nn::ResultSuccess();
}

nn::Result nn::vi::GetDisplayGamma(float* pOutGamma, const Display* pDisplay) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pOutGamma);
    NN_SDK_REQUIRES_NOT_NULL(pDisplay);
    NN_SDK_REQUIRES(pDisplay->IsOpen());

    NN_UNUSED(pOutGamma);
    NN_UNUSED(pDisplay);

    return nn::ResultSuccess();
}

nn::Result nn::vi::SetDisplayGamma(Display* pDisplay, float gamma) NN_NOEXCEPT
{
    NN_SDK_REQUIRES(detail::IsInitialized());
    NN_SDK_REQUIRES_NOT_NULL(pDisplay);
    NN_SDK_REQUIRES(pDisplay->IsOpen());

    NN_UNUSED(pDisplay);
    NN_UNUSED(gamma);

    return nn::ResultSuccess();
}
