﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cmath>
#include <nn/vi/vi_DisplayModeInfo.h>
#include "vi_WhitelistFilter.h"

nn::vi::detail::WhiteListFilter::WhiteListFilter() NN_NOEXCEPT
    : m_pValidModes(nullptr)
    , m_ValidModeCountMax(0)
{
}

void nn::vi::detail::WhiteListFilter::Initialize(const DisplayModeInfo* pValidModes, int validModeCountMax) NN_NOEXCEPT
{
    m_pValidModes = pValidModes;
    m_ValidModeCountMax = validModeCountMax;
}

bool nn::vi::detail::WhiteListFilter::IsValid(const DisplayModeInfo& pMode) const NN_NOEXCEPT
{
    for( int i = 0; i < m_ValidModeCountMax; ++i )
    {
        if( m_pValidModes[i].width == pMode.width &&
            m_pValidModes[i].height == pMode.height &&
            m_pValidModes[i].mode == pMode.mode )
        {
            float error = std::abs(m_pValidModes[i].refreshRate - pMode.refreshRate);

            if( error <= 0.001f )
            {
                return true;
            }
        }
    }

    return false;
}
