﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <new>
#include <nn/lmem/lmem_UnitHeap.h>

namespace nn { namespace vi { namespace detail {

    template <typename T>
    class PoolAllocator
    {
    public:
        PoolAllocator(void* startAddress, size_t size, int alignment)
            : m_Heap(nullptr)
        {
            // TODO: do we need the thread safe option?
            m_Heap = nn::lmem::CreateUnitHeap(startAddress, size, sizeof(T), lmem::CreationOption_NoOption, alignment, &m_Head);
            NN_SDK_ASSERT_NOT_NULL(m_Heap);
        }

        ~PoolAllocator()
        {
            if( m_Heap != nullptr )
            {
                nn::lmem::DestroyUnitHeap(m_Heap);
            }
        }

        void* Allocate()
        {
            return nn::lmem::AllocateFromUnitHeap(m_Heap);
        }

        void Free(T* ptr)
        {
            nn::lmem::FreeToUnitHeap(m_Heap, ptr);
        }
    private:
        nn::lmem::HeapHandle m_Heap;
        nn::lmem::HeapCommonHead m_Head;
    };

}}}
