﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <new>
#include <nn/nn_SdkAssert.h>
#include <nn/vi/vi_DisplayModeInfo.h>
#include <nn/vi/vi_DisplayMode.private.h>
#include "vi_Policies.h"
#include "vi_PlatformDisplayInfo.h"
#include "vi_PlatformDisplayDefines.h"
// TODO: remove these headers for SIGLONTD-3692
#include "vi_Android.h"
#include <binder/Parcel.h>

int nn::vi::detail::SetupCompositionPolicy(PlatformDisplayInfo* pOutDisplays, int displayCountMax)
{
    // SIGLONTD-3692 enable scaling/alpha blending by default
    // Note this is a system wide setting and this shouldn't be here permanently...
    android::SurfaceComposerClient client;
    client.incStrong(&client);

    android::sp<android::IBinder> binder = client.connection();

    android::Parcel data;
    data.writeInterfaceToken(binder->getInterfaceDescriptor());
    data.writeCString("nvidia.hwc.war_1515812");
    data.writeCString("0");
    binder->transact(1006, data, nullptr);

    binder = nullptr;
    client.dispose();

    DisplaySupport support;
    support.queryPixelFormatSupport = PixelFormatSupport;
    support.queryScalingModeSupport = ScalingModeSupport;

    DisplayModeInfo modes[] =
    {
        {
            720,
            480,
            60.00f,
            StereoMode_None
        },

        {
            1280,
            720,
            60.00f,
            StereoMode_None
        },

        {
            1920,
            1080,
            60.00f,
            StereoMode_None
        },
    };

    const int modeCount = sizeof(modes) / sizeof(modes[0]);
    NN_STATIC_ASSERT(modeCount < DisplayModeCountMax);

    // need room for at least this many policies
    const int NamedDisplayCount = 4;
    NN_SDK_ASSERT(displayCountMax >= NamedDisplayCount);

    PlatformDisplayInfo* block = pOutDisplays;

    new (block++) PlatformDisplayInfo(DefaultDisplayName,
                                      1920,
                                      1080,
                                      DisplayPolicy(true,
                                                    2,
                                                    1,
                                                    2,
                                                    modes,
                                                    modeCount),
                                      support,
                                      true);

    new (block++) PlatformDisplayInfo(ExternalDisplayName,
                                      1920,
                                      1080,
                                      DisplayPolicy(true,
                                                    0,
                                                    0,
                                                    0,
                                                    modes,
                                                    modeCount),
                                      support,
                                      false);

    new (block++) PlatformDisplayInfo(EdidDisplayName,
                                      0,
                                      0,
                                      DisplayPolicy(true,
                                                    0,
                                                    0,
                                                    0,
                                                    modes,
                                                    modeCount),
                                      support,
                                      false);

    new (block++) PlatformDisplayInfo(InternalDisplayName,
                                      1920,
                                      1080,
                                      DisplayPolicy(true,
                                                    0,
                                                    0,
                                                    0,
                                                    modes,
                                                    modeCount),
                                      support,
                                      false);

    return NamedDisplayCount;
}

int nn::vi::detail::SetupStandardPolicy(PlatformDisplayInfo* pOutDisplays, int displayCountMax)
{
    DisplaySupport support;
    support.queryPixelFormatSupport = PixelFormatSupport;
    support.queryScalingModeSupport = ScalingModeSupport;

    DisplayModeInfo modes[] =
    {
        {
            720,
            480,
            60.00f,
            StereoMode_None
        },

        {
            1280,
            720,
            60.00f,
            StereoMode_None
        },

        {
            1920,
            1080,
            60.00f,
            StereoMode_None
        },
    };

    const int modeCount = sizeof(modes) / sizeof(modes[0]);
    NN_STATIC_ASSERT(modeCount < DisplayModeCountMax);

    // need room for at least this many policies
    const int NamedDisplayCount = 1;
    NN_SDK_ASSERT(displayCountMax >= NamedDisplayCount);

    // TODO: process policy
    new (pOutDisplays) PlatformDisplayInfo(DefaultDisplayName,
                                           1920,
                                           1080,
                                           DisplayPolicy(true,
                                                         1,
                                                         0,
                                                         0,
                                                         modes,
                                                         modeCount),
                                           support,
                                           true);

    return NamedDisplayCount;
}
