﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "vi_IPhysicalDisplay.h"

nn::vi::detail::IPhysicalDisplay::~IPhysicalDisplay() NN_NOEXCEPT
{
}

int nn::vi::detail::WriteCeFormatRgbRange(RgbRange* pOutRanges, int rgbCountMax, bool isSelectable) NN_NOEXCEPT
{
    int writeIndex = 0;
    if( writeIndex < rgbCountMax )
    {
        pOutRanges[writeIndex++] = nn::vi::RgbRange_Limited;
    }

    if( writeIndex < rgbCountMax && isSelectable )
    {
        pOutRanges[writeIndex++] = nn::vi::RgbRange_Full;
    }

    return writeIndex;
}
