﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "vi_Edid.h"

bool nn::vi::detail::ConvertStereoMode(StereoMode* pOutMode, nn::edid::StereoMode mode) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pOutMode);

    switch( mode )
    {
    case nn::edid::StereoMode_None:
        *pOutMode = StereoMode_None;
        return true;
    case nn::edid::StereoMode_FramePacking:
        *pOutMode = StereoMode_FramePacking;
        return true;
    case nn::edid::StereoMode_TopAndBottom:
        *pOutMode = StereoMode_TopAndBottom;
        return true;
    case nn::edid::StereoMode_SideBySide:
        *pOutMode = StereoMode_SideBySide;
        return true;
    default:
        // not everything has a mapping in nn::vi
        return false;
    }
}

bool nn::vi::detail::ConvertDisplayMode(DisplayModeInfo* pOutMode, const nn::edid::DisplayModeInfo* pMode) NN_NOEXCEPT
{
    NN_SDK_ASSERT_NOT_NULL(pOutMode);
    NN_SDK_ASSERT_NOT_NULL(pMode);

    if( !ConvertStereoMode(&pOutMode->mode, pMode->stereoMode) )
    {
        return false;
    }

    pOutMode->width = pMode->width;
    pOutMode->height = pMode->height;
    pOutMode->refreshRate = pMode->refreshRate;

    return true;
}
