﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Macro.h>
#include <nn/vi/vi_ScalingMode.h>
#include <nn/vi/vi_PixelFormat.h>
#include <nn/vi/vi_RgbRange.h>
#include <nn/vi/vi_PowerState.h>
#include <nn/vi/vi_LayerSettings.h>
#include <nvnflinger_service.h>

namespace nn { namespace vi {
    struct DisplayModeInfo;
}}

namespace nn { namespace vi { namespace detail {

    /**
     * @brief Converts to Android scaling mode format.
     *
     * @param[in] mode Scaling mode.
     *
     * @return Android scaling mode format.
     *
     * @pre  @a mode is a valid nn::vi::ScalingMode.
     * @post Android equivalent is returned.
     */
    int ConvertScalingMode(ScalingMode mode) NN_NOEXCEPT;

    /**
     * @brief Converts to Android pixel format.
     *
     * @param[in] format Pixel format.
     *
     * @return Android pixel format.
     */
    android::PixelFormat ConvertPixelFormat(PixelFormat format) NN_NOEXCEPT;

    void ConvertDisplayMode(DisplayModeInfo* pOutInfo, const android::DisplayInfo& info) NN_NOEXCEPT;

    RgbRange ConvertRgbRange(int range) NN_NOEXCEPT;
    int ConvertRgbRange(RgbRange range) NN_NOEXCEPT;

    int ConvertPowerState(PowerState state) NN_NOEXCEPT;

    std::uint32_t ConvertLayerSettings(LayerSettings settings) NN_NOEXCEPT;

    bool operator==(const nn::vi::DisplayModeInfo& viInfo, const android::DisplayInfo& androidInfo) NN_NOEXCEPT;
    bool operator==(const android::DisplayInfo& androidInfo, const nn::vi::DisplayModeInfo& viInfo) NN_NOEXCEPT;

}}}
