﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include "vi_Allocator.h"

nn::vi::detail::Allocator::Allocator(void* startAddress, size_t size) NN_NOEXCEPT
    : m_Heap(nn::lmem::CreateExpHeap(startAddress, size, nn::lmem::CreationOption_NoOption))
{
    NN_SDK_ASSERT_NOT_NULL(m_Heap);
}

nn::vi::detail::Allocator::~Allocator() NN_NOEXCEPT
{
    nn::lmem::DestroyExpHeap(m_Heap);
}

void nn::vi::detail::Allocator::Free(void* ptr) NN_NOEXCEPT
{
    nn::lmem::FreeToExpHeap(m_Heap, ptr);
}
