﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

#include "vi_DisplayHolder.h"
#include "vi_LayerHolder.h"

namespace nn{ namespace vi{

    class ObjectManager
    {
    private:
        static nn::os::Mutex m_DisplayLock;
        static nn::os::Mutex m_LayerLock;
    public:
    // Display
        static DisplayHolderList* GetValidDisplayHolderList() NN_NOEXCEPT;

        // @return iterator points to new element
        static DisplayHolderList::iterator CreateValidateDisplayHolder(DisplayId id, const char* name) NN_NOEXCEPT;
        // @return iterator following the given iterator
        static DisplayHolderList::iterator InvalidateDestroyDisplayHolder(DisplayHolderList::iterator it) NN_NOEXCEPT;

        static DisplayHolderList::iterator FindValidDisplayHolder(Display* pDisplay) NN_NOEXCEPT;
        static DisplayHolderList::const_iterator FindValidDisplayHolder(const Display* pDisplay) NN_NOEXCEPT;

        static DisplayHolderList::iterator FindValidDisplayHolderByName(const char* name) NN_NOEXCEPT;

        static nn::os::Mutex& GetDisplayLock() NN_NOEXCEPT;

    // Layer
        static LayerHolderList* GetValidLayerHolderList() NN_NOEXCEPT;

        // @return iterator points to new element
        static LayerHolderList::iterator CreateValidateLayerHolder(LayerId id, DisplayHolder* pDisplayHolder) NN_NOEXCEPT;
        // @return iterator following the given iterator
        static LayerHolderList::iterator InvalidateDestroyLayerHolder(LayerHolderList::iterator it) NN_NOEXCEPT;

        static LayerHolderList::iterator FindValidLayerHolder(Layer* pLayer) NN_NOEXCEPT;
        static LayerHolderList::const_iterator FindValidLayerHolder(const Layer* pLayer) NN_NOEXCEPT;

        static nn::os::Mutex& GetLayerLock() NN_NOEXCEPT;

    };

}}
