﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/nn_Result.h>

#include <nn/util/util_ScopeExit.h>

#define NN_VI_SCOPE_EXIT_UNLESS(cond, expr)  \
    NN_UTIL_SCOPE_EXIT {                        \
        if(!(cond)) {                           \
            expr;                               \
        }                                       \
    }

// 処理の開始を宣言する。
// 対応する NN_VI_PROCESS_SUCCESS() を書くこと。
#define NN_VI_PROCESS_START()    \
    bool nn_vi_process_is_success = false;   \
    bool warning_NN_VI_PROCESS_SUCCESS_is_not_placed;


// 失敗した場合の巻き戻し処理を宣言する。
// NN_VI_PROCESS_SUCCESS() が呼び出された後でスコープを抜けた場合には実行されない。
// NN_VI_PROCESS_START() および NN_VI_PROCESS_SUCCESS() と同じスコープに書くこと。
// expr ... 巻き戻し処理の expression。裸のカンマ(,)を含む場合には括弧で括ること。
//          statement を書いても大抵期待通り動作する。ダメなときはラムダ式で expression にするなど。
#define NN_VI_PROCESS_ROLLBACK(expr) \
    NN_VI_SCOPE_EXIT_UNLESS(nn_vi_process_is_success, expr)

#define NN_VI_PROCESS_SUCCESS()  \
    nn_vi_process_is_success = true; \
    NN_UNUSED(warning_NN_VI_PROCESS_SUCCESS_is_not_placed);
